/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.Util;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.EffectivePredicateExtractor;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.SubExpressionExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TestingColumnHandle;
import com.facebook.presto.sql.planner.TestingPartition;
import com.facebook.presto.sql.planner.TestingTableHandle;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestEffectivePredicateExtractor {
    private static final TableHandle DUAL_TABLE_HANDLE = new TableHandle("test", (ConnectorTableHandle)new TestingTableHandle());
    private static final Symbol A = new Symbol("a");
    private static final Symbol B = new Symbol("b");
    private static final Symbol C = new Symbol("c");
    private static final Symbol D = new Symbol("d");
    private static final Symbol E = new Symbol("e");
    private static final Symbol F = new Symbol("f");
    private static final Expression AE = TestEffectivePredicateExtractor.symbolExpr(A);
    private static final Expression BE = TestEffectivePredicateExtractor.symbolExpr(B);
    private static final Expression CE = TestEffectivePredicateExtractor.symbolExpr(C);
    private static final Expression DE = TestEffectivePredicateExtractor.symbolExpr(D);
    private static final Expression EE = TestEffectivePredicateExtractor.symbolExpr(E);
    private static final Expression FE = TestEffectivePredicateExtractor.symbolExpr(F);
    private static final Map<Symbol, Type> TYPES = ImmutableMap.builder().put((Object)A, (Object)BigintType.BIGINT).put((Object)B, (Object)BigintType.BIGINT).put((Object)C, (Object)BigintType.BIGINT).put((Object)D, (Object)BigintType.BIGINT).put((Object)E, (Object)BigintType.BIGINT).put((Object)F, (Object)BigintType.BIGINT).build();
    private Map<Symbol, ColumnHandle> scanAssignments;
    private TableScanNode baseTableScan;
    private ExpressionIdentityNormalizer expressionNormalizer;

    @BeforeMethod
    public void setUp() throws Exception {
        this.scanAssignments = ImmutableMap.builder().put((Object)A, (Object)TestEffectivePredicateExtractor.newColumnHandle("a")).put((Object)B, (Object)TestEffectivePredicateExtractor.newColumnHandle("b")).put((Object)C, (Object)TestEffectivePredicateExtractor.newColumnHandle("c")).put((Object)D, (Object)TestEffectivePredicateExtractor.newColumnHandle("d")).put((Object)E, (Object)TestEffectivePredicateExtractor.newColumnHandle("e")).put((Object)F, (Object)TestEffectivePredicateExtractor.newColumnHandle("f")).build();
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F)));
        this.baseTableScan = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, null, Optional.empty());
        this.expressionNormalizer = new ExpressionIdentityNormalizer();
    }

    @Test
    public void testAggregation() throws Exception {
        AggregationNode node = new AggregationNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.equals(CE, FE), TestEffectivePredicateExtractor.lessThan(DE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.lessThan(CE, DE), TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(2L)), TestEffectivePredicateExtractor.equals(EE, FE)})), (List)ImmutableList.of((Object)A, (Object)B, (Object)C), (Map)ImmutableMap.of((Object)C, (Object)TestEffectivePredicateExtractor.fakeFunction("test"), (Object)D, (Object)TestEffectivePredicateExtractor.fakeFunction("test")), (Map)ImmutableMap.of((Object)C, (Object)TestEffectivePredicateExtractor.fakeFunctionHandle("test"), (Object)D, (Object)TestEffectivePredicateExtractor.fakeFunctionHandle("test")), (Map)ImmutableMap.of(), AggregationNode.Step.FINAL, Optional.empty(), 1.0, Optional.empty());
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(2L)), TestEffectivePredicateExtractor.equals(BE, CE)}));
    }

    @Test
    public void testFilter() throws Exception {
        FilterNode node = TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, (Expression)new FunctionCall(QualifiedName.of((String)"rand", (String[])new String[0]), (List)ImmutableList.of())), TestEffectivePredicateExtractor.lessThan(BE, TestEffectivePredicateExtractor.number(10L))}));
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.lessThan(BE, TestEffectivePredicateExtractor.number(10L))));
    }

    @Test
    public void testProject() throws Exception {
        ProjectNode node = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))})), (Map)ImmutableMap.of((Object)D, (Object)AE, (Object)E, (Object)CE));
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(DE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.equals(DE, EE)}));
    }

    @Test
    public void testTopN() throws Exception {
        TopNNode node = new TopNNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))})), 1L, (List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST), true);
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))}));
    }

    @Test
    public void testLimit() throws Exception {
        LimitNode node = new LimitNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))})), 1L);
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))}));
    }

    @Test
    public void testSort() throws Exception {
        SortNode node = new SortNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))})), (List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST));
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))}));
    }

    @Test
    public void testWindow() throws Exception {
        WindowNode node = new WindowNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))})), (List)ImmutableList.of((Object)A), (List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST), new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.CURRENT_ROW, Optional.empty()), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))}));
    }

    @Test
    public void testTableScan() throws Exception {
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D)));
        TableScanNode node = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, null, Optional.empty());
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.TRUE_LITERAL);
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, null, Optional.of(new TableScanNode.GeneratedPartitions(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)))), (List)ImmutableList.of())));
        effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.FALSE_LITERAL);
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, null, Optional.of(new TableScanNode.GeneratedPartitions(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)))), (List)ImmutableList.of((Object)new Partition("test", (ConnectorPartition)new TestingPartition())))));
        effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.number(1L), AE)));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, null, Optional.of(new TableScanNode.GeneratedPartitions(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)))), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.tupleDomainPartition("test", (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)this.scanAssignments.get(B), (Object)Domain.singleValue((Comparable)Long.valueOf(2L)))))))));
        effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.number(2L), BE), TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.number(1L), AE)}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, null, Optional.of(new TableScanNode.GeneratedPartitions(TupleDomain.all(), (List)ImmutableList.of())));
        effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.FALSE_LITERAL);
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, null, Optional.of(new TableScanNode.GeneratedPartitions(TupleDomain.all(), (List)ImmutableList.of((Object)new Partition("test", (ConnectorPartition)new TestingPartition())))));
        effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.TRUE_LITERAL);
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(assignments.keySet()), assignments, null, Optional.of(new TableScanNode.GeneratedPartitions(TupleDomain.all(), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.tupleDomainPartition("test", (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)this.scanAssignments.get(B), (Object)Domain.singleValue((Comparable)Long.valueOf(2L)))))))));
        effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.number(2L), BE), TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.number(1L), AE)}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.of((Object)A), assignments, null, Optional.of(new TableScanNode.GeneratedPartitions(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)this.scanAssignments.get(D), (Object)Domain.singleValue((Comparable)Long.valueOf(3L)))), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.tupleDomainPartition("test", (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Comparable)Long.valueOf(1L)), (Object)this.scanAssignments.get(C), (Object)Domain.singleValue((Comparable)Long.valueOf(2L)))))))));
        effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.number(1L), AE)));
    }

    private static Partition tupleDomainPartition(String connectorId, final TupleDomain<ColumnHandle> tupleDomain) {
        return new Partition(connectorId, new ConnectorPartition(){

            public String getPartitionId() {
                throw new UnsupportedOperationException("not yet implemented");
            }

            public TupleDomain<ConnectorColumnHandle> getTupleDomain() {
                return Util.toConnectorDomain((TupleDomain)tupleDomain);
            }
        });
    }

    @Test
    public void testUnion() throws Exception {
        UnionNode node = new UnionNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(10L))), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.number(100L))})), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.number(100L))}))), (ListMultimap)ImmutableListMultimap.of((Object)A, (Object)B, (Object)A, (Object)C, (Object)A, (Object)E));
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(10L))));
    }

    @Test
    public void testInnerJoin() throws Exception {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(leftAssignments.keySet()), leftAssignments, null, Optional.empty());
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(rightAssignments.keySet()), rightAssignments, null, Optional.empty());
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.INNER, (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)leftScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))})), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)rightScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.number(100L))})), (List)criteria, Optional.empty(), Optional.empty());
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.number(100L)), TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.equals(BE, EE)}));
    }

    @Test
    public void testLeftJoin() throws Exception {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(leftAssignments.keySet()), leftAssignments, null, Optional.empty());
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(rightAssignments.keySet()), rightAssignments, null, Optional.empty());
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.LEFT, (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)leftScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))})), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)rightScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.number(100L))})), (List)criteria, Optional.empty(), Optional.empty());
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L)), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.isNull(DE), TestEffectivePredicateExtractor.isNull(EE)})}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.number(100L)), TestEffectivePredicateExtractor.isNull(FE)}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(DE)}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.isNull(EE)})}));
    }

    @Test
    public void testRightJoin() throws Exception {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(leftAssignments.keySet()), leftAssignments, null, Optional.empty());
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = new TableScanNode(TestEffectivePredicateExtractor.newId(), DUAL_TABLE_HANDLE, (List)ImmutableList.copyOf(rightAssignments.keySet()), rightAssignments, null, Optional.empty());
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.RIGHT, (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)leftScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L))})), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)rightScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.number(100L))})), (List)criteria, Optional.empty(), Optional.empty());
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.isNull(BE), TestEffectivePredicateExtractor.isNull(AE)})}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.isNull(CE)}), TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.number(100L)), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(AE)}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.isNull(BE)})}));
    }

    @Test
    public void testSemiJoin() throws Exception {
        SemiJoinNode node = new SemiJoinNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.number(100L))})), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(5L))), A, B, C, Optional.empty(), Optional.empty());
        Expression effectivePredicate = EffectivePredicateExtractor.extract((PlanNode)node, TYPES);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.number(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.number(100L))})));
    }

    private static ColumnHandle newColumnHandle(String name) {
        return new ColumnHandle("test", (ConnectorColumnHandle)new TestingColumnHandle(name));
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }

    private static FilterNode filter(PlanNode source, Expression predicate) {
        return new FilterNode(TestEffectivePredicateExtractor.newId(), source, predicate);
    }

    private static Expression symbolExpr(Symbol symbol) {
        return new QualifiedNameReference(symbol.toQualifiedName());
    }

    private static Expression number(long number) {
        return new LongLiteral(String.valueOf(number));
    }

    private static ComparisonExpression equals(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Type.EQUAL, expression1, expression2);
    }

    private static ComparisonExpression lessThan(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Type.LESS_THAN, expression1, expression2);
    }

    private static ComparisonExpression greaterThan(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN, expression1, expression2);
    }

    private static IsNullPredicate isNull(Expression expression) {
        return new IsNullPredicate(expression);
    }

    private static FunctionCall fakeFunction(String name) {
        return new FunctionCall(QualifiedName.of((String)"test", (String[])new String[0]), (List)ImmutableList.of());
    }

    private static Signature fakeFunctionHandle(String name) {
        return new Signature(name, "unknown", (List)ImmutableList.of());
    }

    private Set<Expression> normalizeConjuncts(Expression ... conjuncts) {
        return this.normalizeConjuncts(Arrays.asList(conjuncts));
    }

    private Set<Expression> normalizeConjuncts(Iterable<Expression> conjuncts) {
        return this.normalizeConjuncts(ExpressionUtils.combineConjuncts(conjuncts));
    }

    private Set<Expression> normalizeConjuncts(Expression predicate) {
        predicate = this.expressionNormalizer.normalize(predicate);
        EqualityInference inference = EqualityInference.createEqualityInference((Expression[])new Expression[]{predicate});
        HashSet<Expression> rewrittenSet = new HashSet<Expression>();
        for (Expression expression : EqualityInference.nonInferrableConjuncts((Expression)predicate)) {
            Expression rewritten = inference.rewriteExpression(expression, Predicates.alwaysTrue());
            Preconditions.checkState((rewritten != null ? 1 : 0) != 0, (Object)"Rewrite with full symbol scope should always be possible");
            rewrittenSet.add(rewritten);
        }
        rewrittenSet.addAll(inference.generateEqualitiesPartitionedBy(Predicates.alwaysTrue()).getScopeEqualities());
        return rewrittenSet;
    }

    private static class ExpressionIdentityNormalizer {
        private final Map<Expression, Expression> expressionCache = new HashMap<Expression, Expression>();

        private ExpressionIdentityNormalizer() {
        }

        private Expression normalize(Expression expression) {
            Expression identityNormalizedExpression = this.expressionCache.get(expression);
            if (identityNormalizedExpression == null) {
                for (Expression subExpression : Iterables.filter((Iterable)SubExpressionExtractor.extract((Expression)expression), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)expression)))) {
                    this.normalize(subExpression);
                }
                identityNormalizedExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionNodeInliner(this.expressionCache), (Expression)expression);
                this.expressionCache.put(identityNormalizedExpression, identityNormalizedExpression);
            }
            return identityNormalizedExpression;
        }
    }
}

