/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.base.Joiner;
import java.util.Collections;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestLocalExecutionPlanner {
    private final LocalQueryRunner runner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);

    @AfterClass(alwaysRun=true)
    public void cleanup() {
        this.runner.close();
    }

    @Test
    public void testCompilerFailure() {
        String inner = "(" + Joiner.on((String)" + ").join(Collections.nCopies(100, "rand()")) + ")";
        String outer = Joiner.on((String)" + ").join(Collections.nCopies(100, inner));
        this.assertFails("SELECT " + outer, (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR);
    }

    private void assertFails(@Language(value="SQL") String sql, ErrorCodeSupplier supplier) {
        try {
            this.runner.execute(sql);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)supplier.toErrorCode());
        }
    }
}

