/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.operator.scalar.TestingRowConstructor;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.type.ArrayType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestArrayOperators {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
        this.functionAssertions.getMetadata().getFunctionRegistry().addFunctions(new FunctionListBuilder(this.functionAssertions.getMetadata().getTypeManager()).scalar(TestingRowConstructor.class).getFunctions());
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    private void assertInvalidFunction(String projection, String message) {
        try {
            this.assertFunction(projection, null);
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)message);
        }
    }

    private void assertInvalidFunction(String projection) {
        this.functionAssertions.assertInvalidFunction(projection);
    }

    @Test
    public void testStackRepresentation() throws Exception {
        Slice slice = ArrayType.rawSlicesToStackRepresentation((List)ImmutableList.of((Object)ArrayType.toStackRepresentation((List)ImmutableList.of((Object)1L, (Object)2L)), (Object)ArrayType.toStackRepresentation((List)ImmutableList.of((Object)3L))));
        Assert.assertEquals((Object)slice, (Object)Slices.utf8Slice((String)"[[1,2],[3]]"));
    }

    @Test
    public void testArrayToJson() throws Exception {
        this.assertFunction("CAST(ARRAY [1, 2, 3] AS JSON)", "[1,2,3]");
        this.assertFunction("CAST(ARRAY [1, NULL, 3] AS JSON)", "[1,null,3]");
        this.assertFunction("CAST(ARRAY [1, 2.0, 3] AS JSON)", "[1.0,2.0,3.0]");
        this.assertFunction("CAST(ARRAY [1.0, 2.5, 3.0] AS JSON)", "[1.0,2.5,3.0]");
        this.assertFunction("CAST(ARRAY ['puppies', 'kittens'] AS JSON)", "[\"puppies\",\"kittens\"]");
        this.assertFunction("CAST(ARRAY [TRUE, FALSE] AS JSON)", "[true,false]");
        this.assertFunction("CAST(ARRAY [from_unixtime(1)] AS JSON)", "[\"" + new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()).toString() + "\"]");
    }

    @Test
    public void testJsonToArray() throws Exception {
        this.assertFunction("CAST(CAST('[1, 2, 3]' AS JSON) AS ARRAY<BIGINT>)", ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        this.assertFunction("CAST(CAST('[1, null, 3]' AS JSON) AS ARRAY<BIGINT>)", Arrays.asList(1L, null, 3L));
        this.assertFunction("CAST(CAST('[1, 2.0, 3]' AS JSON) AS ARRAY<DOUBLE>)", ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        this.assertFunction("CAST(CAST('[1.0, 2.5, 3.0]' AS JSON) AS ARRAY<DOUBLE>)", ImmutableList.of((Object)1.0, (Object)2.5, (Object)3.0));
        this.assertFunction("CAST(CAST('[\"puppies\", \"kittens\"]' AS JSON) AS ARRAY<VARCHAR>)", ImmutableList.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("CAST(CAST('[true, false]' AS JSON) AS ARRAY<BOOLEAN>)", ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("CAST(CAST('[[1], [null]]' AS JSON) AS ARRAY<ARRAY<BIGINT>>)", Arrays.asList(Arrays.asList(1L), Arrays.asList(new Long[]{null})));
        this.assertFunction("CAST(CAST('null' AS JSON) AS ARRAY<BIGINT>)", null);
        this.assertInvalidFunction("CAST(CAST('[1, null, 3]' AS JSON) AS ARRAY<TIMESTAMP>)");
        this.assertInvalidFunction("CAST(CAST('[1, null, 3]' AS JSON) AS ARRAY<ARRAY<TIMESTAMP>>)");
        this.assertInvalidFunction("CAST(CAST('[1, 2, 3]' AS JSON) AS ARRAY<BOOLEAN>)");
        this.assertInvalidFunction("CAST(CAST('[\"puppies\", \"kittens\"]' AS JSON) AS ARRAY<BIGINT>)");
    }

    @Test
    public void testConstructor() throws Exception {
        this.assertFunction("ARRAY []", ImmutableList.of());
        this.assertFunction("ARRAY [NULL]", Lists.newArrayList((Object[])new Object[]{null}));
        this.assertFunction("ARRAY [1, 2, 3]", ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        this.assertFunction("ARRAY [1, NULL, 3]", Lists.newArrayList((Object[])new Long[]{1L, null, 3L}));
        this.assertFunction("ARRAY [NULL, 2, 3]", Lists.newArrayList((Object[])new Long[]{null, 2L, 3L}));
        this.assertFunction("ARRAY [1, 2.0, 3]", ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]]", ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)3L)));
        this.assertFunction("ARRAY [ARRAY[1, 2], NULL, ARRAY[3]]", Lists.newArrayList((Object[])new ImmutableList[]{ImmutableList.of((Object)1L, (Object)2L), null, ImmutableList.of((Object)3L)}));
        this.assertFunction("ARRAY [1.0, 2.5, 3.0]", ImmutableList.of((Object)1.0, (Object)2.5, (Object)3.0));
        this.assertFunction("ARRAY ['puppies', 'kittens']", ImmutableList.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("ARRAY [TRUE, FALSE]", ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("ARRAY [from_unixtime(1), from_unixtime(100)]", ImmutableList.of((Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
        this.assertFunction("ARRAY [sqrt(-1)]", ImmutableList.of((Object)Double.NaN));
        this.assertFunction("ARRAY [pow(infinity(), 2)]", ImmutableList.of((Object)Double.POSITIVE_INFINITY));
        this.assertFunction("ARRAY [pow(-infinity(), 1)]", ImmutableList.of((Object)Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testArrayToArrayConcat() throws Exception {
        this.assertFunction("ARRAY [1, NULL] || ARRAY [3]", Lists.newArrayList((Object[])new Long[]{1L, null, 3L}));
        this.assertFunction("ARRAY [1, 2] || ARRAY[3, 4]", ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        this.assertFunction("ARRAY [NULL] || ARRAY[NULL]", Lists.newArrayList((Object[])new Object[]{null, null}));
        this.assertFunction("ARRAY ['puppies'] || ARRAY ['kittens']", ImmutableList.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("ARRAY [TRUE] || ARRAY [FALSE]", ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("concat(ARRAY [1] , ARRAY[2,3])", ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        this.assertFunction("ARRAY [from_unixtime(1)] || ARRAY[from_unixtime(100)]", ImmutableList.of((Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
        this.assertFunction("ARRAY [ARRAY[ARRAY[1]]] || ARRAY [ARRAY[ARRAY[2]]]", Arrays.asList(Collections.singletonList(Longs.asList((long[])new long[]{1L})), Collections.singletonList(Longs.asList((long[])new long[]{2L}))));
        this.assertFunction("ARRAY [] || ARRAY []", ImmutableList.of());
        this.assertFunction("ARRAY [TRUE] || ARRAY [FALSE] || ARRAY [TRUE]", ImmutableList.of((Object)true, (Object)false, (Object)true));
        this.assertFunction("ARRAY [1] || ARRAY [2] || ARRAY [3] || ARRAY [4]", ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        try {
            this.assertFunction("ARRAY [ARRAY[1]] || ARRAY[ARRAY[true], ARRAY[false]]", null);
            Assert.fail((String)"arrays must be of the same type");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.assertFunction("ARRAY [ARRAY[1]] || ARRAY[NULL]", null);
            Assert.fail((String)"arrays must be of the same type");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testElementArrayConcat() throws Exception {
        this.assertFunction("CAST (ARRAY [DATE '2001-08-22'] || DATE '2001-08-23' AS JSON)", "[\"2001-08-22\",\"2001-08-23\"]");
        this.assertFunction("CAST (DATE '2001-08-23' || ARRAY [DATE '2001-08-22'] AS JSON)", "[\"2001-08-23\",\"2001-08-22\"]");
        this.assertFunction("1 || ARRAY [2]", Lists.newArrayList((Object[])new Long[]{1L, 2L}));
        this.assertFunction("ARRAY [2] || 1", Lists.newArrayList((Object[])new Long[]{2L, 1L}));
        this.assertFunction("TRUE || ARRAY [FALSE]", Lists.newArrayList((Object[])new Boolean[]{true, false}));
        this.assertFunction("ARRAY [FALSE] || TRUE", Lists.newArrayList((Object[])new Boolean[]{false, true}));
        this.assertFunction("1.0 || ARRAY [2.0]", Lists.newArrayList((Object[])new Double[]{1.0, 2.0}));
        this.assertFunction("ARRAY [2.0] || 1.0", Lists.newArrayList((Object[])new Double[]{2.0, 1.0}));
        this.assertFunction("'puppies' || ARRAY ['kittens']", Lists.newArrayList((Object[])new String[]{"puppies", "kittens"}));
        this.assertFunction("ARRAY ['kittens'] || 'puppies'", Lists.newArrayList((Object[])new String[]{"kittens", "puppies"}));
        this.assertFunction("ARRAY [from_unixtime(1)] || from_unixtime(100)", ImmutableList.of((Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
        this.assertFunction("from_unixtime(100) || ARRAY [from_unixtime(1)]", ImmutableList.of((Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
    }

    @Test
    public void testArrayContains() throws Exception {
        this.assertFunction("CONTAINS(ARRAY [1, 2, 3], 2)", true);
        this.assertFunction("CONTAINS(ARRAY [1, 2, 3], 5)", false);
        this.assertFunction("CONTAINS(ARRAY [1, NULL, 3], 1)", true);
        this.assertFunction("CONTAINS(ARRAY [1, 2.0, 3], 3.0)", true);
        this.assertFunction("CONTAINS(ARRAY [1.0, 2.5, 3.0], 2.2)", false);
        this.assertFunction("CONTAINS(ARRAY ['puppies', 'kittens'], 'kittens')", true);
        this.assertFunction("CONTAINS(ARRAY ['puppies', 'kittens'], 'lizards')", false);
        this.assertFunction("CONTAINS(ARRAY [TRUE, FALSE], TRUE)", true);
        this.assertFunction("CONTAINS(ARRAY [FALSE], TRUE)", false);
    }

    @Test
    public void testCardinality() throws Exception {
        this.assertFunction("CARDINALITY(ARRAY [])", 0);
        this.assertFunction("CARDINALITY(ARRAY [NULL])", 1);
        this.assertFunction("CARDINALITY(ARRAY [1, 2, 3])", 3);
        this.assertFunction("CARDINALITY(ARRAY [1, NULL, 3])", 3);
        this.assertFunction("CARDINALITY(ARRAY [1, 2.0, 3])", 3);
        this.assertFunction("CARDINALITY(ARRAY [ARRAY[1, 2], ARRAY[3]])", 2);
        this.assertFunction("CARDINALITY(ARRAY [1.0, 2.5, 3.0])", 3);
        this.assertFunction("CARDINALITY(ARRAY ['puppies', 'kittens'])", 2);
        this.assertFunction("CARDINALITY(ARRAY [TRUE, FALSE])", 2);
    }

    @Test
    public void testSubscript() throws Exception {
        String outOfBounds = "Index out of bounds";
        this.assertInvalidFunction("ARRAY [][1]", outOfBounds);
        this.assertInvalidFunction("ARRAY [null][-1]", outOfBounds);
        this.assertInvalidFunction("ARRAY [1, 2, 3][0]", outOfBounds);
        this.assertInvalidFunction("ARRAY [1, 2, 3][-1]", outOfBounds);
        this.assertInvalidFunction("ARRAY [1, 2, 3][4]", outOfBounds);
        try {
            this.assertFunction("ARRAY [1, 2, 3][1.1]", null);
            Assert.fail((String)"Access to array with double subscript should fail");
        }
        catch (SemanticException e) {
            Assert.assertTrue((e.getCode() == SemanticErrorCode.TYPE_MISMATCH ? 1 : 0) != 0);
        }
        this.assertFunction("ARRAY[NULL][1]", null);
        this.assertFunction("ARRAY[NULL, NULL, NULL][3]", null);
        this.assertFunction("1 + ARRAY [2, 1, 3][2]", 2);
        this.assertFunction("ARRAY [2, 1, 3][2]", 1);
        this.assertFunction("ARRAY [2, NULL, 3][2]", null);
        this.assertFunction("ARRAY [1.0, 2.5, 3.5][3]", 3.5);
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]][2]", ImmutableList.of((Object)3L));
        this.assertFunction("ARRAY [ARRAY[1, 2], NULL, ARRAY[3]][2]", null);
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]][2][1]", 3);
        this.assertFunction("ARRAY ['puppies', 'kittens'][2]", "kittens");
        this.assertFunction("ARRAY ['puppies', 'kittens', NULL][3]", null);
        this.assertFunction("ARRAY [TRUE, FALSE][2]", false);
        this.assertFunction("ARRAY [from_unixtime(1), from_unixtime(100)][1]", new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()));
        this.assertFunction("ARRAY [infinity()][1]", Double.POSITIVE_INFINITY);
        this.assertFunction("ARRAY [-infinity()][1]", Double.NEGATIVE_INFINITY);
        this.assertFunction("ARRAY [sqrt(-1)][1]", Double.NaN);
    }

    @Test
    public void testSort() throws Exception {
        this.assertFunction("ARRAY_SORT(ARRAY[2, 3, 4, 1])", ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        this.assertFunction("ARRAY_SORT(ARRAY['z', 'f', 's', 'd', 'g'])", ImmutableList.of((Object)"d", (Object)"f", (Object)"g", (Object)"s", (Object)"z"));
        this.assertFunction("ARRAY_SORT(ARRAY[TRUE, FALSE])", ImmutableList.of((Object)false, (Object)true));
        this.assertFunction("ARRAY_SORT(ARRAY[22.1, 11.1, 1.1, 44.1])", ImmutableList.of((Object)1.1, (Object)11.1, (Object)22.1, (Object)44.1));
        this.assertFunction("ARRAY_SORT(ARRAY [from_unixtime(100), from_unixtime(1), from_unixtime(200)])", ImmutableList.of((Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(200000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
        this.assertFunction("ARRAY_SORT(ARRAY [ARRAY [1], ARRAY [2]])", ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)2L)));
        try {
            this.assertFunction("ARRAY_SORT(ARRAY[NULL, NULL, NULL])", null);
            Assert.fail((String)"ARRAY_SORT is not supported for arrays with incomparable elements");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testComparison() throws Exception {
        this.assertFunction("ARRAY [1, 2, 3] = ARRAY [1, 2, 3]", true);
        this.assertFunction("ARRAY [TRUE, FALSE] = ARRAY [TRUE, FALSE]", true);
        this.assertFunction("ARRAY [1.1, 2.2, 3.3, 4.4] = ARRAY [1.1, 2.2, 3.3, 4.4]", true);
        this.assertFunction("ARRAY ['puppies', 'kittens'] = ARRAY ['puppies', 'kittens']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] = ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [timestamp '2012-10-31 08:00 UTC'] = ARRAY [timestamp '2012-10-31 01:00 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [1, 2, 3] = ARRAY [3, 2, 1]", false);
        this.assertFunction("ARRAY [TRUE, FALSE] = ARRAY [FALSE, FALSE]", false);
        this.assertFunction("ARRAY [1.1, 2.2, 3.3] = ARRAY [11.1, 22.1, 1.1, 44.1]", false);
        this.assertFunction("ARRAY ['puppies', 'kittens'] = ARRAY ['z', 'f', 's', 'd', 'g']", false);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] = ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", false);
        this.assertFunction("ARRAY [10, 20, 30] < ARRAY [10, 20, 40, 50]", true);
        this.assertFunction("ARRAY [10, 20, 30] < ARRAY [10, 40]", true);
        this.assertFunction("ARRAY [10, 20] < ARRAY [10, 20, 30]", true);
        this.assertFunction("ARRAY [TRUE, FALSE] < ARRAY [TRUE, TRUE, TRUE]", true);
        this.assertFunction("ARRAY [TRUE, FALSE, FALSE] < ARRAY [TRUE, TRUE]", true);
        this.assertFunction("ARRAY [TRUE, FALSE] < ARRAY [TRUE, FALSE, FALSE]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] < ARRAY[1.1, 2.2, 4.4, 4.4]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] < ARRAY[1.1, 2.2, 5.5]", true);
        this.assertFunction("ARRAY[1.1, 2.2] < ARRAY[1.1, 2.2, 5.5]", true);
        this.assertFunction("ARRAY['puppies', 'kittens', 'lizards'] < ARRAY ['puppies', 'lizards', 'lizards']", true);
        this.assertFunction("ARRAY['puppies', 'kittens', 'lizards'] < ARRAY ['puppies', 'lizards']", true);
        this.assertFunction("ARRAY['puppies', 'kittens'] < ARRAY ['puppies', 'kittens', 'lizards']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] < ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] < ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] < ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [10, 20, 30] > ARRAY [10, 20, 20]", true);
        this.assertFunction("ARRAY [10, 20, 30] > ARRAY [10, 20]", true);
        this.assertFunction("ARRAY [TRUE, TRUE, TRUE] > ARRAY [TRUE, TRUE, FALSE]", true);
        this.assertFunction("ARRAY [TRUE, TRUE, FALSE] > ARRAY [TRUE, TRUE]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] > ARRAY[1.1, 2.2, 2.2, 4.4]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] > ARRAY[1.1, 2.2, 3.3]", true);
        this.assertFunction("ARRAY['puppies', 'kittens', 'lizards'] > ARRAY ['puppies', 'kittens', 'kittens']", true);
        this.assertFunction("ARRAY['puppies', 'kittens', 'lizards'] > ARRAY ['puppies', 'kittens']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] > ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] > ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:20.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [10, 20, 30] <= ARRAY [50]", true);
        this.assertFunction("ARRAY [10, 20, 30] <= ARRAY [10, 20, 30]", true);
        this.assertFunction("ARRAY [TRUE, FALSE] <= ARRAY [TRUE, FALSE, true]", true);
        this.assertFunction("ARRAY [TRUE, FALSE] <= ARRAY [TRUE, FALSE]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] <= ARRAY[2.2, 5.5]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] <= ARRAY[1.1, 2.2, 3.3, 4.4]", true);
        this.assertFunction("ARRAY['puppies', 'kittens', 'lizards'] <= ARRAY ['puppies', 'lizards']", true);
        this.assertFunction("ARRAY['puppies', 'kittens'] <= ARRAY['puppies', 'kittens']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] <= ARRAY [TIME '04:05:06.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] <= ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [10, 20, 30] >= ARRAY [10, 20, 30]", true);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] >= ARRAY [TRUE, FALSE, TRUE]", true);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] >= ARRAY [TRUE]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] >= ARRAY[1.1, 2.2]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] >= ARRAY[1.1, 2.2, 3.3, 4.4]", true);
        this.assertFunction("ARRAY['puppies', 'kittens', 'lizards'] >= ARRAY ['puppies', 'kittens', 'kittens']", true);
        this.assertFunction("ARRAY['puppies', 'kittens'] >= ARRAY['puppies', 'kittens']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] >= ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        this.assertFunction("ARRAY [10, 20, 30] != ARRAY [5]", true);
        this.assertFunction("ARRAY [TRUE, FALSE, TRUE] != ARRAY [TRUE]", true);
        this.assertFunction("ARRAY[1.1, 2.2, 3.3, 4.4] != ARRAY[1.1, 2.2]", true);
        this.assertFunction("ARRAY['puppies', 'kittens', 'lizards'] != ARRAY ['puppies', 'kittens']", true);
        this.assertFunction("ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles'] != ARRAY [TIME '01:02:03.456 America/Los_Angeles', TIME '10:20:30.456 America/Los_Angeles']", true);
        try {
            this.assertFunction("ARRAY[1, NULL] = ARRAY[1, 2]", false);
            Assert.fail((String)"ARRAY comparison not implemented for NULL values");
        }
        catch (PrestoException e) {
            Assert.assertEquals((int)e.getErrorCode().getCode(), (int)StandardErrorCode.NOT_SUPPORTED.toErrorCode().getCode());
        }
    }
}

