/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBooleanOperators {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() throws Exception {
        this.assertFunction("true", true);
        this.assertFunction("false", false);
    }

    @Test
    public void testEqual() throws Exception {
        this.assertFunction("true = true", true);
        this.assertFunction("true = false", false);
        this.assertFunction("false = true", false);
        this.assertFunction("false = false", true);
    }

    @Test
    public void testNotEqual() throws Exception {
        this.assertFunction("true <> true", false);
        this.assertFunction("true <> false", true);
        this.assertFunction("false <> true", true);
        this.assertFunction("false <> false", false);
    }

    @Test
    public void testLessThan() throws Exception {
        this.assertFunction("true < true", false);
        this.assertFunction("true < false", false);
        this.assertFunction("false < true", true);
        this.assertFunction("false < false", false);
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        this.assertFunction("true <= true", true);
        this.assertFunction("true <= false", false);
        this.assertFunction("false <= true", true);
        this.assertFunction("false <= false", true);
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.assertFunction("true > true", false);
        this.assertFunction("true > false", true);
        this.assertFunction("false > true", false);
        this.assertFunction("false > false", false);
    }

    @Test
    public void testGreaterThanOrEqual() throws Exception {
        this.assertFunction("true >= true", true);
        this.assertFunction("true >= false", true);
        this.assertFunction("false >= true", false);
        this.assertFunction("false >= false", true);
    }

    @Test
    public void testBetween() throws Exception {
        this.assertFunction("true BETWEEN true AND true", true);
        this.assertFunction("true BETWEEN true AND false", false);
        this.assertFunction("true BETWEEN false AND true", true);
        this.assertFunction("true BETWEEN false AND false", false);
        this.assertFunction("false BETWEEN true AND true", false);
        this.assertFunction("false BETWEEN true AND false", false);
        this.assertFunction("false BETWEEN false AND true", true);
        this.assertFunction("false BETWEEN false AND false", true);
    }

    @Test
    public void testCastToVarchar() throws Exception {
        this.assertFunction("cast(true as varchar)", "true");
        this.assertFunction("cast(false as varchar)", "false");
    }

    @Test
    public void testCastFromVarchar() throws Exception {
        this.assertFunction("cast('true' as boolean)", true);
        this.assertFunction("cast('false' as boolean)", false);
    }
}

