/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDateTimeOperators {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin");
    private static final DateTimeZone TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    private static final DateTimeZone WEIRD_TIME_ZONE = DateTimeZone.forOffsetHoursMinutes((int)5, (int)9);
    private static final TimeZoneKey WEIRD_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)309L);
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        Session session = Session.builder().setUser("user").setSource("test").setCatalog("catalog").setSchema("schema").setTimeZoneKey(TIME_ZONE_KEY).setLocale(Locale.ENGLISH).build();
        this.functionAssertions = new FunctionAssertions(session);
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testDatePlusInterval() {
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' day", TestDateTimeOperators.toDate(new DateTime(2001, 1, 25, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' day + DATE '2001-1-22'", TestDateTimeOperators.toDate(new DateTime(2001, 1, 25, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' month", TestDateTimeOperators.toDate(new DateTime(2001, 4, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' month + DATE '2001-1-22'", TestDateTimeOperators.toDate(new DateTime(2001, 4, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' year", TestDateTimeOperators.toDate(new DateTime(2004, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' year + DATE '2001-1-22'", TestDateTimeOperators.toDate(new DateTime(2004, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        try {
            this.functionAssertions.tryEvaluate("DATE '2001-1-22' + INTERVAL '3' hour");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.functionAssertions.tryEvaluate("INTERVAL '3' hour + DATE '2001-1-22'");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTimePlusInterval() {
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '3' hour", new SqlTime(new DateTime(1970, 1, 1, 6, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' hour + TIME '03:04:05.321'", new SqlTime(new DateTime(1970, 1, 1, 6, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '3' day", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' day + TIME '03:04:05.321'", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '3' month", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' month + TIME '03:04:05.321'", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '3' year", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' year + TIME '03:04:05.321'", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '27' hour", new SqlTime(new DateTime(1970, 1, 1, 6, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '27' hour + TIME '03:04:05.321'", new SqlTime(new DateTime(1970, 1, 1, 6, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '3' hour", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' hour + TIME '03:04:05.321 +05:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '3' day", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' day + TIME '03:04:05.321 +05:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '3' month", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' month + TIME '03:04:05.321 +05:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '3' year", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' year + TIME '03:04:05.321 +05:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '27' hour", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '27' hour + TIME '03:04:05.321 +05:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testTimestampPlusInterval() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' hour", new SqlTimestamp(new DateTime(2001, 1, 22, 6, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' hour + TIMESTAMP '2001-1-22 03:04:05.321'", new SqlTimestamp(new DateTime(2001, 1, 22, 6, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' day", new SqlTimestamp(new DateTime(2001, 1, 25, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' day + TIMESTAMP '2001-1-22 03:04:05.321'", new SqlTimestamp(new DateTime(2001, 1, 25, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' month", new SqlTimestamp(new DateTime(2001, 4, 22, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' month + TIMESTAMP '2001-1-22 03:04:05.321'", new SqlTimestamp(new DateTime(2001, 4, 22, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' year", new SqlTimestamp(new DateTime(2004, 1, 22, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' year + TIMESTAMP '2001-1-22 03:04:05.321'", new SqlTimestamp(new DateTime(2004, 1, 22, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' hour", new SqlTimestampWithTimeZone(new DateTime(2001, 1, 22, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' hour + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", new SqlTimestampWithTimeZone(new DateTime(2001, 1, 22, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' day", new SqlTimestampWithTimeZone(new DateTime(2001, 1, 25, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' day + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", new SqlTimestampWithTimeZone(new DateTime(2001, 1, 25, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' month", new SqlTimestampWithTimeZone(new DateTime(2001, 4, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' month + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", new SqlTimestampWithTimeZone(new DateTime(2001, 4, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' year", new SqlTimestampWithTimeZone(new DateTime(2004, 1, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' year + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", new SqlTimestampWithTimeZone(new DateTime(2004, 1, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testDateMinusInterval() {
        this.assertFunction("DATE '2001-1-22' - INTERVAL '3' day", TestDateTimeOperators.toDate(new DateTime(2001, 1, 19, 0, 0, 0, 0, DateTimeZone.UTC)));
        try {
            this.functionAssertions.tryEvaluate("DATE '2001-1-22' - INTERVAL '3' hour");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeMinusInterval() {
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '3' hour", new SqlTime(new DateTime(1970, 1, 1, 0, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '3' day", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '3' month", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '3' year", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '6' hour", new SqlTime(new DateTime(1970, 1, 1, 21, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '3' hour", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 0, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '3' day", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '3' month", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '3' year", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '6' hour", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 21, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testTimestampMinusInterval() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' - INTERVAL '3' day", new SqlTimestamp(new DateTime(2001, 1, 19, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' - INTERVAL '3' day", new SqlTimestampWithTimeZone(new DateTime(2001, 1, 19, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' - INTERVAL '3' month", new SqlTimestamp(new DateTime(2000, 10, 22, 3, 4, 5, 321, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' - INTERVAL '3' month", new SqlTimestampWithTimeZone(new DateTime(2000, 10, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testTimeZoneGap() {
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '1' hour", new SqlTimestamp(new DateTime(2013, 3, 31, 1, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '2' hour", new SqlTimestamp(new DateTime(2013, 3, 31, 3, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-03-31 00:05' + INTERVAL '3' hour", new SqlTimestamp(new DateTime(2013, 3, 31, 4, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-03-31 04:05' - INTERVAL '3' hour", new SqlTimestamp(new DateTime(2013, 3, 31, 0, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-03-31 03:05' - INTERVAL '2' hour", new SqlTimestamp(new DateTime(2013, 3, 31, 0, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-03-31 01:05' - INTERVAL '1' hour", new SqlTimestamp(new DateTime(2013, 3, 31, 0, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testDateToTimestampCoercing() {
        this.assertFunction("date_format(DATE '2013-10-27', '%Y-%m-%d %H:%i:%s')", "2013-10-27 00:00:00");
        this.assertFunction("DATE '2013-10-27' = TIMESTAMP '2013-10-27 00:00:00'", true);
        this.assertFunction("DATE '2013-10-27' < TIMESTAMP '2013-10-27 00:00:01'", true);
        this.assertFunction("DATE '2013-10-27' > TIMESTAMP '2013-10-26 23:59:59'", true);
    }

    @Test
    public void testDateToTimestampWithZoneCoercing() {
        this.assertFunction("DATE '2013-10-27' = TIMESTAMP '2013-10-27 00:00:00 Europe/Berlin'", true);
        this.assertFunction("DATE '2013-10-27' < TIMESTAMP '2013-10-27 00:00:01 Europe/Berlin'", true);
        this.assertFunction("DATE '2013-10-27' > TIMESTAMP '2013-10-26 23:59:59 Europe/Berlin'", true);
    }

    @Test
    public void testTimeZoneDuplicate() {
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '1' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 1, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '2' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 2, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '3' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 0, 5, 0, 0, TIME_ZONE).getMillis() + TimeUnit.HOURS.toMillis(3L), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-10-27 00:05' + INTERVAL '4' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 3, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '4' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 0, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-10-27 02:05' - INTERVAL '2' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 0, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-10-27 01:05' - INTERVAL '1' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 0, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '1' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 0, 5, 0, 0, TIME_ZONE).getMillis() + TimeUnit.HOURS.toMillis(3L), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-10-27 03:05' - INTERVAL '2' hour", new SqlTimestamp(new DateTime(2013, 10, 27, 2, 5, 0, 0, TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    private static SqlDate toDate(DateTime dateTime) {
        return new SqlDate((int)TimeUnit.MILLISECONDS.toDays(dateTime.getMillis()));
    }
}

