/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDoubleOperators {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() throws Exception {
        this.assertFunction("37.7", 37.7);
        this.assertFunction("17.1", 17.1);
    }

    @Test
    public void testAdd() throws Exception {
        this.assertFunction("37.7 + 37.7", 75.4);
        this.assertFunction("37.7 + 17.1", 54.800000000000004);
        this.assertFunction("17.1 + 37.7", 54.800000000000004);
        this.assertFunction("17.1 + 17.1", 34.2);
    }

    @Test
    public void testSubtract() throws Exception {
        this.assertFunction("37.7 - 37.7", 0.0);
        this.assertFunction("37.7 - 17.1", 20.6);
        this.assertFunction("17.1 - 37.7", -20.6);
        this.assertFunction("17.1 - 17.1", 0.0);
    }

    @Test
    public void testMultiply() throws Exception {
        this.assertFunction("37.7 * 37.7", 1421.2900000000002);
        this.assertFunction("37.7 * 17.1", 644.6700000000001);
        this.assertFunction("17.1 * 37.7", 644.6700000000001);
        this.assertFunction("17.1 * 17.1", 292.41);
    }

    @Test
    public void testDivide() throws Exception {
        this.assertFunction("37.7 / 37.7", 1.0);
        this.assertFunction("37.7 / 17.1", 2.2046783625730995);
        this.assertFunction("17.1 / 37.7", 0.4535809018567639);
        this.assertFunction("17.1 / 17.1", 1.0);
    }

    @Test
    public void testModulus() throws Exception {
        this.assertFunction("37.7 % 37.7", 0.0);
        this.assertFunction("37.7 % 17.1", 3.5);
        this.assertFunction("17.1 % 37.7", 17.1);
        this.assertFunction("17.1 % 17.1", 0.0);
    }

    @Test
    public void testNegation() throws Exception {
        this.assertFunction("-(37.7)", -37.7);
        this.assertFunction("-(17.1)", -17.1);
    }

    @Test
    public void testEqual() throws Exception {
        this.assertFunction("37.7 = 37.7", true);
        this.assertFunction("37.7 = 17.1", false);
        this.assertFunction("17.1 = 37.7", false);
        this.assertFunction("17.1 = 17.1", true);
    }

    @Test
    public void testNotEqual() throws Exception {
        this.assertFunction("37.7 <> 37.7", false);
        this.assertFunction("37.7 <> 17.1", true);
        this.assertFunction("17.1 <> 37.7", true);
        this.assertFunction("17.1 <> 17.1", false);
    }

    @Test
    public void testLessThan() throws Exception {
        this.assertFunction("37.7 < 37.7", false);
        this.assertFunction("37.7 < 17.1", false);
        this.assertFunction("17.1 < 37.7", true);
        this.assertFunction("17.1 < 17.1", false);
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        this.assertFunction("37.7 <= 37.7", true);
        this.assertFunction("37.7 <= 17.1", false);
        this.assertFunction("17.1 <= 37.7", true);
        this.assertFunction("17.1 <= 17.1", true);
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.assertFunction("37.7 > 37.7", false);
        this.assertFunction("37.7 > 17.1", true);
        this.assertFunction("17.1 > 37.7", false);
        this.assertFunction("17.1 > 17.1", false);
    }

    @Test
    public void testGreaterThanOrEqual() throws Exception {
        this.assertFunction("37.7 >= 37.7", true);
        this.assertFunction("37.7 >= 17.1", true);
        this.assertFunction("17.1 >= 37.7", false);
        this.assertFunction("17.1 >= 17.1", true);
    }

    @Test
    public void testBetween() throws Exception {
        this.assertFunction("37.7 BETWEEN 37.7 AND 37.7", true);
        this.assertFunction("37.7 BETWEEN 37.7 AND 17.1", false);
        this.assertFunction("37.7 BETWEEN 17.1 AND 37.7", true);
        this.assertFunction("37.7 BETWEEN 17.1 AND 17.1", false);
        this.assertFunction("17.1 BETWEEN 37.7 AND 37.7", false);
        this.assertFunction("17.1 BETWEEN 37.7 AND 17.1", false);
        this.assertFunction("17.1 BETWEEN 17.1 AND 37.7", true);
        this.assertFunction("17.1 BETWEEN 17.1 AND 17.1", true);
    }

    @Test
    public void testCastToVarchar() throws Exception {
        this.assertFunction("cast(37.7 as varchar)", "37.7");
        this.assertFunction("cast(17.1 as varchar)", "17.1");
    }

    @Test
    public void testCastToBigint() throws Exception {
        this.assertFunction("cast(37.7 as bigint)", 38L);
        this.assertFunction("cast(17.1 as bigint)", 17L);
    }

    @Test
    public void testCastToBoolean() throws Exception {
        this.assertFunction("cast(37.7 as boolean)", true);
        this.assertFunction("cast(17.1 as boolean)", true);
        this.assertFunction("cast(0.0 as boolean)", false);
    }

    @Test
    public void testCastFromVarchar() throws Exception {
        this.assertFunction("cast('37.7' as double)", 37.7);
        this.assertFunction("cast('17.1' as double)", 17.1);
    }
}

