/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.type.SqlIntervalYearMonth;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIntervalYearMonth {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() throws Exception {
        this.assertFunction("INTERVAL '124-30' YEAR TO MONTH", new SqlIntervalYearMonth(124, 30));
        this.assertFunction("INTERVAL '124' YEAR TO MONTH", new SqlIntervalYearMonth(124, 0));
        this.assertFunction("INTERVAL '124' YEAR", new SqlIntervalYearMonth(124, 0));
        this.assertFunction("INTERVAL '30' MONTH", new SqlIntervalYearMonth(0, 30));
    }

    @Test
    public void testAdd() throws Exception {
        this.assertFunction("INTERVAL '3' MONTH + INTERVAL '3' MONTH", new SqlIntervalYearMonth(6L));
        this.assertFunction("INTERVAL '6' YEAR + INTERVAL '6' YEAR", new SqlIntervalYearMonth(144L));
        this.assertFunction("INTERVAL '3' MONTH + INTERVAL '6' YEAR", new SqlIntervalYearMonth(75L));
    }

    @Test
    public void testSubtract() throws Exception {
        this.assertFunction("INTERVAL '6' MONTH - INTERVAL '3' MONTH", new SqlIntervalYearMonth(3L));
        this.assertFunction("INTERVAL '9' YEAR - INTERVAL '6' YEAR", new SqlIntervalYearMonth(36L));
        this.assertFunction("INTERVAL '3' MONTH - INTERVAL '6' YEAR", new SqlIntervalYearMonth(-69L));
    }

    @Test
    public void testMultiply() throws Exception {
        this.assertFunction("INTERVAL '6' MONTH * 2", new SqlIntervalYearMonth(12L));
        this.assertFunction("2 * INTERVAL '6' MONTH", new SqlIntervalYearMonth(12L));
        this.assertFunction("INTERVAL '10' MONTH * 2.5", new SqlIntervalYearMonth(25L));
        this.assertFunction("2.5 * INTERVAL '10' MONTH", new SqlIntervalYearMonth(25L));
        this.assertFunction("INTERVAL '6' YEAR * 2", new SqlIntervalYearMonth(144L));
        this.assertFunction("2 * INTERVAL '6' YEAR", new SqlIntervalYearMonth(144L));
        this.assertFunction("INTERVAL '1' YEAR * 2.5", new SqlIntervalYearMonth(30L));
        this.assertFunction("2.5 * INTERVAL '1' YEAR", new SqlIntervalYearMonth(30L));
    }

    @Test
    public void testDivide() throws Exception {
        this.assertFunction("INTERVAL '30' MONTH / 2", new SqlIntervalYearMonth(15L));
        this.assertFunction("INTERVAL '60' MONTH / 2.5", new SqlIntervalYearMonth(24L));
        this.assertFunction("INTERVAL '3' YEAR / 2", new SqlIntervalYearMonth(18L));
        this.assertFunction("INTERVAL '4' YEAR / 4.8", new SqlIntervalYearMonth(10L));
    }

    @Test
    public void testNegation() throws Exception {
        this.assertFunction("- INTERVAL '3' MONTH", new SqlIntervalYearMonth(-3L));
        this.assertFunction("- INTERVAL '6' YEAR", new SqlIntervalYearMonth(-72L));
    }

    @Test
    public void testEqual() throws Exception {
        this.assertFunction("INTERVAL '3' MONTH = INTERVAL '3' MONTH", true);
        this.assertFunction("INTERVAL '6' YEAR = INTERVAL '6' YEAR", true);
        this.assertFunction("INTERVAL '3' MONTH = INTERVAL '4' MONTH", false);
        this.assertFunction("INTERVAL '7' YEAR = INTERVAL '6' YEAR", false);
    }

    @Test
    public void testNotEqual() throws Exception {
        this.assertFunction("INTERVAL '3' MONTH <> INTERVAL '4' MONTH", true);
        this.assertFunction("INTERVAL '6' YEAR <> INTERVAL '7' YEAR", true);
        this.assertFunction("INTERVAL '3' MONTH <> INTERVAL '3' MONTH", false);
        this.assertFunction("INTERVAL '6' YEAR <> INTERVAL '6' YEAR", false);
    }

    @Test
    public void testLessThan() throws Exception {
        this.assertFunction("INTERVAL '3' MONTH < INTERVAL '4' MONTH", true);
        this.assertFunction("INTERVAL '6' YEAR < INTERVAL '7' YEAR", true);
        this.assertFunction("INTERVAL '3' MONTH < INTERVAL '3' MONTH", false);
        this.assertFunction("INTERVAL '3' MONTH < INTERVAL '2' MONTH", false);
        this.assertFunction("INTERVAL '6' YEAR < INTERVAL '6' YEAR", false);
        this.assertFunction("INTERVAL '6' YEAR < INTERVAL '5' YEAR", false);
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        this.assertFunction("INTERVAL '3' MONTH <= INTERVAL '4' MONTH", true);
        this.assertFunction("INTERVAL '3' MONTH <= INTERVAL '3' MONTH", true);
        this.assertFunction("INTERVAL '6' YEAR <= INTERVAL '6' YEAR", true);
        this.assertFunction("INTERVAL '6' YEAR <= INTERVAL '7' YEAR", true);
        this.assertFunction("INTERVAL '3' MONTH <= INTERVAL '2' MONTH", false);
        this.assertFunction("INTERVAL '6' YEAR <= INTERVAL '5' YEAR", false);
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.assertFunction("INTERVAL '3' MONTH > INTERVAL '2' MONTH", true);
        this.assertFunction("INTERVAL '6' YEAR > INTERVAL '5' YEAR", true);
        this.assertFunction("INTERVAL '3' MONTH > INTERVAL '3' MONTH", false);
        this.assertFunction("INTERVAL '3' MONTH > INTERVAL '4' MONTH", false);
        this.assertFunction("INTERVAL '6' YEAR > INTERVAL '6' YEAR", false);
        this.assertFunction("INTERVAL '6' YEAR > INTERVAL '7' YEAR", false);
    }

    @Test
    public void testGreaterThanOrEqual() throws Exception {
        this.assertFunction("INTERVAL '3' MONTH >= INTERVAL '2' MONTH", true);
        this.assertFunction("INTERVAL '3' MONTH >= INTERVAL '3' MONTH", true);
        this.assertFunction("INTERVAL '6' YEAR >= INTERVAL '5' YEAR", true);
        this.assertFunction("INTERVAL '6' YEAR >= INTERVAL '6' YEAR", true);
        this.assertFunction("INTERVAL '3' MONTH >= INTERVAL '4' MONTH", false);
        this.assertFunction("INTERVAL '6' YEAR >= INTERVAL '7' YEAR", false);
    }

    @Test
    public void testBetween() throws Exception {
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '2' MONTH and INTERVAL '4' MONTH", true);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '3' MONTH and INTERVAL '4' MONTH", true);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '2' MONTH and INTERVAL '3' MONTH", true);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '3' MONTH and INTERVAL '3' MONTH", true);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '4' MONTH and INTERVAL '5' MONTH", false);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '1' MONTH and INTERVAL '2' MONTH", false);
        this.assertFunction("INTERVAL '3' MONTH between INTERVAL '4' MONTH and INTERVAL '2' MONTH", false);
    }

    @Test
    public void testCastToSlice() throws Exception {
        this.assertFunction("cast(INTERVAL '124-30' YEAR TO MONTH as varchar)", "126-6");
        this.assertFunction("cast(INTERVAL '124-30' YEAR TO MONTH as varchar)", new SqlIntervalYearMonth(124, 30).toString());
        this.assertFunction("cast(INTERVAL '124' YEAR TO MONTH as varchar)", new SqlIntervalYearMonth(124, 0).toString());
        this.assertFunction("cast(INTERVAL '124' YEAR as varchar)", new SqlIntervalYearMonth(124, 0).toString());
        this.assertFunction("cast(INTERVAL '30' MONTH as varchar)", new SqlIntervalYearMonth(0, 30).toString());
    }
}

