/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestMapOperators {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    private void assertInvalidFunction(String projection, String message) {
        try {
            this.assertFunction(projection, null);
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)message);
        }
    }

    private void assertInvalidFunction(String projection) {
        this.functionAssertions.assertInvalidFunction(projection);
    }

    @Test
    public void testStackRepresentation() throws Exception {
        Slice array = ArrayType.toStackRepresentation((List)ImmutableList.of((Object)1L, (Object)2L));
        Slice slice = MapType.rawValueSlicesToStackRepresentation((Map)ImmutableMap.of((Object)1.0, (Object)array));
        Assert.assertEquals((Object)slice, (Object)Slices.utf8Slice((String)"{\"1.0\":[1,2]}"));
    }

    @Test
    public void testConstructor() throws Exception {
        this.assertFunction("MAP(ARRAY ['1','3'], ARRAY [2,4])", ImmutableMap.of((Object)"1", (Object)2L, (Object)"3", (Object)4L));
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        map.put(1L, 2L);
        map.put(3L, null);
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY[2, NULL])", map);
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY [2.0, 4.0])", ImmutableMap.of((Object)1L, (Object)2.0, (Object)3L, (Object)4.0));
        this.assertFunction("MAP(ARRAY[1.0, 2.0], ARRAY[ ARRAY[1, 2], ARRAY[3]])", ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)2.0, (Object)ImmutableList.of((Object)3L)));
        this.assertFunction("MAP(ARRAY['puppies'], ARRAY['kittens'])", ImmutableMap.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("MAP(ARRAY[TRUE, FALSE], ARRAY[2,4])", ImmutableMap.of((Object)true, (Object)2L, (Object)false, (Object)4L));
        this.assertFunction("MAP(ARRAY['1', '100'], ARRAY[from_unixtime(1), from_unixtime(100)])", ImmutableMap.of((Object)"1", (Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)"100", (Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[1.0, 100.0])", ImmutableMap.of((Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)1.0, (Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)100.0));
        this.assertInvalidFunction("MAP(ARRAY [1], ARRAY [2, 4])", "Key and value arrays must be the same length");
    }

    @Test
    public void testCardinality() throws Exception {
        this.assertFunction("CARDINALITY(MAP(ARRAY ['1','3'], ARRAY [2,4]))", 2);
        this.assertFunction("CARDINALITY(MAP(ARRAY [1, 3], ARRAY[2, NULL]))", 2);
        this.assertFunction("CARDINALITY(MAP(ARRAY [1, 3], ARRAY [2.0, 4.0]))", 2);
        this.assertFunction("CARDINALITY(MAP(ARRAY[1.0, 2.0], ARRAY[ ARRAY[1, 2], ARRAY[3]]))", 2);
        this.assertFunction("CARDINALITY(MAP(ARRAY['puppies'], ARRAY['kittens']))", 1);
        this.assertFunction("CARDINALITY(MAP(ARRAY[TRUE], ARRAY[2]))", 1);
        this.assertFunction("CARDINALITY(MAP(ARRAY['1'], ARRAY[from_unixtime(1)]))", 1);
        this.assertFunction("CARDINALITY(MAP(ARRAY[from_unixtime(1)], ARRAY[1.0]))", 1);
    }

    @Test
    public void testMapToJson() throws Exception {
        this.assertFunction("CAST(MAP(ARRAY[7,5,3,1], ARRAY[8,6,4,2]) AS JSON)", "{\"1\":2,\"3\":4,\"5\":6,\"7\":8}");
        this.assertFunction("CAST(MAP(ARRAY[1,3,5,7], ARRAY[2,4,6,8]) AS JSON)", "{\"1\":2,\"3\":4,\"5\":6,\"7\":8}");
        this.assertFunction("CAST(MAP(ARRAY [1, 3], ARRAY[2, NULL]) AS JSON)", "{\"1\":2,\"3\":null}");
        this.assertFunction("CAST(MAP(ARRAY [1, 3], ARRAY [2.0, 4.0]) AS JSON)", "{\"1\":2.0,\"3\":4.0}");
        this.assertFunction("CAST(MAP(ARRAY[1.0, 2.0], ARRAY[ ARRAY[1, 2], ARRAY[3]]) AS JSON)", "{\"1.0\":[1,2],\"2.0\":[3]}");
        this.assertFunction("CAST(MAP(ARRAY['puppies'], ARRAY['kittens']) AS JSON)", "{\"puppies\":\"kittens\"}");
        this.assertFunction("CAST(MAP(ARRAY[TRUE], ARRAY[2]) AS JSON)", "{\"true\":2}");
        this.assertFunction("CAST(MAP(ARRAY['1'], ARRAY[from_unixtime(1)]) AS JSON)", "{\"1\":\"" + new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()).toString() + "\"}");
        this.assertFunction("CAST(MAP(ARRAY[from_unixtime(1)], ARRAY[1.0]) AS JSON)", "{\"" + new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()).toString() + "\":1.0}");
    }

    @Test
    public void testJsonToMap() throws Exception {
        this.assertFunction("CAST(CAST('{\"1\":2, \"3\": 4}' AS JSON) AS MAP<BIGINT, BIGINT>)", ImmutableMap.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        this.assertFunction("CAST(CAST('{\"1\":2.0, \"3\": 4.0}' AS JSON) AS MAP<BIGINT, DOUBLE>)", ImmutableMap.of((Object)1L, (Object)2.0, (Object)3L, (Object)4.0));
        this.assertFunction("CAST(CAST('{\"1\":[2, 3], \"4\": [5]}' AS JSON) AS MAP<BIGINT, ARRAY<BIGINT>>)", ImmutableMap.of((Object)1L, (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)4L, (Object)ImmutableList.of((Object)5L)));
        this.assertFunction("CAST(CAST('{\"puppies\":\"kittens\"}' AS JSON) AS MAP<VARCHAR, VARCHAR>)", ImmutableMap.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("CAST(CAST('{\"true\":\"kittens\"}' AS JSON) AS MAP<BOOLEAN, VARCHAR>)", ImmutableMap.of((Object)true, (Object)"kittens"));
        this.assertFunction("CAST(CAST('null' AS JSON) AS MAP<BOOLEAN, VARCHAR>)", null);
        this.assertInvalidFunction("CAST(CAST('{\"true\":\"kittens\"}' AS JSON) AS MAP<BOOLEAN, VARBINARY>)");
    }

    @Test
    public void testSubscript() throws Exception {
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY [2, 4])[3]", 4L);
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY[2, NULL])[3]", null);
        this.assertFunction("MAP(ARRAY [1, 3], ARRAY [2.0, 4.0])[1]", 2.0);
        this.assertFunction("MAP(ARRAY[1.0, 2.0], ARRAY[ ARRAY[1, 2], ARRAY[3]])[1.0]", ImmutableList.of((Object)1L, (Object)2L));
        this.assertFunction("MAP(ARRAY['puppies'], ARRAY['kittens'])['puppies']", "kittens");
        this.assertFunction("MAP(ARRAY[TRUE,FALSE],ARRAY[2,4])[TRUE]", 2L);
        this.assertFunction("MAP(ARRAY['1', '100'], ARRAY[from_unixtime(1), from_unixtime(100)])['1']", new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()));
        this.assertFunction("MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[1.0, 100.0])[from_unixtime(1)]", 1.0);
    }

    @Test
    public void testMapKeys() throws Exception {
        this.assertFunction("MAP_KEYS(MAP(ARRAY['1', '3'], ARRAY['2', '4']))", ImmutableList.of((Object)"1", (Object)"3"));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[1.0, 2.0], ARRAY[ARRAY[1, 2], ARRAY[3]]))", ImmutableList.of((Object)1.0, (Object)2.0));
        this.assertFunction("MAP_KEYS(MAP(ARRAY['puppies'], ARRAY['kittens']))", ImmutableList.of((Object)"puppies"));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[TRUE], ARRAY[2]))", ImmutableList.of((Object)true));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[from_unixtime(1)], ARRAY[1.0]))", ImmutableList.of((Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[CAST('puppies' as varbinary)], ARRAY['kittens']))", ImmutableList.of((Object)new SqlVarbinary("puppies".getBytes("utf-8"))));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[1,2],  ARRAY[ARRAY[1, 2], ARRAY[3]]))", ImmutableList.of((Object)1L, (Object)2L));
        this.assertFunction("MAP_KEYS(MAP(ARRAY[1,4], ARRAY[MAP(ARRAY[2], ARRAY[3]), MAP(ARRAY[5], ARRAY[6])]))", ImmutableList.of((Object)1L, (Object)4L));
    }

    @Test
    public void testMapValues() throws Exception {
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[ARRAY[TRUE, FALSE, NULL]]))", ImmutableList.of((Object)Lists.newArrayList((Object[])new Boolean[]{true, false, null})));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[ARRAY[ARRAY[1, 2]]]))", ImmutableList.of((Object)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L))));
        this.assertFunction("MAP_VALUES(MAP(ARRAY [1, 3], ARRAY ['2', '4']))", ImmutableList.of((Object)"2", (Object)"4"));
        this.assertFunction("MAP_VALUES(MAP(ARRAY[1.0,2.0], ARRAY[ARRAY[1, 2], ARRAY[3]]))", ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)3L)));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['puppies'], ARRAY['kittens']))", ImmutableList.of((Object)"kittens"));
        this.assertFunction("MAP_VALUES(MAP(ARRAY[TRUE], ARRAY[2]))", ImmutableList.of((Object)2L));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[NULL]))", Lists.newArrayList((Object[])new Object[]{null}));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[TRUE]))", ImmutableList.of((Object)true));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1'], ARRAY[1.0]))", ImmutableList.of((Object)1.0));
        this.assertFunction("MAP_VALUES(MAP(ARRAY['1', '2'], ARRAY[ARRAY[1.0, 2.0], ARRAY[3.0, 4.0]]))", ImmutableList.of((Object)ImmutableList.of((Object)1.0, (Object)2.0), (Object)ImmutableList.of((Object)3.0, (Object)4.0)));
    }
}

