/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTime {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin");
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        Session session = Session.builder().setUser("user").setSource("test").setCatalog("catalog").setSchema("schema").setTimeZoneKey(TIME_ZONE_KEY).setLocale(Locale.ENGLISH).build();
        this.functionAssertions = new FunctionAssertions(session);
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() throws Exception {
        this.assertFunction("TIME '03:04:05.321'", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05'", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04'", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testEqual() throws Exception {
        this.assertFunction("TIME '03:04:05.321' = TIME '03:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321' = TIME '03:04:05.333'", false);
    }

    @Test
    public void testNotEqual() throws Exception {
        this.assertFunction("TIME '03:04:05.321' <> TIME '03:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321' <> TIME '03:04:05.321'", false);
    }

    @Test
    public void testLessThan() throws Exception {
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05.321'", false);
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05'", false);
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05'", false);
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.111'", true);
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.321'", false);
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.333'", false);
    }

    @Test
    public void testGreaterThanOrEqual() throws Exception {
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.111'", true);
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.333'", false);
    }

    @Test
    public void testBetween() throws Exception {
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.111' and TIME '03:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.321' and TIME '03:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.111' and TIME '03:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.321' and TIME '03:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.322' and TIME '03:04:05.333'", false);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.311' and TIME '03:04:05.312'", false);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.333' and TIME '03:04:05.111'", false);
    }

    @Test
    public void testCastToTimeWithTimeZone() {
        this.assertFunction("cast(TIME '03:04:05.321' as time with time zone)", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), DATE_TIME_ZONE.toTimeZone()));
    }

    @Test
    public void testCastToTimestamp() throws Exception {
        this.assertFunction("cast(TIME '03:04:05.321' as timestamp)", new SqlTimestamp(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testCastToTimestampWithTimeZone() throws Exception {
        this.assertFunction("cast(TIME '03:04:05.321' as timestamp with time zone)", new SqlTimestampWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testCastToSlice() throws Exception {
        this.assertFunction("cast(TIME '03:04:05.321' as varchar)", "03:04:05.321");
        this.assertFunction("cast(TIME '03:04:05' as varchar)", "03:04:05.000");
        this.assertFunction("cast(TIME '03:04' as varchar)", "03:04:00.000");
    }

    @Test
    public void testCastFromSlice() throws Exception {
        this.assertFunction("cast('03:04:05.321' as time) = TIME '03:04:05.321'", true);
        this.assertFunction("cast('03:04:05' as time) = TIME '03:04:05.000'", true);
        this.assertFunction("cast('03:04' as time) = TIME '03:04:00.000'", true);
    }
}

