/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeZoneKey;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTimeWithTimeZone {
    private static final DateTimeZone WEIRD_ZONE = DateTimeZone.forOffsetHoursMinutes((int)7, (int)9);
    private static final TimeZoneKey WEIRD_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)429L);
    private Session session;
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.session = Session.builder().setUser("user").setSource("test").setCatalog("catalog").setSchema("schema").setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"+06:09")).setLocale(Locale.ENGLISH).build();
        this.functionAssertions = new FunctionAssertions(this.session);
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() {
        this.assertFunction("TIME '03:04:05.321 +07:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05 +07:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 0, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04 +07:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 0, 0, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '3:4:5.321+07:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '3:4:5+07:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 0, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '3:4+07:09'", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 0, 0, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testEqual() {
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '03:04:05.321 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '02:04:05.321 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '02:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '03:04:05.333 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '02:04:05.333 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '02:04:05.333'", false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '03:04:05.333 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '02:04:05.333 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '02:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '03:04:05.321 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '02:04:05.321 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '02:04:05.321'", false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '03:04:05.333 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05.333 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '03:04:05.321 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05.321 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05.321'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '03:04:05 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05'", false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '03:04:05.333 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05.333 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '03:04:05.321 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05.321 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '03:04:05 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05'", false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '03:04:05.111 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.111 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.111'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '03:04:05.321 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.321 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.321'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '03:04:05.333 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.333 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.333'", false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '03:04:05.111 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.111 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.111'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '03:04:05.321 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.321 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '03:04:05.333 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.333 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.333'", false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.111 +07:09' and TIME '03:04:05.333 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.111 +06:09' and TIME '02:04:05.333 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.111' and TIME '02:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.321 +07:09' and TIME '03:04:05.333 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.321 +06:09' and TIME '02:04:05.333 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.321' and TIME '02:04:05.333'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.111 +07:09' and TIME '03:04:05.321 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.111 +06:09' and TIME '02:04:05.321 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.111' and TIME '02:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.321 +07:09' and TIME '03:04:05.321 +07:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.321 +06:09' and TIME '02:04:05.321 +06:09'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.321' and TIME '02:04:05.321'", true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.322 +07:09' and TIME '03:04:05.333 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.322 +06:09' and TIME '02:04:05.333 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.322' and TIME '02:04:05.333'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.311 +07:09' and TIME '03:04:05.312 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.311 +06:09' and TIME '02:04:05.312 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.311' and TIME '02:04:05.312'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.333 +07:09' and TIME '03:04:05.111 +07:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.333 +06:09' and TIME '02:04:05.111 +06:09'", false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.333' and TIME '02:04:05.111'", false);
    }

    @Test
    public void testCastToTime() throws Exception {
        this.assertFunction("cast(TIME '03:04:05.321 +07:09' as time)", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), this.session.getTimeZoneKey()));
    }

    @Test
    public void testCastToTimestamp() throws Exception {
        this.assertFunction("cast(TIME '03:04:05.321 +07:09' as timestamp)", new SqlTimestamp(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), this.session.getTimeZoneKey()));
    }

    @Test
    public void testCastToTimestampWithTimeZone() throws Exception {
        this.assertFunction("cast(TIME '03:04:05.321 +07:09' as timestamp with time zone)", new SqlTimestampWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(TIME '03:04:05.321 +07:09' as varchar)", "03:04:05.321 +07:09");
        this.assertFunction("cast(TIME '03:04:05 +07:09' as varchar)", "03:04:05.000 +07:09");
        this.assertFunction("cast(TIME '03:04 +07:09' as varchar)", "03:04:00.000 +07:09");
    }
}

