/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.util.ThreadLocalCache;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThreadLocalCache {
    @Test
    public void testSanity() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        ThreadLocalCache<String, String> cache = new ThreadLocalCache<String, String>(2){

            protected String load(String key) {
                return key + count.getAndAdd(1);
            }
        };
        Assert.assertEquals((String)((String)cache.get((Object)"abc")), (String)"abc0");
        Assert.assertEquals((String)((String)cache.get((Object)"abc")), (String)"abc0");
        Assert.assertEquals((String)((String)cache.get((Object)"def")), (String)"def1");
        Assert.assertEquals((String)((String)cache.get((Object)"abc")), (String)"abc0");
        Assert.assertEquals((String)((String)cache.get((Object)"ghi")), (String)"ghi2");
        Assert.assertEquals((String)((String)cache.get((Object)"abc")), (String)"abc3");
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="value must not be null")
    public void testDisallowsNulls() {
        new ThreadLocalCache<String, String>(10){

            protected String load(String key) {
                return null;
            }
        }.get((Object)"foo");
    }
}

