/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;

public enum LineItemColumn implements TpchColumn<LineItem>
{
    ORDER_KEY("orderkey", TpchColumnType.BIGINT){

        @Override
        public long getLong(LineItem lineItem) {
            return lineItem.getOrderKey();
        }
    }
    ,
    PART_KEY("partkey", TpchColumnType.BIGINT){

        @Override
        public long getLong(LineItem lineItem) {
            return lineItem.getPartKey();
        }
    }
    ,
    SUPPLIER_KEY("suppkey", TpchColumnType.BIGINT){

        @Override
        public long getLong(LineItem lineItem) {
            return lineItem.getSupplierKey();
        }
    }
    ,
    LINE_NUMBER("linenumber", TpchColumnType.BIGINT){

        @Override
        public long getLong(LineItem lineItem) {
            return lineItem.getLineNumber();
        }
    }
    ,
    QUANTITY("quantity", TpchColumnType.BIGINT){

        @Override
        public long getLong(LineItem lineItem) {
            return lineItem.getQuantity();
        }
    }
    ,
    EXTENDED_PRICE("extendedprice", TpchColumnType.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.getExtendedPrice();
        }
    }
    ,
    DISCOUNT("discount", TpchColumnType.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.getDiscount();
        }
    }
    ,
    TAX("tax", TpchColumnType.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.getTax();
        }
    }
    ,
    RETURN_FLAG("returnflag", TpchColumnType.VARCHAR){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getReturnFlag();
        }
    }
    ,
    STATUS("linestatus", TpchColumnType.VARCHAR){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getStatus();
        }
    }
    ,
    SHIP_DATE("shipdate", TpchColumnType.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.getShipDate();
        }
    }
    ,
    COMMIT_DATE("commitdate", TpchColumnType.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.getCommitDate();
        }
    }
    ,
    RECEIPT_DATE("receiptdate", TpchColumnType.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.getReceiptDate();
        }
    }
    ,
    SHIP_INSTRUCTIONS("shipinstruct", TpchColumnType.VARCHAR){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getShipInstructions();
        }
    }
    ,
    SHIP_MODE("shipmode", TpchColumnType.VARCHAR){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getShipMode();
        }
    }
    ,
    COMMENT("comment", TpchColumnType.VARCHAR){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getComment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private LineItemColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(LineItem entity) {
        throw new UnsupportedOperationException();
    }
}

