/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext.jdk8;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.LongStream;

public class LongStreamSerializer
extends StdSerializer<LongStream> {
    private static final long serialVersionUID = 1L;
    public static final LongStreamSerializer INSTANCE = new LongStreamSerializer();

    private LongStreamSerializer() {
        super(LongStream.class);
    }

    @Override
    public void serialize(LongStream stream, JsonGenerator g, SerializerProvider provider) throws IOException {
        try (LongStream ls = stream;){
            g.writeStartArray();
            ls.forEach(value -> {
                try {
                    g.writeNumber(value);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            g.writeEndArray();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

