/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext.jdk8;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.Stream;

public class Jdk8StreamSerializer
extends StdSerializer<Stream<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final JavaType elemType;
    private final transient JsonSerializer<Object> elemSerializer;

    public Jdk8StreamSerializer(JavaType streamType, JavaType elemType) {
        this(streamType, elemType, null);
    }

    public Jdk8StreamSerializer(JavaType streamType, JavaType elemType, JsonSerializer<Object> elemSerializer) {
        super(streamType);
        this.elemType = elemType;
        this.elemSerializer = elemSerializer;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        if (!this.elemType.hasRawClass(Object.class) && (provider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this.elemType.isFinal())) {
            return new Jdk8StreamSerializer(provider.getTypeFactory().constructParametricType(Stream.class, this.elemType), this.elemType, provider.findPrimaryPropertySerializer(this.elemType, property));
        }
        return this;
    }

    @Override
    public void serialize(Stream<?> stream, JsonGenerator g, SerializerProvider provider) throws IOException {
        try (Stream<?> s = stream;){
            g.writeStartArray();
            s.forEach(elem -> {
                try {
                    if (this.elemSerializer == null) {
                        provider.defaultSerializeValue(elem, g);
                    } else {
                        this.elemSerializer.serialize(elem, g, provider);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            g.writeEndArray();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

