/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BeanUtil {
    public static String okNameForGetter(AnnotatedMember am) {
        String name = am.getName();
        String str = BeanUtil.okNameForIsGetter(am, name);
        if (str == null) {
            str = BeanUtil.okNameForRegularGetter(am, name);
        }
        return str;
    }

    public static String okNameForRegularGetter(AnnotatedMember am, String name) {
        if (name.startsWith("get")) {
            if ("getCallbacks".equals(name) ? BeanUtil.isCglibGetCallbacks(am) : "getMetaClass".equals(name) && BeanUtil.isGroovyMetaClassGetter(am)) {
                return null;
            }
            return BeanUtil.stdManglePropertyName(name, 3);
        }
        return null;
    }

    public static String okNameForIsGetter(AnnotatedMember am, String name) {
        Class<?> rt;
        if (name.startsWith("is") && ((rt = am.getRawType()) == Boolean.class || rt == Boolean.TYPE)) {
            return BeanUtil.stdManglePropertyName(name, 2);
        }
        return null;
    }

    public static String okNameForMutator(AnnotatedMember am, String prefix) {
        String name = am.getName();
        if (name.startsWith(prefix)) {
            return BeanUtil.stdManglePropertyName(name, prefix.length());
        }
        return null;
    }

    public static Object getDefaultValue(JavaType type) {
        Class<?> cls = type.getRawClass();
        Class<?> prim = ClassUtil.primitiveType(cls);
        if (prim != null) {
            return ClassUtil.defaultValue(prim);
        }
        if (type.isContainerType() || type.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (cls == String.class) {
            return "";
        }
        if (type.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (type.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(0L);
            return c;
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMember am) {
        Class<?> compType;
        String pkgName;
        Class<?> rt = am.getRawType();
        if (rt.isArray() && (pkgName = ClassUtil.getPackageName(compType = rt.getComponentType())) != null && pkgName.contains(".cglib")) {
            return pkgName.startsWith("net.sf.cglib") || pkgName.startsWith("org.hibernate.repackage.cglib") || pkgName.startsWith("org.springframework.cglib");
        }
        return false;
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMember am) {
        String pkgName = ClassUtil.getPackageName(am.getRawType());
        return pkgName != null && pkgName.startsWith("groovy.lang");
    }

    protected static String stdManglePropertyName(String basename, int offset) {
        char c1;
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c0 = basename.charAt(offset);
        if (c0 == (c1 = Character.toLowerCase(c0))) {
            return basename.substring(offset);
        }
        if (offset + 1 < end && Character.isUpperCase(basename.charAt(offset + 1))) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(c1);
        sb.append(basename, offset + 1, end);
        return sb.toString();
    }
}

