/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext.jdk8;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.DoubleStream;

public class DoubleStreamSerializer
extends StdSerializer<DoubleStream> {
    private static final long serialVersionUID = 1L;
    public static final DoubleStreamSerializer INSTANCE = new DoubleStreamSerializer();

    private DoubleStreamSerializer() {
        super(DoubleStream.class);
    }

    @Override
    public void serialize(DoubleStream stream, JsonGenerator g, SerializerProvider provider) throws IOException {
        try (DoubleStream ds = stream;){
            g.writeStartArray();
            ds.forEach(value -> {
                try {
                    g.writeNumber(value);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            g.writeEndArray();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

