/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectWriteContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.GeneratorSettings;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectWriter
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final TokenStreamFactory _generatorFactory;
    protected final GeneratorSettings _generatorSettings;
    protected final Prefetch _prefetch;

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config, JavaType rootType, PrettyPrinter pp) {
        this._config = config;
        this._serializerProvider = mapper._serializerProvider;
        this._serializerFactory = mapper._serializerFactory;
        this._generatorFactory = mapper._jsonFactory;
        GeneratorSettings generatorSettings = this._generatorSettings = pp == null ? GeneratorSettings.empty : new GeneratorSettings(pp, null, null, null);
        if (rootType == null || rootType.hasRawClass(Object.class)) {
            this._prefetch = Prefetch.empty;
        } else {
            rootType = rootType.withStaticTyping();
            this._prefetch = Prefetch.empty.forRootType(this, rootType);
        }
    }

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config) {
        this._config = config;
        this._serializerProvider = mapper._serializerProvider;
        this._serializerFactory = mapper._serializerFactory;
        this._generatorFactory = mapper._jsonFactory;
        this._generatorSettings = GeneratorSettings.empty;
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config, FormatSchema s) {
        this._config = config;
        this._serializerProvider = mapper._serializerProvider;
        this._serializerFactory = mapper._serializerFactory;
        this._generatorFactory = mapper._jsonFactory;
        this._generatorSettings = s == null ? GeneratorSettings.empty : new GeneratorSettings(null, s, null, null);
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectWriter base, SerializationConfig config, GeneratorSettings genSettings, Prefetch prefetch) {
        this._config = config;
        this._serializerProvider = base._serializerProvider;
        this._serializerFactory = base._serializerFactory;
        this._generatorFactory = base._generatorFactory;
        this._generatorSettings = genSettings;
        this._prefetch = prefetch;
    }

    protected ObjectWriter(ObjectWriter base, SerializationConfig config) {
        this._config = config;
        this._serializerProvider = base._serializerProvider;
        this._serializerFactory = base._serializerFactory;
        this._generatorFactory = base._generatorFactory;
        this._generatorSettings = base._generatorSettings;
        this._prefetch = base._prefetch;
    }

    protected ObjectWriter(ObjectWriter base, TokenStreamFactory f) {
        this._config = (SerializationConfig)base._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, f.requiresPropertyOrdering());
        this._serializerProvider = base._serializerProvider;
        this._serializerFactory = base._serializerFactory;
        this._generatorFactory = f;
        this._generatorSettings = base._generatorSettings;
        this._prefetch = base._prefetch;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectWriter _new(ObjectWriter base, TokenStreamFactory f) {
        return new ObjectWriter(base, f);
    }

    protected ObjectWriter _new(ObjectWriter base, SerializationConfig config) {
        if (config == this._config) {
            return this;
        }
        return new ObjectWriter(base, config);
    }

    protected ObjectWriter _new(GeneratorSettings genSettings, Prefetch prefetch) {
        if (this._generatorSettings == genSettings && this._prefetch == prefetch) {
            return this;
        }
        return new ObjectWriter(this, this._config, genSettings, prefetch);
    }

    protected final SequenceWriter _newSequenceWriter(DefaultSerializerProvider prov, boolean wrapInArray, JsonGenerator gen, boolean managedInput) throws IOException {
        return new SequenceWriter(prov, gen, managedInput, this._prefetch).init(wrapInArray);
    }

    public ObjectWriter with(SerializationFeature feature) {
        return this._new(this, this._config.with(feature));
    }

    public ObjectWriter with(SerializationFeature first, SerializationFeature ... other) {
        return this._new(this, this._config.with(first, other));
    }

    public ObjectWriter withFeatures(SerializationFeature ... features) {
        return this._new(this, this._config.withFeatures(features));
    }

    public ObjectWriter without(SerializationFeature feature) {
        return this._new(this, this._config.without(feature));
    }

    public ObjectWriter without(SerializationFeature first, SerializationFeature ... other) {
        return this._new(this, this._config.without(first, other));
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... features) {
        return this._new(this, this._config.withoutFeatures(features));
    }

    public ObjectWriter with(JsonGenerator.Feature feature) {
        return this._new(this, this._config.with(feature));
    }

    public ObjectWriter withFeatures(JsonGenerator.Feature ... features) {
        return this._new(this, this._config.withFeatures(features));
    }

    public ObjectWriter without(JsonGenerator.Feature feature) {
        return this._new(this, this._config.without(feature));
    }

    public ObjectWriter withoutFeatures(JsonGenerator.Feature ... features) {
        return this._new(this, this._config.withoutFeatures(features));
    }

    public ObjectWriter with(FormatFeature feature) {
        return this._new(this, this._config.with(feature));
    }

    public ObjectWriter withFeatures(FormatFeature ... features) {
        return this._new(this, this._config.withFeatures(features));
    }

    public ObjectWriter without(FormatFeature feature) {
        return this._new(this, this._config.without(feature));
    }

    public ObjectWriter withoutFeatures(FormatFeature ... features) {
        return this._new(this, this._config.withoutFeatures(features));
    }

    public ObjectWriter forType(JavaType rootType) {
        return this._new(this._generatorSettings, this._prefetch.forRootType(this, rootType));
    }

    public ObjectWriter forType(Class<?> rootType) {
        if (rootType == Object.class) {
            return this.forType((JavaType)null);
        }
        return this.forType(this._config.constructType(rootType));
    }

    public ObjectWriter forType(TypeReference<?> rootType) {
        return this.forType(this._config.getTypeFactory().constructType(rootType.getType()));
    }

    public ObjectWriter with(DateFormat df) {
        return this._new(this, this._config.with(df));
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(this._config.getDefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        return this._new(this, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter pp) {
        return this._new(this._generatorSettings.with(pp), this._prefetch);
    }

    public ObjectWriter withRootName(String rootName) {
        return this._new(this, (SerializationConfig)this._config.withRootName(rootName));
    }

    public ObjectWriter withRootName(PropertyName rootName) {
        return this._new(this, this._config.withRootName(rootName));
    }

    public ObjectWriter withoutRootName() {
        return this._new(this, this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectWriter with(FormatSchema schema) {
        this._verifySchemaType(schema);
        return this._new(this._generatorSettings.with(schema), this._prefetch);
    }

    public ObjectWriter withView(Class<?> view) {
        return this._new(this, (SerializationConfig)this._config.withView((Class)view));
    }

    public ObjectWriter with(Locale l) {
        return this._new(this, (SerializationConfig)this._config.with(l));
    }

    public ObjectWriter with(TimeZone tz) {
        return this._new(this, (SerializationConfig)this._config.with(tz));
    }

    public ObjectWriter with(Base64Variant b64variant) {
        return this._new(this, (SerializationConfig)this._config.with(b64variant));
    }

    public ObjectWriter with(CharacterEscapes escapes) {
        return this._new(this._generatorSettings.with(escapes), this._prefetch);
    }

    public ObjectWriter with(TokenStreamFactory f) {
        return f == this._generatorFactory ? this : this._new(this, f);
    }

    public ObjectWriter with(ContextAttributes attrs) {
        return this._new(this, this._config.with(attrs));
    }

    public ObjectWriter withAttributes(Map<?, ?> attrs) {
        return this._new(this, (SerializationConfig)this._config.withAttributes(attrs));
    }

    public ObjectWriter withAttribute(Object key, Object value) {
        return this._new(this, (SerializationConfig)this._config.withAttribute(key, value));
    }

    public ObjectWriter withoutAttribute(Object key) {
        return this._new(this, (SerializationConfig)this._config.withoutAttribute(key));
    }

    public ObjectWriter withRootValueSeparator(String sep) {
        return this._new(this._generatorSettings.withRootValueSeparator(sep), this._prefetch);
    }

    public ObjectWriter withRootValueSeparator(SerializableString sep) {
        return this._new(this._generatorSettings.withRootValueSeparator(sep), this._prefetch);
    }

    public JsonGenerator createGenerator(OutputStream out) throws IOException {
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out, enc);
    }

    public JsonGenerator createGenerator(Writer w) throws IOException {
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), w);
    }

    public JsonGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), f, enc);
    }

    public JsonGenerator createGenerator(DataOutput out) throws IOException {
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out);
    }

    public ObjectNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    public ArrayNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    public SequenceWriter writeValues(File out) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        return this._newSequenceWriter(prov, false, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(JsonGenerator gen) throws IOException {
        return this._newSequenceWriter(this._serializerProvider(), false, gen, false);
    }

    public SequenceWriter writeValues(Writer out) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        return this._newSequenceWriter(prov, false, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out), true);
    }

    public SequenceWriter writeValues(OutputStream out) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        return this._newSequenceWriter(prov, false, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(DataOutput out) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        return this._newSequenceWriter(prov, false, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out), true);
    }

    public SequenceWriter writeValuesAsArray(File out) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        return this._newSequenceWriter(prov, true, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(JsonGenerator gen) throws IOException {
        return this._newSequenceWriter(this._serializerProvider(), true, gen, false);
    }

    public SequenceWriter writeValuesAsArray(Writer out) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        return this._newSequenceWriter(prov, true, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out), true);
    }

    public SequenceWriter writeValuesAsArray(OutputStream out) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        return this._newSequenceWriter(prov, true, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(DataOutput out) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        return this._newSequenceWriter(prov, true, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out), true);
    }

    public boolean isEnabled(SerializationFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(MapperFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(JsonGenerator.Feature f) {
        return this._generatorFactory.isEnabled(f);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    public TokenStreamFactory generatorFactory() {
        return this._generatorFactory;
    }

    public TypeFactory typeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._prefetch.hasSerializer();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    @Deprecated
    public TokenStreamFactory getFactory() {
        return this.generatorFactory();
    }

    @Deprecated
    public TypeFactory getTypeFactory() {
        return this.typeFactory();
    }

    public void writeValue(JsonGenerator gen, Object value) throws IOException {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            Closeable toClose = (Closeable)value;
            try {
                this._prefetch.serialize(gen, value, this._serializerProvider());
                if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                    gen.flush();
                }
            }
            catch (Exception e) {
                ClassUtil.closeOnFailAndThrowAsIOE(null, toClose, e);
                return;
            }
            toClose.close();
        } else {
            this._prefetch.serialize(gen, value, this._serializerProvider());
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                gen.flush();
            }
        }
    }

    public void writeValue(File resultFile, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        DefaultSerializerProvider prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._generatorFactory.createGenerator((ObjectWriteContext)prov, resultFile, JsonEncoding.UTF8), value);
    }

    public void writeValue(OutputStream out, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        DefaultSerializerProvider prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out, JsonEncoding.UTF8), value);
    }

    public void writeValue(Writer w, Object value) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._generatorFactory.createGenerator((ObjectWriteContext)prov, w), value);
    }

    public void writeValue(DataOutput out, Object value) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._generatorFactory.createGenerator((ObjectWriteContext)prov, out), value);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        SegmentedStringWriter sw = new SegmentedStringWriter(this._generatorFactory._getBufferRecycler());
        DefaultSerializerProvider prov = this._serializerProvider();
        try {
            this._configAndWriteValue(prov, this._generatorFactory.createGenerator((ObjectWriteContext)prov, (Writer)sw), value);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE(e);
        }
        return sw.getAndClear();
    }

    public byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        ByteArrayBuilder bb = new ByteArrayBuilder(this._generatorFactory._getBufferRecycler());
        DefaultSerializerProvider prov = this._serializerProvider();
        try {
            this._configAndWriteValue(prov, this._generatorFactory.createGenerator((ObjectWriteContext)prov, (OutputStream)bb, JsonEncoding.UTF8), value);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE(e);
        }
        byte[] result = bb.toByteArray();
        bb.release();
        return result;
    }

    protected final void _configAndWriteValue(DefaultSerializerProvider prov, JsonGenerator gen, Object value) throws IOException {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseable(gen, value);
            return;
        }
        try {
            this._prefetch.serialize(gen, value, prov);
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsIOE(gen, e);
            return;
        }
        gen.close();
    }

    private final void _writeCloseable(JsonGenerator gen, Object value) throws IOException {
        Closeable toClose = (Closeable)value;
        try {
            this._prefetch.serialize(gen, value, this._serializerProvider());
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsIOE(gen, toClose, e);
            return;
        }
        gen.close();
    }

    public void acceptJsonFormatVisitor(JavaType type, JsonFormatVisitorWrapper visitor) throws JsonMappingException {
        if (type == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        this._serializerProvider().acceptJsonFormatVisitor(type, visitor);
    }

    public void acceptJsonFormatVisitor(Class<?> rawType, JsonFormatVisitorWrapper visitor) throws JsonMappingException {
        this.acceptJsonFormatVisitor(this._config.constructType(rawType), visitor);
    }

    public boolean canSerialize(Class<?> type) {
        return this._serializerProvider().hasSerializerFor(type, null);
    }

    public boolean canSerialize(Class<?> type, AtomicReference<Throwable> cause) {
        return this._serializerProvider().hasSerializerFor(type, cause);
    }

    protected final DefaultSerializerProvider _serializerProvider() {
        return this._serializerProvider.createInstance(this._config, this._generatorSettings, this._serializerFactory);
    }

    protected void _verifySchemaType(FormatSchema schema) {
        if (schema != null && !this._generatorFactory.canUseSchema(schema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + schema.getClass().getName() + " for format " + this._generatorFactory.getFormatName());
        }
    }

    public static final class Prefetch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Prefetch empty = new Prefetch(null, null, null);
        private final JavaType rootType;
        private final JsonSerializer<Object> valueSerializer;
        private final TypeSerializer typeSerializer;

        private Prefetch(JavaType rootT, JsonSerializer<Object> ser, TypeSerializer typeSer) {
            this.rootType = rootT;
            this.valueSerializer = ser;
            this.typeSerializer = typeSer;
        }

        public Prefetch forRootType(ObjectWriter parent, JavaType newType) {
            boolean noType;
            boolean bl = noType = newType == null || newType.isJavaLangObject();
            if (noType) {
                if (this.rootType == null || this.valueSerializer == null) {
                    return this;
                }
                return new Prefetch(null, null, this.typeSerializer);
            }
            if (newType.equals(this.rootType)) {
                return this;
            }
            if (parent.isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
                DefaultSerializerProvider prov = parent._serializerProvider();
                try {
                    JsonSerializer<Object> ser = prov.findTypedValueSerializer(newType, true, null);
                    if (ser instanceof TypeWrappedSerializer) {
                        return new Prefetch(newType, null, ((TypeWrappedSerializer)ser).typeSerializer());
                    }
                    return new Prefetch(newType, ser, null);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            return new Prefetch(newType, null, this.typeSerializer);
        }

        public final JsonSerializer<Object> getValueSerializer() {
            return this.valueSerializer;
        }

        public final TypeSerializer getTypeSerializer() {
            return this.typeSerializer;
        }

        public boolean hasSerializer() {
            return this.valueSerializer != null || this.typeSerializer != null;
        }

        public void serialize(JsonGenerator gen, Object value, DefaultSerializerProvider prov) throws IOException {
            if (this.typeSerializer != null) {
                prov.serializePolymorphic(gen, value, this.rootType, this.valueSerializer, this.typeSerializer);
            } else if (this.valueSerializer != null) {
                prov.serializeValue(gen, value, this.rootType, this.valueSerializer);
            } else if (this.rootType != null) {
                prov.serializeValue(gen, value, this.rootType);
            } else {
                prov.serializeValue(gen, value);
            }
        }
    }
}

