/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectReadContext;
import com.fasterxml.jackson.core.ObjectWriteContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.json.JsonFactory;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.Snapshottable;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DeserializationContexts;
import com.fasterxml.jackson.databind.cfg.GeneratorSettings;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.cfg.MapperBuilderState;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.cfg.SerializationContexts;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.MixInHandler;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectMapper
implements Versioned,
Serializable {
    private static final long serialVersionUID = 3L;
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected final TokenStreamFactory _streamFactory;
    protected final TypeFactory _typeFactory;
    protected final InjectableValues _injectableValues;
    protected final SerializationContexts _serializationContexts;
    protected final SerializationConfig _serializationConfig;
    protected final DeserializationContexts _deserializationContexts;
    protected final DeserializationConfig _deserializationConfig;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);
    protected final MapperBuilderState _savedBuilderState;

    public ObjectMapper() {
        this(new PrivateBuilder((TokenStreamFactory)new JsonFactory()));
    }

    public ObjectMapper(TokenStreamFactory streamFactory) {
        this(new PrivateBuilder(streamFactory));
    }

    protected ObjectMapper(MapperBuilder<?, ?> builder) {
        this._savedBuilderState = builder.saveStateApplyModules();
        this._streamFactory = builder.streamFactory();
        AtomicReference ref = new AtomicReference();
        builder.withAllConfigOverrides(overrides -> ref.set(overrides));
        ConfigOverrides configOverrides = (ConfigOverrides)Snapshottable.takeSnapshot((Snapshottable)((Snapshottable)ref.get()));
        this._typeFactory = (TypeFactory)Snapshottable.takeSnapshot((Snapshottable)builder.typeFactory());
        ClassIntrospector classIntr = builder.classIntrospector().forMapper(this);
        SubtypeResolver subtypeResolver = (SubtypeResolver)Snapshottable.takeSnapshot((Snapshottable)builder.subtypeResolver());
        MixInHandler mixIns = (MixInHandler)Snapshottable.takeSnapshot((Snapshottable)builder.mixInHandler());
        this._serializationContexts = builder.serializationContexts().forMapper(this, this._streamFactory, builder.serializerFactory());
        this._deserializationContexts = builder.deserializationContexts().forMapper(this, this._streamFactory, builder.deserializerFactory());
        this._injectableValues = (InjectableValues)Snapshottable.takeSnapshot((Snapshottable)builder.injectableValues());
        RootNameLookup rootNames = new RootNameLookup();
        FilterProvider filterProvider = (FilterProvider)Snapshottable.takeSnapshot((Snapshottable)builder.filterProvider());
        this._deserializationConfig = builder.buildDeserializationConfig(configOverrides, mixIns, this._typeFactory, classIntr, subtypeResolver, rootNames);
        this._serializationConfig = builder.buildSerializationConfig(configOverrides, mixIns, this._typeFactory, classIntr, subtypeResolver, rootNames, filterProvider);
    }

    public <M extends ObjectMapper, B extends MapperBuilder<M, B>> MapperBuilder<M, B> rebuild() {
        ClassUtil.verifyMustOverride(ObjectMapper.class, this, "rebuild");
        return new PrivateBuilder(this._savedBuilderState);
    }

    protected Object writeReplace() {
        return this._savedBuilderState;
    }

    protected Object readResolve() {
        throw new IllegalStateException("Should never deserialize `" + this.getClass().getName() + "` directly");
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public SerializationConfig serializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig deserializationConfig() {
        return this._deserializationConfig;
    }

    public TokenStreamFactory tokenStreamFactory() {
        return this._streamFactory;
    }

    public JsonNodeFactory getNodeFactory() {
        return this._deserializationConfig.getNodeFactory();
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    public JavaType constructType(Type t) {
        return this._typeFactory.constructType(t);
    }

    public boolean isEnabled(TokenStreamFactory.Feature f) {
        return this._streamFactory.isEnabled(f);
    }

    public boolean isEnabled(StreamReadFeature f) {
        return this._deserializationConfig.isEnabled(f);
    }

    public boolean isEnabled(StreamWriteFeature f) {
        return this._serializationConfig.isEnabled(f);
    }

    public boolean isEnabled(MapperFeature f) {
        return this._serializationConfig.isEnabled(f);
    }

    public boolean isEnabled(DeserializationFeature f) {
        return this._deserializationConfig.isEnabled(f);
    }

    public boolean isEnabled(SerializationFeature f) {
        return this._serializationConfig.isEnabled(f);
    }

    public Collection<Module> getRegisteredModules() {
        return this._savedBuilderState.modules();
    }

    public JsonParser createParser(File src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(URL src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(InputStream in) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, in));
    }

    public JsonParser createParser(Reader r) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, r));
    }

    public JsonParser createParser(byte[] data) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, data));
    }

    public JsonParser createParser(byte[] data, int offset, int len) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, data, offset, len));
    }

    public JsonParser createParser(String content) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(char[] content) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(char[] content, int offset, int len) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content, offset, len));
    }

    public JsonParser createParser(DataInput content) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createNonBlockingByteArrayParser() throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createNonBlockingByteArrayParser((ObjectReadContext)ctxt));
    }

    public JsonGenerator createGenerator(OutputStream out) throws IOException {
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out, enc);
    }

    public JsonGenerator createGenerator(Writer w) throws IOException {
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), w);
    }

    public JsonGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), f, enc);
    }

    public JsonGenerator createGenerator(DataOutput out) throws IOException {
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out);
    }

    public <T> T readValue(JsonParser p, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p);
        return (T)this._readValue(ctxt, p, this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(JsonParser p, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p);
        return (T)this._readValue(ctxt, p, this._typeFactory.constructType(valueTypeRef));
    }

    public final <T> T readValue(JsonParser p, ResolvedType valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p);
        return (T)this._readValue(ctxt, p, (JavaType)valueType);
    }

    public <T> T readValue(JsonParser p, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p);
        return (T)this._readValue(ctxt, p, valueType);
    }

    public <T extends TreeNode> T readTree(JsonParser p) throws IOException, JsonProcessingException {
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            return null;
        }
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p);
        JsonNode n = (JsonNode)this._readValue(ctxt, p, JSON_NODE_TYPE);
        if (n == null) {
            n = this.getNodeFactory().nullNode();
        }
        JsonNode result = n;
        return (T)result;
    }

    public <T> MappingIterator<T> readValues(JsonParser p, JavaType valueType) throws IOException, JsonProcessingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p);
        JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt, valueType);
        return new MappingIterator(valueType, p, ctxt, deser, false, null);
    }

    public <T> MappingIterator<T> readValues(JsonParser p, Class<T> valueType) throws IOException, JsonProcessingException {
        return this.readValues(p, this._typeFactory.constructType(valueType));
    }

    public JsonNode readTree(InputStream in) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, in));
    }

    public JsonNode readTree(Reader r) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, r));
    }

    public JsonNode readTree(String content) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonNode readTree(byte[] content) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonNode readTree(byte[] content, int offset, int len) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content, offset, len));
    }

    public JsonNode readTree(File file) throws IOException, JsonProcessingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, file));
    }

    public JsonNode readTree(URL source) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, source));
    }

    public void writeValue(JsonGenerator g, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        SerializationConfig config = this.serializationConfig();
        if (config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseableValue(g, value, config);
        } else {
            this._serializerProvider(config).serializeValue(g, value);
            if (config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                g.flush();
            }
        }
    }

    public void writeTree(JsonGenerator g, TreeNode rootNode) throws IOException, JsonProcessingException {
        SerializationConfig config = this.serializationConfig();
        this._serializerProvider(config).serializeValue(g, rootNode);
        if (config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            g.flush();
        }
    }

    public void writeTree(JsonGenerator g, JsonNode rootNode) throws IOException, JsonProcessingException {
        SerializationConfig config = this.serializationConfig();
        this._serializerProvider(config).serializeValue(g, rootNode);
        if (config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            g.flush();
        }
    }

    public ObjectNode createObjectNode() {
        return this._deserializationConfig.getNodeFactory().objectNode();
    }

    public ArrayNode createArrayNode() {
        return this._deserializationConfig.getNodeFactory().arrayNode();
    }

    public JsonParser treeAsTokens(TreeNode n) {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return new TreeTraversingParser((JsonNode)n, ctxt);
    }

    public <T> T treeToValue(TreeNode n, Class<T> valueType) throws JsonProcessingException {
        try {
            Object ob;
            if (TreeNode.class.isAssignableFrom(valueType) && valueType.isAssignableFrom(n.getClass())) {
                return (T)n;
            }
            if (n.asToken() == JsonToken.VALUE_EMBEDDED_OBJECT && n instanceof POJONode && ((ob = ((POJONode)n).getPojo()) == null || valueType.isInstance(ob))) {
                return (T)ob;
            }
            return this.readValue(this.treeAsTokens(n), valueType);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public <T extends JsonNode> T valueToTree(Object fromValue) throws IllegalArgumentException {
        JsonNode result;
        if (fromValue == null) {
            return null;
        }
        SerializationConfig config = this.serializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
        DefaultSerializerProvider prov = this._serializerProvider(config);
        TokenBuffer buf = TokenBuffer.forValueConversion(prov);
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            buf = buf.forceUseOfBigDecimal(true);
        }
        try {
            prov.serializeValue(buf, fromValue);
            JsonParser p = buf.asParser(ObjectReadContext.empty());
            result = (JsonNode)this.readTree(p);
            p.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return (T)result;
    }

    public <T> T readValue(File src, Class<T> valueType) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(File src, TypeReference<T> valueTypeRef) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(File src, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(URL src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(URL src, TypeReference<T> valueTypeRef) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(URL src, JavaType valueType) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(String content, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(String content, TypeReference<T> valueTypeRef) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(String content, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), valueType);
    }

    public <T> T readValue(Reader src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(Reader src, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(Reader src, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(InputStream src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(InputStream src, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(InputStream src, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(byte[] src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(byte[] src, int offset, int len, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src, offset, len), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(byte[] src, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(byte[] src, int offset, int len, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src, offset, len), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(byte[] src, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(byte[] src, int offset, int len, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src, offset, len), valueType);
    }

    public <T> T readValue(DataInput src, Class<T> valueType) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(DataInput src, JavaType valueType) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public void writeValue(File resultFile, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        DefaultSerializerProvider prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, resultFile, JsonEncoding.UTF8), value);
    }

    public void writeValue(OutputStream out, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        DefaultSerializerProvider prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, out, JsonEncoding.UTF8), value);
    }

    public void writeValue(DataOutput out, Object value) throws IOException {
        DefaultSerializerProvider prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, out), value);
    }

    public void writeValue(Writer w, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        DefaultSerializerProvider prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, w), value);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        SegmentedStringWriter sw = new SegmentedStringWriter(this._streamFactory._getBufferRecycler());
        DefaultSerializerProvider prov = this._serializerProvider();
        try {
            this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, (Writer)sw), value);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE(e);
        }
        return sw.getAndClear();
    }

    public byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        DefaultSerializerProvider prov = this._serializerProvider();
        ByteArrayBuilder bb = new ByteArrayBuilder(this._streamFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, (OutputStream)bb, JsonEncoding.UTF8), value);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE(e);
        }
        byte[] result = bb.toByteArray();
        bb.release();
        return result;
    }

    protected final void _configAndWriteValue(DefaultSerializerProvider prov, JsonGenerator g, Object value) throws IOException {
        if (prov.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._configAndWriteCloseable(prov, g, value);
            return;
        }
        try {
            prov.serializeValue(g, value);
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsIOE(g, e);
            return;
        }
        g.close();
    }

    private final void _configAndWriteCloseable(DefaultSerializerProvider prov, JsonGenerator g, Object value) throws IOException {
        Closeable toClose = (Closeable)value;
        try {
            prov.serializeValue(g, value);
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsIOE(g, toClose, e);
            return;
        }
        g.close();
    }

    protected final void _writeCloseableValue(JsonGenerator g, Object value, SerializationConfig cfg) throws IOException {
        Closeable toClose = (Closeable)value;
        try {
            this._serializerProvider(cfg).serializeValue(g, value);
            if (cfg.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                g.flush();
            }
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsIOE(null, toClose, e);
            return;
        }
        toClose.close();
    }

    public ObjectWriter writer() {
        return this._newWriter(this.serializationConfig());
    }

    public ObjectWriter writer(SerializationFeature feature) {
        return this._newWriter(this.serializationConfig().with(feature));
    }

    public ObjectWriter writer(SerializationFeature first, SerializationFeature ... other) {
        return this._newWriter(this.serializationConfig().with(first, other));
    }

    public ObjectWriter writer(DateFormat df) {
        return this._newWriter(this.serializationConfig().with(df));
    }

    public ObjectWriter writerWithView(Class<?> serializationView) {
        return this._newWriter((SerializationConfig)this.serializationConfig().withView((Class)serializationView));
    }

    public ObjectWriter writerFor(Class<?> rootType) {
        return this._newWriter(this.serializationConfig(), rootType == null ? null : this._typeFactory.constructType(rootType), null);
    }

    public ObjectWriter writerFor(TypeReference<?> rootType) {
        return this._newWriter(this.serializationConfig(), rootType == null ? null : this._typeFactory.constructType(rootType), null);
    }

    public ObjectWriter writerFor(JavaType rootType) {
        return this._newWriter(this.serializationConfig(), rootType, null);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        SerializationConfig config = this.serializationConfig();
        return this._newWriter(config, null, config.getDefaultPrettyPrinter());
    }

    public ObjectWriter writer(FilterProvider filterProvider) {
        return this._newWriter(this.serializationConfig().withFilters(filterProvider));
    }

    public ObjectWriter writer(FormatSchema schema) {
        this._verifySchemaType(schema);
        return this._newWriter(this.serializationConfig(), schema);
    }

    public ObjectWriter writer(Base64Variant defaultBase64) {
        return this._newWriter((SerializationConfig)this.serializationConfig().with(defaultBase64));
    }

    public ObjectWriter writer(CharacterEscapes escapes) {
        return this._newWriter(this.serializationConfig()).with(escapes);
    }

    public ObjectWriter writer(ContextAttributes attrs) {
        return this._newWriter(this.serializationConfig().with(attrs));
    }

    public ObjectReader reader() {
        return this._newReader(this.deserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader reader(DeserializationFeature feature) {
        return this._newReader(this.deserializationConfig().with(feature));
    }

    public ObjectReader reader(DeserializationFeature first, DeserializationFeature ... other) {
        return this._newReader(this.deserializationConfig().with(first, other));
    }

    public ObjectReader readerForUpdating(Object valueToUpdate) {
        JavaType t = this._typeFactory.constructType(valueToUpdate.getClass());
        return this._newReader(this.deserializationConfig(), t, valueToUpdate, null, this._injectableValues);
    }

    public ObjectReader readerFor(JavaType type) {
        return this._newReader(this.deserializationConfig(), type, null, null, this._injectableValues);
    }

    public ObjectReader readerFor(Class<?> type) {
        return this._newReader(this.deserializationConfig(), this._typeFactory.constructType(type), null, null, this._injectableValues);
    }

    public ObjectReader readerFor(TypeReference<?> type) {
        return this._newReader(this.deserializationConfig(), this._typeFactory.constructType(type), null, null, this._injectableValues);
    }

    public ObjectReader reader(JsonNodeFactory f) {
        return this._newReader(this.deserializationConfig()).with(f);
    }

    public ObjectReader reader(FormatSchema schema) {
        this._verifySchemaType(schema);
        return this._newReader(this.deserializationConfig(), null, null, schema, this._injectableValues);
    }

    public ObjectReader reader(InjectableValues injectableValues) {
        return this._newReader(this.deserializationConfig(), null, null, null, injectableValues);
    }

    public ObjectReader readerWithView(Class<?> view) {
        return this._newReader((DeserializationConfig)this.deserializationConfig().withView((Class)view));
    }

    public ObjectReader reader(Base64Variant defaultBase64) {
        return this._newReader((DeserializationConfig)this.deserializationConfig().with(defaultBase64));
    }

    public ObjectReader reader(ContextAttributes attrs) {
        return this._newReader(this.deserializationConfig().with(attrs));
    }

    public <T> T convertValue(Object fromValue, Class<T> toValueType) throws IllegalArgumentException {
        return (T)this._convert(fromValue, this._typeFactory.constructType(toValueType));
    }

    public <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) throws IllegalArgumentException {
        return (T)this._convert(fromValue, this._typeFactory.constructType(toValueTypeRef));
    }

    public <T> T convertValue(Object fromValue, JavaType toValueType) throws IllegalArgumentException {
        return (T)this._convert(fromValue, toValueType);
    }

    protected Object _convert(Object fromValue, JavaType toValueType) throws IllegalArgumentException {
        SerializationConfig config = this.serializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
        DefaultSerializerProvider prov = this._serializerProvider(config);
        TokenBuffer buf = TokenBuffer.forValueConversion(prov);
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            buf = buf.forceUseOfBigDecimal(true);
        }
        try {
            Object result;
            prov.serializeValue(buf, fromValue);
            DefaultDeserializationContext readCtxt = this.createDeserializationContext();
            JsonParser p = buf.asParser(readCtxt);
            readCtxt.assignParser(p);
            JsonToken t = this._initForReading(p, toValueType);
            if (t == JsonToken.VALUE_NULL) {
                result = this._findRootDeserializer(readCtxt, toValueType).getNullValue(readCtxt);
            } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
                result = null;
            } else {
                JsonDeserializer<Object> deser = this._findRootDeserializer(readCtxt, toValueType);
                result = deser.deserialize(p, readCtxt);
            }
            p.close();
            return result;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public <T> T updateValue(T valueToUpdate, Object overrides) throws JsonMappingException {
        Object result;
        if (valueToUpdate == null || overrides == null) {
            return valueToUpdate;
        }
        SerializationConfig config = this.serializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
        DefaultSerializerProvider prov = this._serializerProvider(config);
        TokenBuffer buf = TokenBuffer.forValueConversion(prov);
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            buf = buf.forceUseOfBigDecimal(true);
        }
        try {
            prov.serializeValue(buf, overrides);
            JsonParser p = buf.asParser(ObjectReadContext.empty());
            result = this.readerForUpdating(valueToUpdate).readValue(p);
            p.close();
        }
        catch (IOException e) {
            if (e instanceof JsonMappingException) {
                throw (JsonMappingException)((Object)e);
            }
            throw JsonMappingException.fromUnexpectedIOE(e);
        }
        return result;
    }

    public void acceptJsonFormatVisitor(Class<?> type, JsonFormatVisitorWrapper visitor) throws JsonMappingException {
        this.acceptJsonFormatVisitor(this._typeFactory.constructType(type), visitor);
    }

    public void acceptJsonFormatVisitor(TypeReference<?> typeRef, JsonFormatVisitorWrapper visitor) throws JsonMappingException {
        this.acceptJsonFormatVisitor(this._typeFactory.constructType(typeRef), visitor);
    }

    public void acceptJsonFormatVisitor(JavaType type, JsonFormatVisitorWrapper visitor) throws JsonMappingException {
        if (type == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        this._serializerProvider().acceptJsonFormatVisitor(type, visitor);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig config) {
        return this._serializationContexts.createContext(config, GeneratorSettings.empty());
    }

    protected DefaultSerializerProvider _serializerProvider() {
        return this._serializationContexts.createContext(this.serializationConfig(), GeneratorSettings.empty());
    }

    protected Object _readValue(DeserializationContext ctxt, JsonParser p, JavaType valueType) throws IOException {
        Object result;
        JsonToken t = this._initForReading(p, valueType);
        DeserializationConfig config = ctxt.getConfig();
        if (t == JsonToken.VALUE_NULL) {
            result = this._findRootDeserializer(ctxt, valueType).getNullValue(ctxt);
        } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
            result = null;
        } else {
            JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt, valueType);
            result = config.useRootWrapping() ? this._unwrapAndDeserialize(p, ctxt, config, valueType, deser) : deser.deserialize(p, ctxt);
        }
        p.clearCurrentToken();
        if (config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, valueType);
        }
        return result;
    }

    protected Object _readMapAndClose(DefaultDeserializationContext ctxt, JsonParser p0, JavaType valueType) throws IOException {
        ctxt.assignParser(p0);
        try (JsonParser p = p0;){
            Object result;
            JsonToken t = this._initForReading(p, valueType);
            if (t == JsonToken.VALUE_NULL) {
                result = this._findRootDeserializer(ctxt, valueType).getNullValue(ctxt);
            } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
                result = null;
            } else {
                DeserializationConfig config = ctxt.getConfig();
                JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt, valueType);
                result = config.useRootWrapping() ? this._unwrapAndDeserialize(p, ctxt, config, valueType, deser) : deser.deserialize(p, ctxt);
                ctxt.checkUnresolvedObjectId();
            }
            if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(p, ctxt, valueType);
            }
            Object object = result;
            return object;
        }
    }

    protected JsonNode _readTreeAndClose(DeserializationContext ctxt, JsonParser p0) throws IOException {
        try (JsonParser p = p0;){
            JsonNode resultNode;
            JavaType valueType = JSON_NODE_TYPE;
            DeserializationConfig cfg = this.deserializationConfig();
            JsonToken t = p.currentToken();
            if (t == null && (t = p.nextToken()) == null) {
                JsonNode jsonNode = cfg.getNodeFactory().missingNode();
                return jsonNode;
            }
            if (t == JsonToken.VALUE_NULL) {
                resultNode = cfg.getNodeFactory().nullNode();
            } else {
                JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt, valueType);
                resultNode = cfg.useRootWrapping() ? (JsonNode)this._unwrapAndDeserialize(p, ctxt, cfg, valueType, deser) : (JsonNode)deser.deserialize(p, ctxt);
            }
            if (cfg.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(p, ctxt, valueType);
            }
            NullNode nullNode = resultNode;
            return nullNode;
        }
    }

    protected Object _unwrapAndDeserialize(JsonParser p, DeserializationContext ctxt, DeserializationConfig config, JavaType rootType, JsonDeserializer<Object> deser) throws IOException {
        String actualName;
        PropertyName expRootName = config.findRootName(rootType);
        String expSimpleName = expRootName.getSimpleName();
        if (p.currentToken() != JsonToken.START_OBJECT) {
            ctxt.reportWrongTokenException(rootType, JsonToken.START_OBJECT, "Current token not START_OBJECT (needed to unwrap root name '%s'), but %s", expSimpleName, p.currentToken());
        }
        if (p.nextToken() != JsonToken.FIELD_NAME) {
            ctxt.reportWrongTokenException(rootType, JsonToken.FIELD_NAME, "Current token not FIELD_NAME (to contain expected root name '%s'), but %s", expSimpleName, p.currentToken());
        }
        if (!expSimpleName.equals(actualName = p.currentName())) {
            ctxt.reportInputMismatch(rootType, "Root name '%s' does not match expected ('%s') for type %s", actualName, expSimpleName, rootType);
        }
        p.nextToken();
        Object result = deser.deserialize(p, ctxt);
        if (p.nextToken() != JsonToken.END_OBJECT) {
            ctxt.reportWrongTokenException(rootType, JsonToken.END_OBJECT, "Current token not END_OBJECT (to match wrapper object with root name '%s'), but %s", expSimpleName, p.currentToken());
        }
        if (config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, rootType);
        }
        return result;
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser p) {
        return this._deserializationContexts.createContext(this.deserializationConfig(), null, this._injectableValues).assignParser(p);
    }

    protected DefaultDeserializationContext createDeserializationContext() {
        return this._deserializationContexts.createContext(this.deserializationConfig(), null, this._injectableValues);
    }

    protected DefaultDeserializationContext createDeserializationContext(DeserializationConfig config, JsonParser p) {
        return this._deserializationContexts.createContext(config, null, this._injectableValues).assignParser(p);
    }

    protected JsonToken _initForReading(JsonParser p, JavaType targetType) throws IOException {
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            throw MismatchedInputException.from(p, targetType, "No content to map due to end-of-input");
        }
        return t;
    }

    protected final void _verifyNoTrailingTokens(JsonParser p, DeserializationContext ctxt, JavaType bindType) throws IOException {
        JsonToken t = p.nextToken();
        if (t != null) {
            Class<?> bt = ClassUtil.rawClass(bindType);
            ctxt.reportTrailingTokens(bt, p, t);
        }
    }

    protected ObjectReader _newReader(DeserializationConfig config) {
        return new ObjectReader(this, config);
    }

    protected ObjectReader _newReader(DeserializationConfig config, JavaType valueType, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        return new ObjectReader(this, config, valueType, valueToUpdate, schema, injectableValues);
    }

    protected ObjectWriter _newWriter(SerializationConfig config) {
        return new ObjectWriter(this, config);
    }

    protected ObjectWriter _newWriter(SerializationConfig config, FormatSchema schema) {
        return new ObjectWriter(this, config, schema);
    }

    protected ObjectWriter _newWriter(SerializationConfig config, JavaType rootType, PrettyPrinter pp) {
        return new ObjectWriter(this, config, rootType, pp);
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext ctxt, JavaType valueType) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser != null) {
            return deser;
        }
        deser = ctxt.findRootValueDeserializer(valueType);
        if (deser == null) {
            return (JsonDeserializer)ctxt.reportBadDefinition(valueType, "Cannot find a deserializer for type " + valueType);
        }
        this._rootDeserializers.put(valueType, deser);
        return deser;
    }

    protected void _verifySchemaType(FormatSchema schema) {
        if (schema != null && !this._streamFactory.canUseSchema(schema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + schema.getClass().getName() + " for format " + this._streamFactory.getFormatName());
        }
    }

    private static class PrivateBuilder
    extends MapperBuilder<ObjectMapper, PrivateBuilder> {
        public PrivateBuilder(TokenStreamFactory tsf) {
            super(tsf);
        }

        @Override
        public ObjectMapper build() {
            return new ObjectMapper(this);
        }

        @Override
        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public PrivateBuilder(MapperBuilderState state) {
            super(state);
        }

        static class StateImpl
        extends MapperBuilderState {
            private static final long serialVersionUID = 3L;

            public StateImpl(PrivateBuilder b) {
                super(b);
            }

            @Override
            protected Object readResolve() {
                return new PrivateBuilder(this).build();
            }
        }
    }
}

