/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectReadContext;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DeserializationContexts;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReader
implements Versioned {
    protected static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected final DeserializationConfig _config;
    protected final DeserializationContexts _contexts;
    protected final TokenStreamFactory _parserFactory;
    protected final boolean _unwrapRoot;
    private final TokenFilter _filter;
    protected final JavaType _valueType;
    protected final JsonDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;

    protected ObjectReader(ObjectMapper mapper, DeserializationConfig config) {
        this(mapper, config, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper mapper, DeserializationConfig config, JavaType valueType, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        this._config = config;
        this._contexts = mapper._deserializationContexts;
        this._rootDeserializers = mapper._rootDeserializers;
        this._parserFactory = mapper._streamFactory;
        this._valueType = valueType;
        this._valueToUpdate = valueToUpdate;
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(valueType);
        this._filter = null;
    }

    protected ObjectReader(ObjectReader base, DeserializationConfig config, JavaType valueType, JsonDeserializer<Object> rootDeser, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        this._config = config;
        this._contexts = base._contexts;
        this._rootDeserializers = base._rootDeserializers;
        this._parserFactory = base._parserFactory;
        this._valueType = valueType;
        this._rootDeserializer = rootDeser;
        this._valueToUpdate = valueToUpdate;
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._filter = base._filter;
    }

    protected ObjectReader(ObjectReader base, DeserializationConfig config) {
        this._config = config;
        this._contexts = base._contexts;
        this._rootDeserializers = base._rootDeserializers;
        this._parserFactory = base._parserFactory;
        this._valueType = base._valueType;
        this._rootDeserializer = base._rootDeserializer;
        this._valueToUpdate = base._valueToUpdate;
        this._schema = base._schema;
        this._injectableValues = base._injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._filter = base._filter;
    }

    protected ObjectReader(ObjectReader base, TokenFilter filter) {
        this._config = base._config;
        this._contexts = base._contexts;
        this._rootDeserializers = base._rootDeserializers;
        this._parserFactory = base._parserFactory;
        this._valueType = base._valueType;
        this._rootDeserializer = base._rootDeserializer;
        this._valueToUpdate = base._valueToUpdate;
        this._schema = base._schema;
        this._injectableValues = base._injectableValues;
        this._unwrapRoot = base._unwrapRoot;
        this._filter = filter;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectReader _new(ObjectReader base, DeserializationConfig config) {
        return new ObjectReader(base, config);
    }

    protected ObjectReader _new(ObjectReader base, DeserializationConfig config, JavaType valueType, JsonDeserializer<Object> rootDeser, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        return new ObjectReader(base, config, valueType, rootDeser, valueToUpdate, schema, injectableValues);
    }

    protected <T> MappingIterator<T> _newIterator(JsonParser p, DeserializationContext ctxt, JsonDeserializer<?> deser, boolean parserManaged) {
        return new MappingIterator(this._valueType, p, ctxt, deser, parserManaged, this._valueToUpdate);
    }

    protected JsonToken _initForReading(DefaultDeserializationContext ctxt, JsonParser p) throws IOException {
        ctxt.assignParser(p);
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            ctxt.reportInputMismatch(this._valueType, "No content to map due to end-of-input", new Object[0]);
        }
        return t;
    }

    protected void _initForMultiRead(DefaultDeserializationContext ctxt, JsonParser p) throws IOException {
        ctxt.assignParser(p);
    }

    public ObjectReader with(DeserializationFeature feature) {
        return this._with(this._config.with(feature));
    }

    public ObjectReader with(DeserializationFeature first, DeserializationFeature ... other) {
        return this._with(this._config.with(first, other));
    }

    public ObjectReader withFeatures(DeserializationFeature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(DeserializationFeature feature) {
        return this._with(this._config.without(feature));
    }

    public ObjectReader without(DeserializationFeature first, DeserializationFeature ... other) {
        return this._with(this._config.without(first, other));
    }

    public ObjectReader withoutFeatures(DeserializationFeature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader with(StreamReadFeature feature) {
        return this._with(this._config.with(feature));
    }

    public ObjectReader withFeatures(StreamReadFeature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(StreamReadFeature feature) {
        return this._with(this._config.without(feature));
    }

    public ObjectReader withoutFeatures(StreamReadFeature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader with(FormatFeature feature) {
        return this._with(this._config.with(feature));
    }

    public ObjectReader withFeatures(FormatFeature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(FormatFeature feature) {
        return this._with(this._config.without(feature));
    }

    public ObjectReader withoutFeatures(FormatFeature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader at(String value) {
        return new ObjectReader(this, (TokenFilter)new JsonPointerBasedFilter(value));
    }

    public ObjectReader at(JsonPointer pointer) {
        return new ObjectReader(this, (TokenFilter)new JsonPointerBasedFilter(pointer));
    }

    public ObjectReader with(DeserializationConfig config) {
        return this._with(config);
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, injectableValues);
    }

    public ObjectReader with(JsonNodeFactory f) {
        return this._with((DeserializationConfig)this._config.with(f));
    }

    public ObjectReader withRootName(String rootName) {
        return this._with((DeserializationConfig)this._config.withRootName(rootName));
    }

    public ObjectReader withRootName(PropertyName rootName) {
        return this._with(this._config.withRootName(rootName));
    }

    public ObjectReader withoutRootName() {
        return this._with(this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectReader with(FormatSchema schema) {
        if (this._schema == schema) {
            return this;
        }
        this._verifySchemaType(schema);
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, schema, this._injectableValues);
    }

    public ObjectReader forType(JavaType valueType) {
        if (valueType != null && valueType.equals(this._valueType)) {
            return this;
        }
        JsonDeserializer<Object> rootDeser = this._prefetchRootDeserializer(valueType);
        return this._new(this, this._config, valueType, rootDeser, this._valueToUpdate, this._schema, this._injectableValues);
    }

    public ObjectReader forType(Class<?> valueType) {
        return this.forType(this._config.constructType(valueType));
    }

    public ObjectReader forType(TypeReference<?> valueTypeRef) {
        return this.forType(this._config.getTypeFactory().constructType(valueTypeRef.getType()));
    }

    public ObjectReader withValueToUpdate(Object value) {
        if (value == this._valueToUpdate) {
            return this;
        }
        if (value == null) {
            return this._new(this, this._config, this._valueType, this._rootDeserializer, null, this._schema, this._injectableValues);
        }
        JavaType t = this._valueType == null ? this._config.constructType(value.getClass()) : this._valueType;
        return this._new(this, this._config, t, this._rootDeserializer, value, this._schema, this._injectableValues);
    }

    public ObjectReader withView(Class<?> activeView) {
        return this._with((DeserializationConfig)this._config.withView((Class)activeView));
    }

    public ObjectReader with(Locale l) {
        return this._with((DeserializationConfig)this._config.with(l));
    }

    public ObjectReader with(TimeZone tz) {
        return this._with((DeserializationConfig)this._config.with(tz));
    }

    public ObjectReader withHandler(DeserializationProblemHandler h) {
        return this._with(this._config.withHandler(h));
    }

    public ObjectReader with(Base64Variant defaultBase64) {
        return this._with((DeserializationConfig)this._config.with(defaultBase64));
    }

    public ObjectReader with(ContextAttributes attrs) {
        return this._with(this._config.with(attrs));
    }

    public ObjectReader withAttributes(Map<?, ?> attrs) {
        return this._with((DeserializationConfig)this._config.withAttributes(attrs));
    }

    public ObjectReader withAttribute(Object key, Object value) {
        return this._with((DeserializationConfig)this._config.withAttribute(key, value));
    }

    public ObjectReader withoutAttribute(Object key) {
        return this._with((DeserializationConfig)this._config.withoutAttribute(key));
    }

    protected final ObjectReader _with(DeserializationConfig newConfig) {
        if (newConfig == this._config) {
            return this;
        }
        return this._new(this, newConfig);
    }

    public boolean isEnabled(DeserializationFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(MapperFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(StreamReadFeature f) {
        return this._config.isEnabled(f);
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    public TokenStreamFactory parserFactory() {
        return this._parserFactory;
    }

    public TypeFactory typeFactory() {
        return this._config.getTypeFactory();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    @Deprecated
    public TypeFactory getTypeFactory() {
        return this.typeFactory();
    }

    public JsonParser createParser(File src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(URL src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(InputStream in) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, in));
    }

    public JsonParser createParser(Reader r) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, r));
    }

    public JsonParser createParser(byte[] data) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, data));
    }

    public JsonParser createParser(byte[] data, int offset, int len) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, data, offset, len));
    }

    public JsonParser createParser(String content) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(char[] content) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(char[] content, int offset, int len) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content, offset, len));
    }

    public JsonParser createParser(DataInput content) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createNonBlockingByteArrayParser() throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createNonBlockingByteArrayParser((ObjectReadContext)ctxt));
    }

    public ObjectNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    public ArrayNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    public <T> T readValue(JsonParser p) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p);
        return (T)this._bind(ctxt, p, this._valueToUpdate);
    }

    public <T> T readValue(JsonParser p, Class<T> valueType) throws IOException {
        return this.forType(valueType).readValue(p);
    }

    public <T> T readValue(JsonParser p, TypeReference<T> valueTypeRef) throws IOException {
        return this.forType(valueTypeRef).readValue(p);
    }

    public <T> T readValue(JsonParser p, ResolvedType valueType) throws IOException {
        return this.forType((JavaType)valueType).readValue(p);
    }

    public <T> T readValue(JsonParser p, JavaType valueType) throws IOException {
        return this.forType(valueType).readValue(p);
    }

    public <T> Iterator<T> readValues(JsonParser p, Class<T> valueType) throws IOException {
        return this.forType(valueType).readValues(p);
    }

    public <T> Iterator<T> readValues(JsonParser p, TypeReference<T> valueTypeRef) throws IOException {
        return this.forType(valueTypeRef).readValues(p);
    }

    public <T> Iterator<T> readValues(JsonParser p, ResolvedType valueType) throws IOException {
        return this.readValues(p, (JavaType)valueType);
    }

    public <T> Iterator<T> readValues(JsonParser p, JavaType valueType) throws IOException {
        return this.forType(valueType).readValues(p);
    }

    public JsonParser treeAsTokens(TreeNode n) {
        return this.treeAsTokens((JsonNode)n, this.createDeserializationContext());
    }

    protected JsonParser treeAsTokens(JsonNode n, DeserializationContext ctxt) {
        return new TreeTraversingParser(n, ctxt);
    }

    public <T extends TreeNode> T readTree(JsonParser p) throws IOException {
        return (T)this._bindAsTreeOrNull(this.createDeserializationContext(p), p);
    }

    public <T> T readValue(InputStream src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public <T> T readValue(Reader src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public <T> T readValue(String src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public <T> T readValue(byte[] src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public <T> T readValue(byte[] src, int offset, int length) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src, offset, length), false));
    }

    public <T> T readValue(File src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public <T> T readValue(URL src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public <T> T readValue(JsonNode src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this.treeAsTokens(src, ctxt), false));
    }

    public <T> T readValue(DataInput src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public JsonNode readTree(InputStream in) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, in), false));
    }

    public JsonNode readTree(Reader r) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, r), false));
    }

    public JsonNode readTree(String json) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, json), false));
    }

    public JsonNode readTree(byte[] json) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, json), false));
    }

    public JsonNode readTree(byte[] json, int offset, int len) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, json, offset, len), false));
    }

    public JsonNode readTree(DataInput src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public <T> MappingIterator<T> readValues(JsonParser p) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p);
        return this._newIterator(p, ctxt, this._findRootDeserializer(ctxt), false);
    }

    public <T> MappingIterator<T> readValues(InputStream src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> MappingIterator<T> readValues(Reader src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        JsonParser p = this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true);
        this._initForMultiRead(ctxt, p);
        p.nextToken();
        return this._newIterator(p, ctxt, this._findRootDeserializer(ctxt), true);
    }

    public <T> MappingIterator<T> readValues(String json) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        JsonParser p = this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, json), true);
        this._initForMultiRead(ctxt, p);
        p.nextToken();
        return this._newIterator(p, ctxt, this._findRootDeserializer(ctxt), true);
    }

    public <T> MappingIterator<T> readValues(byte[] src, int offset, int length) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src, offset, length), true));
    }

    public final <T> MappingIterator<T> readValues(byte[] src) throws IOException {
        return this.readValues(src, 0, src.length);
    }

    public <T> MappingIterator<T> readValues(File src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> MappingIterator<T> readValues(URL src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> MappingIterator<T> readValues(DataInput src) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> T treeToValue(TreeNode n, Class<T> valueType) throws JsonProcessingException {
        try {
            return this.readValue(this.treeAsTokens(n), valueType);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE(e);
        }
    }

    protected Object _bind(DefaultDeserializationContext ctxt, JsonParser p, Object valueToUpdate) throws IOException {
        Object result;
        JsonToken t = this._initForReading(ctxt, p);
        if (t == JsonToken.VALUE_NULL) {
            result = valueToUpdate == null ? this._findRootDeserializer(ctxt).getNullValue(ctxt) : valueToUpdate;
        } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
            result = valueToUpdate;
        } else {
            JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt);
            result = this._unwrapRoot ? this._unwrapAndDeserialize(p, ctxt, this._valueType, deser) : (valueToUpdate == null ? deser.deserialize(p, ctxt) : deser.deserialize(p, ctxt, valueToUpdate));
        }
        p.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, this._valueType);
        }
        return result;
    }

    protected Object _bindAndClose(DefaultDeserializationContext ctxt, JsonParser p0) throws IOException {
        try (JsonParser p = p0;){
            Object result;
            JsonToken t = this._initForReading(ctxt, p);
            if (t == JsonToken.VALUE_NULL) {
                result = this._valueToUpdate == null ? this._findRootDeserializer(ctxt).getNullValue(ctxt) : this._valueToUpdate;
            } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
                result = this._valueToUpdate;
            } else {
                JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt);
                if (this._unwrapRoot) {
                    result = this._unwrapAndDeserialize(p, ctxt, this._valueType, deser);
                } else if (this._valueToUpdate == null) {
                    result = deser.deserialize(p, ctxt);
                } else {
                    deser.deserialize(p, ctxt, this._valueToUpdate);
                    result = this._valueToUpdate;
                }
            }
            if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(p, ctxt, this._valueType);
            }
            Object object = result;
            return object;
        }
    }

    protected final JsonNode _bindAndCloseAsTree(DefaultDeserializationContext ctxt, JsonParser p0) throws IOException {
        try (JsonParser p = p0;){
            JsonNode jsonNode = this._bindAsTree(ctxt, p);
            return jsonNode;
        }
    }

    protected final JsonNode _bindAsTree(DefaultDeserializationContext ctxt, JsonParser p) throws IOException {
        JsonNode resultNode;
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            return this._config.getNodeFactory().missingNode();
        }
        if (t == JsonToken.VALUE_NULL) {
            resultNode = ctxt.getNodeFactory().nullNode();
        } else {
            JsonDeserializer<Object> deser = this._findTreeDeserializer(ctxt);
            if (this._unwrapRoot) {
                return (JsonNode)this._unwrapAndDeserialize(p, ctxt, JSON_NODE_TYPE, deser);
            }
            resultNode = (JsonNode)deser.deserialize(p, ctxt);
        }
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, JSON_NODE_TYPE);
        }
        return resultNode;
    }

    protected final JsonNode _bindAsTreeOrNull(DefaultDeserializationContext ctxt, JsonParser p) throws IOException {
        JsonNode resultNode;
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            return null;
        }
        if (t == JsonToken.VALUE_NULL) {
            resultNode = ctxt.getNodeFactory().nullNode();
        } else {
            JsonDeserializer<Object> deser = this._findTreeDeserializer(ctxt);
            if (this._unwrapRoot) {
                return (JsonNode)this._unwrapAndDeserialize(p, ctxt, JSON_NODE_TYPE, deser);
            }
            resultNode = (JsonNode)deser.deserialize(p, ctxt);
        }
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, JSON_NODE_TYPE);
        }
        return resultNode;
    }

    protected <T> MappingIterator<T> _bindAndReadValues(DefaultDeserializationContext ctxt, JsonParser p) throws IOException {
        this._initForMultiRead(ctxt, p);
        p.nextToken();
        return this._newIterator(p, ctxt, this._findRootDeserializer(ctxt), true);
    }

    protected Object _unwrapAndDeserialize(JsonParser p, DeserializationContext ctxt, JavaType rootType, JsonDeserializer<Object> deser) throws IOException {
        Object result;
        String actualName;
        PropertyName expRootName = this._config.findRootName(rootType);
        String expSimpleName = expRootName.getSimpleName();
        if (p.currentToken() != JsonToken.START_OBJECT) {
            ctxt.reportWrongTokenException(rootType, JsonToken.START_OBJECT, "Current token not START_OBJECT (needed to unwrap root name '%s'), but %s", expSimpleName, p.currentToken());
        }
        if (p.nextToken() != JsonToken.FIELD_NAME) {
            ctxt.reportWrongTokenException(rootType, JsonToken.FIELD_NAME, "Current token not FIELD_NAME (to contain expected root name '%s'), but %s", expSimpleName, p.currentToken());
        }
        if (!expSimpleName.equals(actualName = p.currentName())) {
            ctxt.reportInputMismatch(rootType, "Root name '%s' does not match expected ('%s') for type %s", actualName, expSimpleName, rootType);
        }
        p.nextToken();
        if (this._valueToUpdate == null) {
            result = deser.deserialize(p, ctxt);
        } else {
            deser.deserialize(p, ctxt, this._valueToUpdate);
            result = this._valueToUpdate;
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            ctxt.reportWrongTokenException(rootType, JsonToken.END_OBJECT, "Current token not END_OBJECT (to match wrapper object with root name '%s'), but %s", expSimpleName, p.currentToken());
        }
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, this._valueType);
        }
        return result;
    }

    protected JsonParser _considerFilter(JsonParser p, boolean multiValue) {
        return this._filter == null || FilteringParserDelegate.class.isInstance(p) ? p : new FilteringParserDelegate(p, this._filter, false, multiValue);
    }

    protected final void _verifyNoTrailingTokens(JsonParser p, DeserializationContext ctxt, JavaType bindType) throws IOException {
        JsonToken t = p.nextToken();
        if (t != null) {
            Class<?> bt = ClassUtil.rawClass(bindType);
            if (bt == null && this._valueToUpdate != null) {
                bt = this._valueToUpdate.getClass();
            }
            ctxt.reportTrailingTokens(bt, p, t);
        }
    }

    protected void _verifySchemaType(FormatSchema schema) {
        if (schema != null && !this._parserFactory.canUseSchema(schema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + schema.getClass().getName() + " for format " + this._parserFactory.getFormatName());
        }
    }

    protected DefaultDeserializationContext createDeserializationContext() {
        return this._contexts.createContext(this._config, this._schema, this._injectableValues);
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser p) {
        return this._contexts.createContext(this._config, this._schema, this._injectableValues).assignParser(p);
    }

    protected InputStream _inputStream(URL src) throws IOException {
        return src.openStream();
    }

    protected InputStream _inputStream(File f) throws IOException {
        return new FileInputStream(f);
    }

    protected void _reportUndetectableSource(Object src) throws JsonProcessingException {
        throw new JsonParseException(null, "Cannot use source of type " + src.getClass().getName() + " with format auto-detection: must be byte- not char-based");
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext ctxt) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        if (this._rootDeserializer != null) {
            return this._rootDeserializer;
        }
        JavaType t = this._valueType;
        if (t == null) {
            ctxt.reportBadDefinition((JavaType)null, "No value type configured for ObjectReader");
        }
        if ((deser = this._rootDeserializers.get(t)) != null) {
            return deser;
        }
        deser = ctxt.findRootValueDeserializer(t);
        if (deser == null) {
            ctxt.reportBadDefinition(t, "Cannot find a deserializer for type " + t);
        }
        this._rootDeserializers.put(t, deser);
        return deser;
    }

    protected JsonDeserializer<Object> _findTreeDeserializer(DeserializationContext ctxt) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._rootDeserializers.get(JSON_NODE_TYPE);
        if (deser == null) {
            deser = ctxt.findRootValueDeserializer(JSON_NODE_TYPE);
            if (deser == null) {
                ctxt.reportBadDefinition(JSON_NODE_TYPE, "Cannot find a deserializer for type " + JSON_NODE_TYPE);
            }
            this._rootDeserializers.put(JSON_NODE_TYPE, deser);
        }
        return deser;
    }

    protected JsonDeserializer<Object> _prefetchRootDeserializer(JavaType valueType) {
        if (valueType == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) {
            return null;
        }
        JsonDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser == null) {
            try {
                DefaultDeserializationContext ctxt = this.createDeserializationContext();
                deser = ctxt.findRootValueDeserializer(valueType);
                if (deser != null) {
                    this._rootDeserializers.put(valueType, deser);
                }
                return deser;
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return deser;
    }
}

