/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.MixInHandler;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.text.DateFormat;

public final class SerializationConfig
extends MapperConfigBase<SerializationFeature, SerializationConfig>
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final FilterProvider _filterProvider;
    protected final PrettyPrinter _defaultPrettyPrinter;
    protected final int _serFeatures;
    protected final int _streamWriteFeatures;
    protected final int _formatWriteFeatures;

    public SerializationConfig(MapperBuilder<?, ?> b, int mapperFeatures, int serFeatures, int streamWriteFeatures, int formatWriteFeatures, ConfigOverrides configOverrides, TypeFactory tf, ClassIntrospector classIntr, MixInHandler mixins, SubtypeResolver str, RootNameLookup rootNames, FilterProvider filterProvider) {
        super(b, mapperFeatures, tf, classIntr, mixins, str, configOverrides, rootNames);
        this._serFeatures = serFeatures;
        this._filterProvider = filterProvider;
        this._streamWriteFeatures = streamWriteFeatures;
        this._formatWriteFeatures = formatWriteFeatures;
        this._defaultPrettyPrinter = b.defaultPrettyPrinter();
    }

    private SerializationConfig(SerializationConfig src, int serFeatures, int streamWriteFeatures, int formatWriteFeatures) {
        super(src);
        this._serFeatures = serFeatures;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._streamWriteFeatures = streamWriteFeatures;
        this._formatWriteFeatures = formatWriteFeatures;
    }

    private SerializationConfig(SerializationConfig src, BaseSettings base) {
        super(src, base);
        this._serFeatures = src._serFeatures;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._streamWriteFeatures = src._streamWriteFeatures;
        this._formatWriteFeatures = src._formatWriteFeatures;
    }

    private SerializationConfig(SerializationConfig src, FilterProvider filters) {
        super(src);
        this._serFeatures = src._serFeatures;
        this._filterProvider = filters;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._streamWriteFeatures = src._streamWriteFeatures;
        this._formatWriteFeatures = src._formatWriteFeatures;
    }

    private SerializationConfig(SerializationConfig src, Class<?> view) {
        super(src, view);
        this._serFeatures = src._serFeatures;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._streamWriteFeatures = src._streamWriteFeatures;
        this._formatWriteFeatures = src._formatWriteFeatures;
    }

    private SerializationConfig(SerializationConfig src, PropertyName rootName) {
        super(src, rootName);
        this._serFeatures = src._serFeatures;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._streamWriteFeatures = src._streamWriteFeatures;
        this._formatWriteFeatures = src._formatWriteFeatures;
    }

    protected SerializationConfig(SerializationConfig src, ContextAttributes attrs) {
        super(src, attrs);
        this._serFeatures = src._serFeatures;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._streamWriteFeatures = src._streamWriteFeatures;
        this._formatWriteFeatures = src._formatWriteFeatures;
    }

    protected SerializationConfig(SerializationConfig src, PrettyPrinter defaultPP) {
        super(src);
        this._serFeatures = src._serFeatures;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = defaultPP;
        this._streamWriteFeatures = src._streamWriteFeatures;
        this._formatWriteFeatures = src._formatWriteFeatures;
    }

    @Override
    protected final SerializationConfig _withBase(BaseSettings newBase) {
        return this._base == newBase ? this : new SerializationConfig(this, newBase);
    }

    @Override
    public SerializationConfig withRootName(PropertyName rootName) {
        if (rootName == null ? this._rootName == null : rootName.equals(this._rootName)) {
            return this;
        }
        return new SerializationConfig(this, rootName);
    }

    @Override
    public SerializationConfig withView(Class<?> view) {
        return this._view == view ? this : new SerializationConfig(this, view);
    }

    @Override
    public SerializationConfig with(ContextAttributes attrs) {
        return attrs == this._attributes ? this : new SerializationConfig(this, attrs);
    }

    @Override
    public SerializationConfig with(DateFormat df) {
        SerializationConfig cfg = (SerializationConfig)super.with(df);
        if (df == null) {
            return cfg.with(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return cfg.without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public SerializationConfig with(SerializationFeature feature) {
        int newSerFeatures = this._serFeatures | feature.getMask();
        return newSerFeatures == this._serFeatures ? this : new SerializationConfig(this, newSerFeatures, this._streamWriteFeatures, this._formatWriteFeatures);
    }

    public SerializationConfig with(SerializationFeature first, SerializationFeature ... features) {
        int newSerFeatures = this._serFeatures | first.getMask();
        for (SerializationFeature f : features) {
            newSerFeatures |= f.getMask();
        }
        return newSerFeatures == this._serFeatures ? this : new SerializationConfig(this, newSerFeatures, this._streamWriteFeatures, this._formatWriteFeatures);
    }

    public SerializationConfig withFeatures(SerializationFeature ... features) {
        int newSerFeatures = this._serFeatures;
        for (SerializationFeature f : features) {
            newSerFeatures |= f.getMask();
        }
        return newSerFeatures == this._serFeatures ? this : new SerializationConfig(this, newSerFeatures, this._streamWriteFeatures, this._formatWriteFeatures);
    }

    public SerializationConfig without(SerializationFeature feature) {
        int newSerFeatures = this._serFeatures & ~feature.getMask();
        return newSerFeatures == this._serFeatures ? this : new SerializationConfig(this, newSerFeatures, this._streamWriteFeatures, this._formatWriteFeatures);
    }

    public SerializationConfig without(SerializationFeature first, SerializationFeature ... features) {
        int newSerFeatures = this._serFeatures & ~first.getMask();
        for (SerializationFeature f : features) {
            newSerFeatures &= ~f.getMask();
        }
        return newSerFeatures == this._serFeatures ? this : new SerializationConfig(this, newSerFeatures, this._streamWriteFeatures, this._formatWriteFeatures);
    }

    public SerializationConfig withoutFeatures(SerializationFeature ... features) {
        int newSerFeatures = this._serFeatures;
        for (SerializationFeature f : features) {
            newSerFeatures &= ~f.getMask();
        }
        return newSerFeatures == this._serFeatures ? this : new SerializationConfig(this, newSerFeatures, this._streamWriteFeatures, this._formatWriteFeatures);
    }

    public SerializationConfig with(StreamWriteFeature feature) {
        int newSet = this._streamWriteFeatures | feature.getMask();
        return this._streamWriteFeatures == newSet ? this : new SerializationConfig(this, this._serFeatures, newSet, this._formatWriteFeatures);
    }

    public SerializationConfig withFeatures(StreamWriteFeature ... features) {
        int newSet = this._streamWriteFeatures;
        for (StreamWriteFeature f : features) {
            newSet |= f.getMask();
        }
        return this._streamWriteFeatures == newSet ? this : new SerializationConfig(this, this._serFeatures, newSet, this._formatWriteFeatures);
    }

    public SerializationConfig without(StreamWriteFeature feature) {
        int newSet = this._streamWriteFeatures & ~feature.getMask();
        return this._streamWriteFeatures == newSet ? this : new SerializationConfig(this, this._serFeatures, newSet, this._formatWriteFeatures);
    }

    public SerializationConfig withoutFeatures(StreamWriteFeature ... features) {
        int newSet = this._streamWriteFeatures;
        for (StreamWriteFeature f : features) {
            newSet &= ~f.getMask();
        }
        return this._streamWriteFeatures == newSet ? this : new SerializationConfig(this, this._serFeatures, newSet, this._formatWriteFeatures);
    }

    public SerializationConfig with(FormatFeature feature) {
        int newSet = this._formatWriteFeatures | feature.getMask();
        return this._formatWriteFeatures == newSet ? this : new SerializationConfig(this, this._serFeatures, this._streamWriteFeatures, newSet);
    }

    public SerializationConfig withFeatures(FormatFeature ... features) {
        int newSet = this._formatWriteFeatures;
        for (FormatFeature f : features) {
            newSet |= f.getMask();
        }
        return this._formatWriteFeatures == newSet ? this : new SerializationConfig(this, this._serFeatures, this._streamWriteFeatures, newSet);
    }

    public SerializationConfig without(FormatFeature feature) {
        int newSet = this._formatWriteFeatures & ~feature.getMask();
        return this._formatWriteFeatures == newSet ? this : new SerializationConfig(this, this._serFeatures, this._streamWriteFeatures, newSet);
    }

    public SerializationConfig withoutFeatures(FormatFeature ... features) {
        int newSet = this._formatWriteFeatures;
        for (FormatFeature f : features) {
            newSet &= ~f.getMask();
        }
        return this._formatWriteFeatures == newSet ? this : new SerializationConfig(this, this._serFeatures, this._streamWriteFeatures, newSet);
    }

    public SerializationConfig withFilters(FilterProvider filterProvider) {
        return filterProvider == this._filterProvider ? this : new SerializationConfig(this, filterProvider);
    }

    public SerializationConfig withDefaultPrettyPrinter(PrettyPrinter pp) {
        return this._defaultPrettyPrinter == pp ? this : new SerializationConfig(this, pp);
    }

    public PrettyPrinter constructDefaultPrettyPrinter() {
        PrettyPrinter pp = this._defaultPrettyPrinter;
        if (pp instanceof Instantiatable) {
            pp = (PrettyPrinter)((Instantiatable)pp).createInstance();
        }
        return pp;
    }

    public int getStreamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public int getFormatWriteFeatures() {
        return this._formatWriteFeatures;
    }

    @Override
    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return !this._rootName.isEmpty();
        }
        return this.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(SerializationFeature f) {
        return (this._serFeatures & f.getMask()) != 0;
    }

    public final boolean isEnabled(StreamWriteFeature f) {
        return (this._streamWriteFeatures & f.getMask()) != 0;
    }

    public final boolean hasFormatFeature(FormatFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    public final boolean hasSerializationFeatures(int featureMask) {
        return (this._serFeatures & featureMask) == featureMask;
    }

    public final int getSerializationFeatures() {
        return this._serFeatures;
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public PrettyPrinter getDefaultPrettyPrinter() {
        return this._defaultPrettyPrinter;
    }

    public BeanDescription introspect(JavaType type) {
        return this.getClassIntrospector().forSerialization(this, type, this);
    }
}

