/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectWriteContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.tree.ArrayTreeNode;
import com.fasterxml.jackson.core.tree.ObjectTreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.GeneratorSettings;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerCache;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class SerializerProvider
extends DatabindContext
implements ObjectWriteContext {
    protected static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializer();
    protected final SerializationConfig _config;
    protected final GeneratorSettings _generatorConfig;
    protected final TokenStreamFactory _streamFactory;
    protected transient JsonGenerator _generator;
    protected final Class<?> _activeView;
    protected final SerializerFactory _serializerFactory;
    protected final JsonSerializer<Object> _nullValueSerializer;
    protected final boolean _stdNullValueSerializer;
    protected final SerializerCache _serializerCache;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;
    protected DateFormat _dateFormat;
    protected ContextAttributes _attributes;

    protected SerializerProvider(TokenStreamFactory streamFactory, SerializationConfig config, GeneratorSettings generatorConfig, SerializerFactory f, SerializerCache cache) {
        this._streamFactory = streamFactory;
        this._serializerFactory = f;
        this._config = config;
        this._generatorConfig = generatorConfig;
        this._serializerCache = cache;
        NullSerializer ser = f.getDefaultNullValueSerializer();
        if (ser == null) {
            this._stdNullValueSerializer = true;
            ser = NullSerializer.instance;
        } else {
            this._stdNullValueSerializer = false;
        }
        this._nullValueSerializer = ser;
        this._activeView = config.getActiveView();
        this._attributes = config.getAttributes();
        this._knownSerializers = this._serializerCache.getReadOnlyLookupMap();
    }

    public TokenStreamFactory getGeneratorFactory() {
        return this._streamFactory;
    }

    public FormatSchema getSchema() {
        return this._generatorConfig.getSchema();
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._generatorConfig.getCharacterEscapes();
    }

    public PrettyPrinter getPrettyPrinter() {
        PrettyPrinter pp = this._generatorConfig.getPrettyPrinter();
        if (pp == null && this.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            pp = this._config.constructDefaultPrettyPrinter();
        }
        return pp;
    }

    public SerializableString getRootValueSeparator(SerializableString defaultSeparator) {
        return this._generatorConfig.getRootValueSeparator(defaultSeparator);
    }

    public int getStreamWriteFeatures(int defaults) {
        return this._config.getStreamWriteFeatures();
    }

    public int getFormatWriteFeatures(int defaults) {
        return this._config.getFormatWriteFeatures();
    }

    public ArrayTreeNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    public ObjectTreeNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(JsonGenerator gen, Object value) throws IOException {
        JsonGenerator prevGen = this._generator;
        this._generator = gen;
        try {
            if (value == null) {
                if (this._stdNullValueSerializer) {
                    gen.writeNull();
                } else {
                    this._nullValueSerializer.serialize(null, gen, this);
                }
                return;
            }
            Class<?> cls = value.getClass();
            this.findTypedValueSerializer(cls, true).serialize(value, gen, this);
        }
        finally {
            this._generator = prevGen;
        }
    }

    public void writeTree(JsonGenerator gen, TreeNode tree) throws IOException {
        this.writeValue(gen, tree);
    }

    public final SerializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public final Class<?> getActiveView() {
        return this._activeView;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature feature) {
        return this._config.isEnabled(feature);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> baseType) {
        return this._config.getDefaultPropertyFormat(baseType);
    }

    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> baseType) {
        return this._config.getDefaultPropertyInclusion();
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object key) {
        return this._attributes.getAttribute(key);
    }

    @Override
    public SerializerProvider setAttribute(Object key, Object value) {
        this._attributes = this._attributes.withPerCallAttribute(key, value);
        return this;
    }

    public final boolean isEnabled(SerializationFeature feature) {
        return this._config.isEnabled(feature);
    }

    public final boolean hasSerializationFeatures(int featureMask) {
        return this._config.hasSerializationFeatures(featureMask);
    }

    public final FilterProvider getFilterProvider() {
        return this._config.getFilterProvider();
    }

    public JsonGenerator getGenerator() {
        return this._generator;
    }

    public abstract WritableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public BeanDescription introspect(JavaType type) throws JsonMappingException {
        return this._config.introspect(type);
    }

    public BeanDescription introspectClassAnnotations(Class<?> rawType) throws JsonMappingException {
        return this._config.introspectClassAnnotations(rawType);
    }

    public BeanDescription introspectClassAnnotations(JavaType type) throws JsonMappingException {
        return this._config.introspectClassAnnotations(type);
    }

    public JsonSerializer<Object> findTypedValueSerializer(Class<?> rawType, boolean cache) throws JsonMappingException {
        TypeWrappedSerializer ser = this._knownSerializers.typedValueSerializer(rawType);
        if (ser != null) {
            return ser;
        }
        JavaType fullType = this._config.constructType(rawType);
        ser = this.handleRootContextualization(this.findValueSerializer(rawType));
        TypeSerializer typeSer = this.findTypeSerializer(fullType);
        if (typeSer != null) {
            typeSer = typeSer.forProperty(this, null);
            ser = new TypeWrappedSerializer(typeSer, ser);
        }
        if (cache) {
            this._serializerCache.addTypedSerializer(rawType, ser);
        }
        return ser;
    }

    public JsonSerializer<Object> findTypedValueSerializer(JavaType valueType, boolean cache) throws JsonMappingException {
        TypeWrappedSerializer ser = this._knownSerializers.typedValueSerializer(valueType);
        if (ser != null) {
            return ser;
        }
        ser = this.handleRootContextualization(this.findValueSerializer(valueType));
        TypeSerializer typeSer = this.findTypeSerializer(valueType);
        if (typeSer != null) {
            typeSer = typeSer.forProperty(this, null);
            ser = new TypeWrappedSerializer(typeSer, ser);
        }
        if (cache) {
            this._serializerCache.addTypedSerializer(valueType, ser);
        }
        return ser;
    }

    public JsonSerializer<Object> findRootValueSerializer(Class<?> rawType) throws JsonMappingException {
        JavaType fullType;
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(rawType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(fullType = this._config.constructType(rawType))) == null) {
            ser = this._createAndCacheUntypedSerializer(rawType, fullType);
        }
        return this.handleRootContextualization(ser);
    }

    public JsonSerializer<Object> findRootValueSerializer(JavaType valueType) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null) {
            ser = this._createAndCacheUntypedSerializer(valueType);
        }
        return this.handleRootContextualization(ser);
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(JavaType valueType, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null) {
            ser = this._createAndCachePropertySerializer(valueType, property);
        }
        return this.handlePrimaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(Class<?> rawType, BeanProperty property) throws JsonMappingException {
        JavaType fullType;
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(rawType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(fullType = this._config.constructType(rawType))) == null) {
            ser = this._createAndCachePropertySerializer(rawType, fullType, property);
        }
        return this.handlePrimaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findSecondaryPropertySerializer(JavaType valueType, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null) {
            ser = this._createAndCachePropertySerializer(valueType, property);
        }
        return this.handleSecondaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findSecondaryPropertySerializer(Class<?> rawType, BeanProperty property) throws JsonMappingException {
        JavaType fullType;
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(rawType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(fullType = this._config.constructType(rawType))) == null) {
            ser = this._createAndCachePropertySerializer(rawType, fullType, property);
        }
        return this.handleSecondaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findValueSerializer(Class<?> rawType) throws JsonMappingException {
        JavaType fullType;
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(rawType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(fullType = this._config.constructType(rawType))) == null) {
            ser = this._createAndCacheUntypedSerializer(rawType, fullType);
        }
        return ser;
    }

    public JsonSerializer<Object> findValueSerializer(JavaType valueType) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null) {
            ser = this._createAndCacheUntypedSerializer(valueType);
        }
        return ser;
    }

    public TypeSerializer findTypeSerializer(JavaType baseType) throws JsonMappingException {
        return this.findTypeSerializer(baseType, this.introspectClassAnnotations(baseType));
    }

    public TypeSerializer findTypeSerializer(JavaType baseType, BeanDescription beanDesc) throws JsonMappingException {
        return this._config.getTypeResolverProvider().findTypeSerializer(this, baseType, beanDesc.getClassInfo());
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType baseType, AnnotatedMember accessor) throws JsonMappingException {
        return this._config.getTypeResolverProvider().findPropertyTypeSerializer(this, accessor, baseType);
    }

    public JsonSerializer<Object> findKeySerializer(JavaType keyType, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._serializerFactory.createKeySerializer(this, keyType, null);
        ser.resolve(this);
        return this.handleSecondaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findKeySerializer(Class<?> rawKeyType, BeanProperty property) throws JsonMappingException {
        return this.findKeySerializer(this._config.constructType(rawKeyType), property);
    }

    public JsonSerializer<Object> getDefaultNullValueSerializer() {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> findNullKeySerializer(JavaType serializationType, BeanProperty property) throws JsonMappingException {
        return this._serializerFactory.getDefaultNullKeySerializer();
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty property) throws JsonMappingException {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> unknownType) {
        if (unknownType == Object.class) {
            return DEFAULT_UNKNOWN_SERIALIZER;
        }
        return new UnknownSerializer(unknownType);
    }

    public boolean isUnknownTypeSerializer(JsonSerializer<?> ser) {
        if (ser == DEFAULT_UNKNOWN_SERIALIZER || ser == null) {
            return true;
        }
        return this.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS) && ser instanceof UnknownSerializer;
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(Class<?> rawType, JavaType fullType) throws JsonMappingException {
        JsonSerializer<Object> ser;
        BeanDescription beanDesc = this.introspect(fullType);
        try {
            ser = this._serializerFactory.createSerializer(this, fullType, beanDesc, null);
        }
        catch (IllegalArgumentException iae) {
            throw this._mappingProblem(iae, ClassUtil.exceptionMessage(iae), new Object[0]);
        }
        this._serializerCache.addAndResolveNonTypedSerializer(rawType, fullType, ser, this);
        return ser;
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(JavaType type) throws JsonMappingException {
        JsonSerializer<Object> ser;
        BeanDescription beanDesc = this.introspect(type);
        try {
            ser = this._serializerFactory.createSerializer(this, type, beanDesc, null);
        }
        catch (IllegalArgumentException iae) {
            throw this._mappingProblem(iae, ClassUtil.exceptionMessage(iae), new Object[0]);
        }
        this._serializerCache.addAndResolveNonTypedSerializer(type, ser, this);
        return ser;
    }

    protected JsonSerializer<Object> _createAndCachePropertySerializer(Class<?> rawType, JavaType fullType, BeanProperty prop) throws JsonMappingException {
        JsonSerializer<Object> ser;
        BeanDescription beanDesc = this.introspect(fullType);
        try {
            ser = this._serializerFactory.createSerializer(this, fullType, beanDesc, null);
        }
        catch (IllegalArgumentException iae) {
            throw this._mappingProblem(iae, ClassUtil.exceptionMessage(iae), new Object[0]);
        }
        this._serializerCache.addAndResolveNonTypedSerializer(rawType, fullType, ser, this);
        if (prop == null) {
            return ser;
        }
        return this._checkShapeShifting(fullType, beanDesc, prop, ser);
    }

    protected JsonSerializer<Object> _createAndCachePropertySerializer(JavaType type, BeanProperty prop) throws JsonMappingException {
        JsonSerializer<Object> ser;
        BeanDescription beanDesc = this.introspect(type);
        try {
            ser = this._serializerFactory.createSerializer(this, type, beanDesc, null);
        }
        catch (IllegalArgumentException iae) {
            throw this._mappingProblem(iae, ClassUtil.exceptionMessage(iae), new Object[0]);
        }
        this._serializerCache.addAndResolveNonTypedSerializer(type, ser, this);
        if (prop == null) {
            return ser;
        }
        return this._checkShapeShifting(type, beanDesc, prop, ser);
    }

    private JsonSerializer<Object> _checkShapeShifting(JavaType type, BeanDescription beanDesc, BeanProperty prop, JsonSerializer<?> ser) throws JsonMappingException {
        JsonFormat.Value overrides = prop.findFormatOverrides(this._config);
        if (overrides != null) {
            JsonSerializer<?> ser2 = ser.withFormatOverrides(this._config, overrides);
            ser = ser2 != null ? ser2 : this._serializerFactory.createSerializer(this, type, beanDesc, overrides);
        }
        return ser;
    }

    protected JsonSerializer<Object> _handleResolvable(JsonSerializer<?> ser) throws JsonMappingException {
        ser.resolve(this);
        return ser;
    }

    public abstract JsonSerializer<Object> serializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract Object includeFilterInstance(BeanPropertyDefinition var1, Class<?> var2) throws JsonMappingException;

    public abstract boolean includeFilterSuppressNulls(Object var1) throws JsonMappingException;

    public JsonSerializer<Object> handlePrimaryContextualization(JsonSerializer<?> ser, BeanProperty property) throws JsonMappingException {
        if (ser != null) {
            ser = ser.createContextual(this, property);
        }
        return ser;
    }

    public JsonSerializer<Object> handleSecondaryContextualization(JsonSerializer<?> ser, BeanProperty property) throws JsonMappingException {
        if (ser != null) {
            ser = ser.createContextual(this, property);
        }
        return ser;
    }

    public JsonSerializer<Object> handleRootContextualization(JsonSerializer<?> ser) throws JsonMappingException {
        if (ser != null) {
            ser = ser.createContextual(this, null);
        }
        return ser;
    }

    @Deprecated
    public final void defaultSerializeValue(Object value, JsonGenerator gen) throws IOException {
        this.writeValue(gen, value);
    }

    public final void defaultSerializeField(String fieldName, Object value, JsonGenerator gen) throws IOException {
        gen.writeFieldName(fieldName);
        this.writeValue(gen, value);
    }

    public final void defaultSerializeDateValue(long timestamp, JsonGenerator gen) throws IOException {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            gen.writeNumber(timestamp);
        } else {
            gen.writeString(this._dateFormat().format(new Date(timestamp)));
        }
    }

    public final void defaultSerializeDateValue(Date date, JsonGenerator gen) throws IOException {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            gen.writeNumber(date.getTime());
        } else {
            gen.writeString(this._dateFormat().format(date));
        }
    }

    public void defaultSerializeDateKey(long timestamp, JsonGenerator gen) throws IOException {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            gen.writeFieldName(String.valueOf(timestamp));
        } else {
            gen.writeFieldName(this._dateFormat().format(new Date(timestamp)));
        }
    }

    public void defaultSerializeDateKey(Date date, JsonGenerator gen) throws IOException {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            gen.writeFieldName(String.valueOf(date.getTime()));
        } else {
            gen.writeFieldName(this._dateFormat().format(date));
        }
    }

    public final void defaultSerializeNullValue(JsonGenerator gen) throws IOException {
        if (this._stdNullValueSerializer) {
            gen.writeNull();
        } else {
            this._nullValueSerializer.serialize(null, gen, this);
        }
    }

    public <T> T reportBadTypeDefinition(BeanDescription bean, String msg, Object ... msgArgs) throws JsonMappingException {
        String beanDesc = "N/A";
        if (bean != null) {
            beanDesc = ClassUtil.nameOf(bean.getBeanClass());
        }
        msg = String.format("Invalid type definition for type %s: %s", beanDesc, this._format(msg, msgArgs));
        throw InvalidDefinitionException.from(this.getGenerator(), msg, bean, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription bean, BeanPropertyDefinition prop, String message, Object ... msgArgs) throws JsonMappingException {
        message = this._format(message, msgArgs);
        String propName = "N/A";
        if (prop != null) {
            propName = this._quotedString(prop.getName());
        }
        String beanDesc = "N/A";
        if (bean != null) {
            beanDesc = ClassUtil.nameOf(bean.getBeanClass());
        }
        message = String.format("Invalid definition for property %s (of type %s): %s", propName, beanDesc, message);
        throw InvalidDefinitionException.from(this.getGenerator(), message, bean, prop);
    }

    @Override
    public <T> T reportBadDefinition(JavaType type, String msg) throws JsonMappingException {
        throw InvalidDefinitionException.from(this.getGenerator(), msg, type);
    }

    public <T> T reportBadDefinition(JavaType type, String msg, Throwable cause) throws JsonMappingException {
        InvalidDefinitionException e = InvalidDefinitionException.from(this.getGenerator(), msg, type);
        e.initCause(cause);
        throw e;
    }

    public <T> T reportBadDefinition(Class<?> raw, String msg, Throwable cause) throws JsonMappingException {
        InvalidDefinitionException e = InvalidDefinitionException.from(this.getGenerator(), msg, this.constructType(raw));
        e.initCause(cause);
        throw e;
    }

    public void reportMappingProblem(Throwable t, String message, Object ... msgArgs) throws JsonMappingException {
        throw this._mappingProblem(t, message, msgArgs);
    }

    protected JsonMappingException _mappingProblem(Throwable t, String message, Object ... msgArgs) {
        return JsonMappingException.from(this.getGenerator(), this._format(message, msgArgs), t);
    }

    public void reportMappingProblem(String message, Object ... msgArgs) throws JsonMappingException {
        throw JsonMappingException.from(this.getGenerator(), this._format(message, msgArgs));
    }

    @Override
    public JsonMappingException invalidTypeIdException(JavaType baseType, String typeId, String extraDesc) {
        String msg = String.format("Could not resolve type id '%s' as a subtype of %s", typeId, baseType);
        return InvalidTypeIdException.from(null, this._colonConcat(msg, extraDesc), baseType, typeId);
    }

    protected void _reportIncompatibleRootType(Object value, JavaType rootType) throws IOException {
        Class<?> wrapperType;
        if (rootType.isPrimitive() && (wrapperType = ClassUtil.wrapperType(rootType.getRawClass())).isAssignableFrom(value.getClass())) {
            return;
        }
        this.reportBadDefinition(rootType, String.format("Incompatible types: declared root type (%s) vs %s", rootType, ClassUtil.classNameOf(value)));
    }

    protected final DateFormat _dateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat df = this._config.getDateFormat();
        this._dateFormat = df = (DateFormat)df.clone();
        return df;
    }
}

