/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import java.io.Serializable;

public abstract class DeserializationContexts
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final transient TokenStreamFactory _streamFactory;
    protected final transient DeserializerFactory _deserializerFactory;
    protected final transient DeserializerCache _cache;

    protected DeserializationContexts() {
        this(null, null, null);
    }

    protected DeserializationContexts(TokenStreamFactory tsf, DeserializerFactory deserializerFactory, DeserializerCache cache) {
        this._streamFactory = tsf;
        this._deserializerFactory = deserializerFactory;
        this._cache = cache;
    }

    public DeserializationContexts forMapper(Object mapper, TokenStreamFactory tsf, DeserializerFactory deserializerFactory) {
        return this.forMapper(mapper, tsf, deserializerFactory, this._defaultCache());
    }

    protected abstract DeserializationContexts forMapper(Object var1, TokenStreamFactory var2, DeserializerFactory var3, DeserializerCache var4);

    public abstract DefaultDeserializationContext createContext(DeserializationConfig var1, FormatSchema var2, InjectableValues var3);

    protected DeserializerCache _defaultCache() {
        return new DeserializerCache();
    }

    public static class DefaultImpl
    extends DeserializationContexts {
        private static final long serialVersionUID = 3L;

        public DefaultImpl() {
        }

        public DefaultImpl(TokenStreamFactory tsf, DeserializerFactory serializerFactory, DeserializerCache cache) {
            super(tsf, serializerFactory, cache);
        }

        @Override
        public DeserializationContexts forMapper(Object mapper, TokenStreamFactory tsf, DeserializerFactory serializerFactory, DeserializerCache cache) {
            return new DefaultImpl(tsf, serializerFactory, cache);
        }

        @Override
        public DefaultDeserializationContext createContext(DeserializationConfig config, FormatSchema schema, InjectableValues injectables) {
            return new DefaultDeserializationContext.Impl(this._streamFactory, this._deserializerFactory, this._cache, config, schema, injectables);
        }

        public DeserializerCache cacheForTests() {
            return this._cache;
        }
    }
}

