/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Snapshottable;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DefaultTyping;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.DeserializationContexts;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperBuilderState;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.ModuleContextBase;
import com.fasterxml.jackson.databind.cfg.MutableConfigOverride;
import com.fasterxml.jackson.databind.cfg.SerializationContexts;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.MixInHandler;
import com.fasterxml.jackson.databind.introspect.MixInResolver;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.NoneShallPassValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeResolverProvider;
import com.fasterxml.jackson.databind.jsontype.impl.DefaultTypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.LinkedNode;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public abstract class MapperBuilder<M extends ObjectMapper, B extends MapperBuilder<M, B>> {
    protected static final int DEFAULT_MAPPER_FEATURES = MapperConfig.collectFeatureDefaults(MapperFeature.class);
    protected static final int DEFAULT_SER_FEATURES = MapperConfig.collectFeatureDefaults(SerializationFeature.class);
    protected static final int DEFAULT_DESER_FEATURES = MapperConfig.collectFeatureDefaults(DeserializationFeature.class);
    protected static final PrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final PolymorphicTypeValidator DEFAULT_TYPE_VALIDATOR = new NoneShallPassValidator();
    protected static final BaseSettings DEFAULT_BASE_SETTINGS = new BaseSettings(DEFAULT_ANNOTATION_INTROSPECTOR, null, null, DEFAULT_TYPE_VALIDATOR, StdDateFormat.instance, null, Locale.getDefault(), null, Base64Variants.getDefaultVariant(), JsonNodeFactory.instance);
    protected static final TypeResolverProvider DEFAULT_TYPE_RESOLVER_PROVIDER = new TypeResolverProvider();
    protected static final AbstractTypeResolver[] NO_ABSTRACT_TYPE_RESOLVERS = new AbstractTypeResolver[0];
    protected BaseSettings _baseSettings;
    protected TokenStreamFactory _streamFactory;
    protected final ConfigOverrides _configOverrides;
    protected Map<Object, Module> _modules;
    protected TypeFactory _typeFactory;
    protected ClassIntrospector _classIntrospector;
    protected TypeResolverProvider _typeResolverProvider;
    protected SubtypeResolver _subtypeResolver;
    protected MixInHandler _mixInHandler;
    protected SerializationContexts _serializationContexts;
    protected SerializerFactory _serializerFactory;
    protected FilterProvider _filterProvider;
    protected PrettyPrinter _defaultPrettyPrinter;
    protected DeserializationContexts _deserializationContexts;
    protected DeserializerFactory _deserializerFactory;
    protected InjectableValues _injectableValues;
    protected LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected AbstractTypeResolver[] _abstractTypeResolvers;
    protected int _mapperFeatures;
    protected int _serFeatures;
    protected int _deserFeatures;
    protected int _streamReadFeatures;
    protected int _streamWriteFeatures;
    protected int _formatReadFeatures;
    protected int _formatWriteFeatures;
    protected transient MapperBuilderState _savedState;

    protected MapperBuilder(TokenStreamFactory streamFactory) {
        this._streamFactory = streamFactory;
        this._baseSettings = DEFAULT_BASE_SETTINGS;
        this._configOverrides = new ConfigOverrides();
        this._modules = null;
        this._streamReadFeatures = streamFactory.getStreamReadFeatures();
        this._streamWriteFeatures = streamFactory.getStreamWriteFeatures();
        this._formatReadFeatures = streamFactory.getFormatReadFeatures();
        this._formatWriteFeatures = streamFactory.getFormatWriteFeatures();
        this._mapperFeatures = DEFAULT_MAPPER_FEATURES;
        if (streamFactory.requiresPropertyOrdering()) {
            this._mapperFeatures |= MapperFeature.SORT_PROPERTIES_ALPHABETICALLY.getMask();
        }
        this._deserFeatures = DEFAULT_DESER_FEATURES;
        this._serFeatures = DEFAULT_SER_FEATURES;
        this._typeFactory = null;
        this._classIntrospector = null;
        this._typeResolverProvider = null;
        this._subtypeResolver = null;
        this._mixInHandler = null;
        this._serializerFactory = null;
        this._serializationContexts = null;
        this._filterProvider = null;
        this._deserializerFactory = null;
        this._deserializationContexts = null;
        this._injectableValues = null;
        this._problemHandlers = null;
        this._abstractTypeResolvers = NO_ABSTRACT_TYPE_RESOLVERS;
    }

    protected MapperBuilder(MapperBuilderState state) {
        this._streamFactory = state._streamFactory;
        this._baseSettings = state._baseSettings;
        this._configOverrides = (ConfigOverrides)Snapshottable.takeSnapshot((Snapshottable)state._configOverrides);
        this._streamReadFeatures = state._streamReadFeatures;
        this._streamWriteFeatures = state._streamWriteFeatures;
        this._formatReadFeatures = state._formatReadFeatures;
        this._formatWriteFeatures = state._formatWriteFeatures;
        this._mapperFeatures = state._mapperFeatures;
        this._deserFeatures = state._deserFeatures;
        this._serFeatures = state._serFeatures;
        this._typeFactory = (TypeFactory)Snapshottable.takeSnapshot((Snapshottable)state._typeFactory);
        this._classIntrospector = state._classIntrospector;
        this._typeResolverProvider = state._typeResolverProvider;
        this._subtypeResolver = (SubtypeResolver)Snapshottable.takeSnapshot((Snapshottable)state._subtypeResolver);
        this._mixInHandler = (MixInHandler)Snapshottable.takeSnapshot((Snapshottable)state._mixInHandler);
        this._serializationContexts = state._serializationContexts;
        this._serializerFactory = state._serializerFactory;
        this._filterProvider = state._filterProvider;
        this._defaultPrettyPrinter = state._defaultPrettyPrinter;
        this._deserializationContexts = state._deserializationContexts;
        this._deserializerFactory = state._deserializerFactory;
        this._injectableValues = (InjectableValues)Snapshottable.takeSnapshot((Snapshottable)state._injectableValues);
        this._problemHandlers = state._problemHandlers;
        this._abstractTypeResolvers = state._abstractTypeResolvers;
        if (state._modules == null) {
            this._modules = null;
        } else {
            this._modules = new LinkedHashMap<Object, Module>();
            for (Module mod : state._modules) {
                this.addModule(mod);
            }
        }
    }

    public abstract M build();

    public MapperBuilderState saveStateApplyModules() {
        if (this._savedState == null) {
            this._savedState = this._saveState();
            if (this._modules != null) {
                ModuleContextBase ctxt = this._constructModuleContext();
                this._modules.values().forEach(m -> m.setupModule(ctxt));
                ctxt.applyChanges(this);
            }
        }
        return this._savedState;
    }

    protected ModuleContextBase _constructModuleContext() {
        return new ModuleContextBase(this, this._configOverrides);
    }

    protected abstract MapperBuilderState _saveState();

    public SerializationConfig buildSerializationConfig(ConfigOverrides configOverrides, MixInHandler mixins, TypeFactory tf, ClassIntrospector classIntr, SubtypeResolver str, RootNameLookup rootNames, FilterProvider filterProvider) {
        return new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._streamWriteFeatures, this._formatWriteFeatures, configOverrides, tf, classIntr, mixins, str, rootNames, filterProvider);
    }

    public DeserializationConfig buildDeserializationConfig(ConfigOverrides configOverrides, MixInHandler mixins, TypeFactory tf, ClassIntrospector classIntr, SubtypeResolver str, RootNameLookup rootNames) {
        return new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._streamReadFeatures, this._formatReadFeatures, configOverrides, tf, classIntr, mixins, str, rootNames, this._abstractTypeResolvers);
    }

    public boolean isEnabled(MapperFeature f) {
        return f.enabledIn(this._mapperFeatures);
    }

    public boolean isEnabled(DeserializationFeature f) {
        return f.enabledIn(this._deserFeatures);
    }

    public boolean isEnabled(SerializationFeature f) {
        return f.enabledIn(this._serFeatures);
    }

    public boolean isEnabled(StreamReadFeature f) {
        return f.enabledIn(this._streamReadFeatures);
    }

    public boolean isEnabled(StreamWriteFeature f) {
        return f.enabledIn(this._streamWriteFeatures);
    }

    public BaseSettings baseSettings() {
        return this._baseSettings;
    }

    public TokenStreamFactory streamFactory() {
        return this._streamFactory;
    }

    public AnnotationIntrospector annotationIntrospector() {
        return this._baseSettings.getAnnotationIntrospector();
    }

    public TypeFactory typeFactory() {
        if (this._typeFactory == null) {
            this._typeFactory = this._defaultTypeFactory();
        }
        return this._typeFactory;
    }

    protected TypeFactory _defaultTypeFactory() {
        return TypeFactory.defaultInstance();
    }

    public ClassIntrospector classIntrospector() {
        if (this._classIntrospector == null) {
            this._classIntrospector = this._defaultClassIntrospector();
        }
        return this._classIntrospector;
    }

    protected ClassIntrospector _defaultClassIntrospector() {
        return new BasicClassIntrospector();
    }

    public TypeResolverProvider typeResolverProvider() {
        if (this._typeResolverProvider == null) {
            this._typeResolverProvider = this._defaultTypeResolverProvider();
        }
        return this._typeResolverProvider;
    }

    protected TypeResolverProvider _defaultTypeResolverProvider() {
        return new TypeResolverProvider();
    }

    public SubtypeResolver subtypeResolver() {
        if (this._subtypeResolver == null) {
            this._subtypeResolver = this._defaultSubtypeResolver();
        }
        return this._subtypeResolver;
    }

    protected SubtypeResolver _defaultSubtypeResolver() {
        return new StdSubtypeResolver();
    }

    public MixInHandler mixInHandler() {
        if (this._mixInHandler == null) {
            this._mixInHandler = this._defaultMixInHandler();
        }
        return this._mixInHandler;
    }

    protected MixInHandler _defaultMixInHandler() {
        return new MixInHandler(null);
    }

    public SerializationContexts serializationContexts() {
        if (this._serializationContexts == null) {
            this._serializationContexts = this._defaultSerializationContexts();
        }
        return this._serializationContexts;
    }

    protected SerializationContexts _defaultSerializationContexts() {
        return new SerializationContexts.DefaultImpl();
    }

    public SerializerFactory serializerFactory() {
        if (this._serializerFactory == null) {
            this._serializerFactory = this._defaultSerializerFactory();
        }
        return this._serializerFactory;
    }

    protected SerializerFactory _defaultSerializerFactory() {
        return BeanSerializerFactory.instance;
    }

    public FilterProvider filterProvider() {
        return this._filterProvider;
    }

    public PrettyPrinter defaultPrettyPrinter() {
        if (this._defaultPrettyPrinter == null) {
            this._defaultPrettyPrinter = this._defaultPrettyPrinter();
        }
        return this._defaultPrettyPrinter;
    }

    protected PrettyPrinter _defaultPrettyPrinter() {
        return DEFAULT_PRETTY_PRINTER;
    }

    public DeserializationContexts deserializationContexts() {
        if (this._deserializationContexts == null) {
            this._deserializationContexts = this._defaultDeserializationContexts();
        }
        return this._deserializationContexts;
    }

    protected DeserializationContexts _defaultDeserializationContexts() {
        return new DeserializationContexts.DefaultImpl();
    }

    public DeserializerFactory deserializerFactory() {
        if (this._deserializerFactory == null) {
            this._deserializerFactory = this._defaultDeserializerFactory();
        }
        return this._deserializerFactory;
    }

    DeserializerFactory _defaultDeserializerFactory() {
        return BeanDeserializerFactory.instance;
    }

    public InjectableValues injectableValues() {
        return this._injectableValues;
    }

    public LinkedNode<DeserializationProblemHandler> deserializationProblemHandlers() {
        return this._problemHandlers;
    }

    public B enable(MapperFeature ... features) {
        for (MapperFeature f : features) {
            this._mapperFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(MapperFeature ... features) {
        for (MapperFeature f : features) {
            this._mapperFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(MapperFeature feature, boolean state) {
        this._mapperFeatures = state ? (this._mapperFeatures |= feature.getMask()) : (this._mapperFeatures &= ~feature.getMask());
        return this._this();
    }

    public B enable(SerializationFeature ... features) {
        for (SerializationFeature f : features) {
            this._serFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(SerializationFeature ... features) {
        for (SerializationFeature f : features) {
            this._serFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(SerializationFeature feature, boolean state) {
        this._serFeatures = state ? (this._serFeatures |= feature.getMask()) : (this._serFeatures &= ~feature.getMask());
        return this._this();
    }

    public B enable(DeserializationFeature ... features) {
        for (DeserializationFeature f : features) {
            this._deserFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(DeserializationFeature ... features) {
        for (DeserializationFeature f : features) {
            this._deserFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(DeserializationFeature feature, boolean state) {
        this._deserFeatures = state ? (this._deserFeatures |= feature.getMask()) : (this._deserFeatures &= ~feature.getMask());
        return this._this();
    }

    public B enable(StreamReadFeature ... features) {
        for (StreamReadFeature f : features) {
            this._streamReadFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(StreamReadFeature ... features) {
        for (StreamReadFeature f : features) {
            this._streamReadFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(StreamReadFeature feature, boolean state) {
        this._streamReadFeatures = state ? (this._streamReadFeatures |= feature.getMask()) : (this._streamReadFeatures &= ~feature.getMask());
        return this._this();
    }

    public B enable(StreamWriteFeature ... features) {
        for (StreamWriteFeature f : features) {
            this._streamWriteFeatures |= f.getMask();
        }
        return this._this();
    }

    public B disable(StreamWriteFeature ... features) {
        for (StreamWriteFeature f : features) {
            this._streamWriteFeatures &= ~f.getMask();
        }
        return this._this();
    }

    public B configure(StreamWriteFeature feature, boolean state) {
        this._streamWriteFeatures = state ? (this._streamWriteFeatures |= feature.getMask()) : (this._streamWriteFeatures &= ~feature.getMask());
        return this._this();
    }

    public B withConfigOverride(Class<?> forType, Consumer<MutableConfigOverride> handler) {
        handler.accept(this._configOverrides.findOrCreateOverride(forType));
        return this._this();
    }

    public B withAllConfigOverrides(Consumer<ConfigOverrides> handler) {
        handler.accept(this._configOverrides);
        return this._this();
    }

    public B changeDefaultVisibility(UnaryOperator<VisibilityChecker> handler) {
        VisibilityChecker oldV = this._configOverrides.getDefaultVisibility();
        VisibilityChecker newV = (VisibilityChecker)handler.apply(oldV);
        if (newV != oldV) {
            Objects.requireNonNull(newV, "Can not assign null default VisibilityChecker");
            this._configOverrides.setDefaultVisibility(newV);
        }
        return this._this();
    }

    public B changeDefaultPropertyInclusion(UnaryOperator<JsonInclude.Value> handler) {
        JsonInclude.Value oldIncl = this._configOverrides.getDefaultInclusion();
        JsonInclude.Value newIncl = (JsonInclude.Value)handler.apply(oldIncl);
        if (newIncl != oldIncl) {
            Objects.requireNonNull(newIncl, "Can not assign null default Property Inclusion");
            this._configOverrides.setDefaultInclusion(newIncl);
        }
        return this._this();
    }

    public B changeDefaultNullHandling(UnaryOperator<JsonSetter.Value> handler) {
        JsonSetter.Value oldIncl = this._configOverrides.getDefaultNullHandling();
        JsonSetter.Value newIncl = (JsonSetter.Value)handler.apply(oldIncl);
        if (newIncl != oldIncl) {
            Objects.requireNonNull(newIncl, "Can not assign null default Null Handling");
            this._configOverrides.setDefaultNullHandling(newIncl);
        }
        return this._this();
    }

    public B defaultMergeable(Boolean b) {
        this._configOverrides.setDefaultMergeable(b);
        return this._this();
    }

    public B removeAllModules() {
        this._modules = null;
        return this._this();
    }

    public B addModule(Module module) {
        if (module.getModuleName() == null) {
            throw new IllegalArgumentException("Module without defined name");
        }
        if (module.version() == null) {
            throw new IllegalArgumentException("Module without defined version");
        }
        Object moduleId = module.getRegistrationId();
        if (this._modules == null) {
            this._modules = new LinkedHashMap<Object, Module>();
        } else {
            this._modules.remove(moduleId);
        }
        this._modules.put(moduleId, module);
        return this._this();
    }

    public B addModules(Module ... modules) {
        for (Module module : modules) {
            this.addModule(module);
        }
        return this._this();
    }

    public B addModules(Iterable<? extends Module> modules) {
        for (Module module : modules) {
            this.addModule(module);
        }
        return this._this();
    }

    public static List<Module> findModules() {
        return MapperBuilder.findModules(null);
    }

    public static List<Module> findModules(ClassLoader classLoader) {
        ArrayList<Module> modules = new ArrayList<Module>();
        ServiceLoader<Module> loader = MapperBuilder.secureGetServiceLoader(Module.class, classLoader);
        for (Module module : loader) {
            modules.add(module);
        }
        return modules;
    }

    private static <T> ServiceLoader<T> secureGetServiceLoader(final Class<T> clazz, final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<T>>(){

            @Override
            public ServiceLoader<T> run() {
                return classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
            }
        });
    }

    public B findAndAddModules() {
        return this.addModules(MapperBuilder.findModules());
    }

    public B withModules(Consumer<Module> handler) {
        if (this._modules != null) {
            this._modules.values().forEach(handler);
        }
        return this._this();
    }

    public B baseSettings(BaseSettings b) {
        this._baseSettings = b;
        return this._this();
    }

    public B annotationIntrospector(AnnotationIntrospector intr) {
        this._baseSettings = this._baseSettings.withAnnotationIntrospector(intr);
        return this._this();
    }

    public B nodeFactory(JsonNodeFactory f) {
        this._baseSettings = this._baseSettings.with(f);
        return this._this();
    }

    public B typeFactory(TypeFactory f) {
        this._typeFactory = f;
        return this._this();
    }

    public B addTypeModifier(TypeModifier modifier) {
        this._typeFactory = this.typeFactory().withModifier(modifier);
        return this._this();
    }

    protected B typeResolverProvider(TypeResolverProvider p) {
        this._typeResolverProvider = p;
        return this._this();
    }

    public B classIntrospector(ClassIntrospector ci) {
        this._classIntrospector = ci;
        return this._this();
    }

    public B subtypeResolver(SubtypeResolver r) {
        this._subtypeResolver = r;
        return this._this();
    }

    public B polymorphicTypeValidator(PolymorphicTypeValidator ptv) {
        this._baseSettings = this._baseSettings.with(ptv);
        return this._this();
    }

    public B handlerInstantiator(HandlerInstantiator hi) {
        this._baseSettings = this._baseSettings.with(hi);
        return this._this();
    }

    public B propertyNamingStrategy(PropertyNamingStrategy s) {
        this._baseSettings = this._baseSettings.with(s);
        return this._this();
    }

    public B serializerFactory(SerializerFactory f) {
        this._serializerFactory = f;
        return this._this();
    }

    public B serializationContexts(SerializationContexts ctxt) {
        this._serializationContexts = ctxt;
        return this._this();
    }

    public B filterProvider(FilterProvider prov) {
        this._filterProvider = prov;
        return this._this();
    }

    public B defaultPrettyPrinter(PrettyPrinter pp) {
        this._defaultPrettyPrinter = pp;
        return this._this();
    }

    public B deserializerFactory(DeserializerFactory f) {
        this._deserializerFactory = f;
        return this._this();
    }

    public B deserializationContext(DeserializationContexts ctxt) {
        this._deserializationContexts = ctxt;
        return this._this();
    }

    public B injectableValues(InjectableValues v) {
        this._injectableValues = v;
        return this._this();
    }

    public B addHandler(DeserializationProblemHandler h) {
        if (!LinkedNode.contains(this._problemHandlers, h)) {
            this._problemHandlers = new LinkedNode<DeserializationProblemHandler>(h, this._problemHandlers);
        }
        return this._this();
    }

    public B clearProblemHandlers() {
        this._problemHandlers = null;
        return this._this();
    }

    public B addAbstractTypeResolver(AbstractTypeResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Cannot pass null resolver");
        }
        this._abstractTypeResolvers = ArrayBuilders.insertInListNoDup(this._abstractTypeResolvers, resolver);
        return this._this();
    }

    public B defaultDateFormat(DateFormat f) {
        this._baseSettings = this._baseSettings.with(f);
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, f == null);
        return this._this();
    }

    public B defaultTimeZone(TimeZone tz) {
        this._baseSettings = this._baseSettings.with(tz);
        return this._this();
    }

    public B defaultLocale(Locale locale) {
        this._baseSettings = this._baseSettings.with(locale);
        return this._this();
    }

    public B defaultBase64Variant(Base64Variant v) {
        this._baseSettings = this._baseSettings.with(v);
        return this._this();
    }

    public B mixInHandler(MixInHandler h) {
        this._mixInHandler = h;
        return this._this();
    }

    public B mixInOverrides(MixInResolver r) {
        this._mixInHandler = this.mixInHandler().withOverrides(r);
        return this._this();
    }

    public B addMixIns(Map<Class<?>, Class<?>> sourceMixins) {
        this.mixInHandler().addLocalDefinitions(sourceMixins);
        return this._this();
    }

    public B addMixIn(Class<?> target, Class<?> mixinSource) {
        this.mixInHandler().addLocalDefinition(target, mixinSource);
        return this._this();
    }

    public B registerSubtypes(Class<?> ... subtypes) {
        this.subtypeResolver().registerSubtypes(subtypes);
        return this._this();
    }

    public B registerSubtypes(NamedType ... subtypes) {
        this.subtypeResolver().registerSubtypes(subtypes);
        return this._this();
    }

    public B registerSubtypes(Collection<Class<?>> subtypes) {
        this.subtypeResolver().registerSubtypes(subtypes);
        return this._this();
    }

    public B enableDefaultTyping(PolymorphicTypeValidator subtypeValidator) {
        return this.enableDefaultTyping(subtypeValidator, DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public B enableDefaultTyping(PolymorphicTypeValidator subtypeValidator, DefaultTyping dti) {
        return this.enableDefaultTyping(subtypeValidator, dti, JsonTypeInfo.As.WRAPPER_ARRAY);
    }

    public B enableDefaultTyping(PolymorphicTypeValidator subtypeValidator, DefaultTyping applicability, JsonTypeInfo.As includeAs) {
        if (includeAs == JsonTypeInfo.As.EXTERNAL_PROPERTY) {
            throw new IllegalArgumentException("Cannot use includeAs of " + includeAs + " for Default Typing");
        }
        return this.setDefaultTyping(this._defaultDefaultTypingResolver(subtypeValidator, applicability, includeAs));
    }

    public B enableDefaultTypingAsProperty(PolymorphicTypeValidator subtypeValidator, DefaultTyping applicability, String propertyName) {
        return this.setDefaultTyping(this._defaultDefaultTypingResolver(subtypeValidator, applicability, propertyName));
    }

    public B disableDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public B setDefaultTyping(TypeResolverBuilder<?> typer) {
        this._baseSettings = this._baseSettings.with(typer);
        return this._this();
    }

    protected TypeResolverBuilder<?> _defaultDefaultTypingResolver(PolymorphicTypeValidator subtypeValidator, DefaultTyping applicability, JsonTypeInfo.As includeAs) {
        return new DefaultTypeResolverBuilder(subtypeValidator, applicability, includeAs);
    }

    protected TypeResolverBuilder<?> _defaultDefaultTypingResolver(PolymorphicTypeValidator subtypeValidator, DefaultTyping applicability, String propertyName) {
        return new DefaultTypeResolverBuilder(subtypeValidator, applicability, propertyName);
    }

    protected final B _this() {
        return (B)this;
    }
}

