/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.FailingSerializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ArrayIterator;
import java.io.Serializable;
import java.util.Objects;

public final class SerializerFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final JsonSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allowed in JSON (use a converting NullKeySerializer?)");
    protected static final Serializers[] NO_SERIALIZERS = new Serializers[0];
    protected static final BeanSerializerModifier[] NO_MODIFIERS = new BeanSerializerModifier[0];
    protected final Serializers[] _additionalSerializers;
    protected final Serializers[] _additionalKeySerializers;
    protected final BeanSerializerModifier[] _modifiers;
    protected final JsonSerializer<Object> _nullValueSerializer;
    protected final JsonSerializer<Object> _nullKeySerializer;

    public SerializerFactoryConfig() {
        this(null, null, null, DEFAULT_NULL_KEY_SERIALIZER, null);
    }

    protected SerializerFactoryConfig(Serializers[] allAdditionalSerializers, Serializers[] allAdditionalKeySerializers, BeanSerializerModifier[] modifiers, JsonSerializer<Object> nullKeySer, JsonSerializer<Object> nullValueSer) {
        this._additionalSerializers = allAdditionalSerializers == null ? NO_SERIALIZERS : allAdditionalSerializers;
        this._additionalKeySerializers = allAdditionalKeySerializers == null ? NO_SERIALIZERS : allAdditionalKeySerializers;
        this._modifiers = modifiers == null ? NO_MODIFIERS : modifiers;
        this._nullKeySerializer = nullKeySer;
        this._nullValueSerializer = nullValueSer;
    }

    public SerializerFactoryConfig withAdditionalSerializers(Serializers additional) {
        Objects.requireNonNull(additional, "Cannot pass null Serializers");
        Serializers[] all = ArrayBuilders.insertInListNoDup(this._additionalSerializers, additional);
        return new SerializerFactoryConfig(all, this._additionalKeySerializers, this._modifiers, this._nullKeySerializer, this._nullValueSerializer);
    }

    public SerializerFactoryConfig withAdditionalKeySerializers(Serializers additional) {
        Objects.requireNonNull(additional, "Cannot pass null Serializers");
        Serializers[] all = ArrayBuilders.insertInListNoDup(this._additionalKeySerializers, additional);
        return new SerializerFactoryConfig(this._additionalSerializers, all, this._modifiers, this._nullKeySerializer, this._nullValueSerializer);
    }

    public SerializerFactoryConfig withSerializerModifier(BeanSerializerModifier modifier) {
        Objects.requireNonNull(modifier, "Cannot pass null BeanSerializerModifier");
        BeanSerializerModifier[] modifiers = ArrayBuilders.insertInListNoDup(this._modifiers, modifier);
        return new SerializerFactoryConfig(this._additionalSerializers, this._additionalKeySerializers, modifiers, this._nullKeySerializer, this._nullValueSerializer);
    }

    public SerializerFactoryConfig withNullValueSerializer(JsonSerializer<?> nvs) {
        Objects.requireNonNull(nvs, "Cannot pass null JsonSerializer");
        return new SerializerFactoryConfig(this._additionalSerializers, this._additionalKeySerializers, this._modifiers, this._nullKeySerializer, nvs);
    }

    public SerializerFactoryConfig withNullKeySerializer(JsonSerializer<?> nks) {
        Objects.requireNonNull(nks, "Cannot pass null JsonSerializer");
        return new SerializerFactoryConfig(this._additionalSerializers, this._additionalKeySerializers, this._modifiers, nks, this._nullValueSerializer);
    }

    public boolean hasSerializers() {
        return this._additionalSerializers.length > 0;
    }

    public boolean hasKeySerializers() {
        return this._additionalKeySerializers.length > 0;
    }

    public boolean hasSerializerModifiers() {
        return this._modifiers.length > 0;
    }

    public Iterable<Serializers> serializers() {
        return new ArrayIterator<Serializers>(this._additionalSerializers);
    }

    public Iterable<Serializers> keySerializers() {
        return new ArrayIterator<Serializers>(this._additionalKeySerializers);
    }

    public Iterable<BeanSerializerModifier> serializerModifiers() {
        return new ArrayIterator<BeanSerializerModifier>(this._modifiers);
    }

    public JsonSerializer<Object> getNullKeySerializer() {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> getNullValueSerializer() {
        return this._nullValueSerializer;
    }
}

