/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.sym.FieldNameMatcher;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.BeanAsArrayDeserializer;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BeanDeserializer
extends BeanDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Exception _nullFromCreator;
    protected FieldNameMatcher _fieldMatcher;
    protected SettableBeanProperty[] _fieldsByIndex;
    protected volatile transient NameTransformer _currentlyTransforming;

    public BeanDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, HashSet<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        super(builder, beanDesc, properties, backRefs, ignorableProps, ignoreAllUnknown, hasViews);
    }

    protected BeanDeserializer(BeanDeserializer src) {
        super((BeanDeserializerBase)src, src._ignoreAllUnknown);
        this._fieldMatcher = src._fieldMatcher;
        this._fieldsByIndex = src._fieldsByIndex;
    }

    protected BeanDeserializer(BeanDeserializer src, boolean ignoreAllUnknown) {
        super((BeanDeserializerBase)src, ignoreAllUnknown);
        this._fieldMatcher = src._fieldMatcher;
        this._fieldsByIndex = src._fieldsByIndex;
    }

    protected BeanDeserializer(BeanDeserializer src, UnwrappedPropertyHandler unwrapHandler, BeanPropertyMap renamedProperties, boolean ignoreAllUnknown) {
        super(src, unwrapHandler, renamedProperties, ignoreAllUnknown);
        this._fieldMatcher = this._beanProperties.getFieldMatcher();
        this._fieldsByIndex = this._beanProperties.getFieldMatcherProperties();
    }

    public BeanDeserializer(BeanDeserializer src, ObjectIdReader oir) {
        super((BeanDeserializerBase)src, oir);
        this._fieldMatcher = src._fieldMatcher;
        this._fieldsByIndex = src._fieldsByIndex;
    }

    public BeanDeserializer(BeanDeserializer src, Set<String> ignorableProps) {
        super((BeanDeserializerBase)src, ignorableProps);
        this._fieldMatcher = src._fieldMatcher;
        this._fieldsByIndex = src._fieldsByIndex;
    }

    public BeanDeserializer(BeanDeserializer src, BeanPropertyMap props) {
        super((BeanDeserializerBase)src, props);
        this._fieldMatcher = this._beanProperties.getFieldMatcher();
        this._fieldsByIndex = this._beanProperties.getFieldMatcherProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer transformer) {
        if (this.getClass() != BeanDeserializer.class) {
            return this;
        }
        if (this._currentlyTransforming == transformer) {
            return this;
        }
        this._currentlyTransforming = transformer;
        try {
            UnwrappedPropertyHandler uwHandler = this._unwrappedPropertyHandler;
            if (uwHandler != null) {
                uwHandler = uwHandler.renameAll(ctxt, transformer);
            }
            BeanDeserializer beanDeserializer = new BeanDeserializer(this, uwHandler, this._beanProperties.renameAll(ctxt, transformer), true);
            return beanDeserializer;
        }
        finally {
            this._currentlyTransforming = null;
        }
    }

    @Override
    public BeanDeserializer withObjectIdReader(ObjectIdReader oir) {
        return new BeanDeserializer(this, oir);
    }

    @Override
    public BeanDeserializer withIgnorableProperties(Set<String> ignorableProps) {
        return new BeanDeserializer(this, ignorableProps);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BeanDeserializer(this, props);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return new BeanAsArrayDeserializer((BeanDeserializerBase)this, this._beanProperties.getPrimaryProperties());
    }

    @Override
    protected void initFieldMatcher(DeserializationContext ctxt) {
        this._beanProperties.initMatcher(ctxt.getParserFactory());
        this._fieldMatcher = this._beanProperties.getFieldMatcher();
        this._fieldsByIndex = this._beanProperties.getFieldMatcherProperties();
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartObjectToken()) {
            if (this._vanillaProcessing) {
                return this._vanillaDeserialize(p, ctxt);
            }
            p.nextToken();
            if (this._objectIdReader != null) {
                return this.deserializeWithObjectId(p, ctxt);
            }
            return this.deserializeFromObject(p, ctxt);
        }
        return this._deserializeOther(p, ctxt, p.currentToken());
    }

    protected final Object _deserializeOther(JsonParser p, DeserializationContext ctxt, JsonToken t) throws IOException {
        if (t != null) {
            switch (t) {
                case VALUE_STRING: {
                    return this.deserializeFromString(p, ctxt);
                }
                case VALUE_NUMBER_INT: {
                    return this.deserializeFromNumber(p, ctxt);
                }
                case VALUE_NUMBER_FLOAT: {
                    return this.deserializeFromDouble(p, ctxt);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    return this.deserializeFromEmbedded(p, ctxt);
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return this.deserializeFromBoolean(p, ctxt);
                }
                case VALUE_NULL: {
                    return this.deserializeFromNull(p, ctxt);
                }
                case START_ARRAY: {
                    return this.deserializeFromArray(p, ctxt);
                }
                case FIELD_NAME: 
                case END_OBJECT: {
                    if (this._vanillaProcessing) {
                        return this._vanillaDeserialize(p, ctxt, t);
                    }
                    if (this._objectIdReader != null) {
                        return this.deserializeWithObjectId(p, ctxt);
                    }
                    return this.deserializeFromObject(p, ctxt);
                }
            }
        }
        return ctxt.handleUnexpectedToken(this.handledType(), p);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        Class<?> view;
        String propName;
        p.setCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(p, ctxt, bean);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p, ctxt, bean);
        }
        if (p.isExpectedStartObjectToken()) {
            propName = p.nextFieldName();
            if (propName == null) {
                return bean;
            }
        } else if (p.hasTokenId(5)) {
            propName = p.currentName();
        } else {
            return bean;
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, bean, view);
        }
        int ix = this._fieldMatcher.matchName(propName);
        while (ix >= 0) {
            p.nextToken();
            SettableBeanProperty prop = this._fieldsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        if (ix != -1) {
            if (ix == -2) {
                return this._vanillaDeserializeWithUnknown(p, ctxt, bean, p.currentName());
            }
            return this._handleUnexpectedWithin(p, ctxt, bean);
        }
        return bean;
    }

    private final Object _vanillaDeserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean);
        int ix = p.nextFieldName(this._fieldMatcher);
        while (ix >= 0) {
            p.nextToken();
            SettableBeanProperty prop = this._fieldsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextFieldName(this._fieldMatcher);
            if (ix < 0) break;
            p.nextToken();
            prop = this._fieldsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextFieldName(this._fieldMatcher);
            if (ix < 0) break;
            p.nextToken();
            prop = this._fieldsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextFieldName(this._fieldMatcher);
            if (ix < 0) break;
            p.nextToken();
            prop = this._fieldsByIndex[ix];
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        if (ix != -1) {
            if (ix == -2) {
                return this._vanillaDeserializeWithUnknown(p, ctxt, bean, p.currentName());
            }
            return this._handleUnexpectedWithin(p, ctxt, bean);
        }
        return bean;
    }

    private final Object _vanillaDeserialize(JsonParser p, DeserializationContext ctxt, JsonToken t) throws IOException {
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean);
        if (t != JsonToken.FIELD_NAME) {
            return bean;
        }
        int ix = p.currentFieldName(this._fieldMatcher);
        while (ix >= 0) {
            SettableBeanProperty prop = this._fieldsByIndex[ix];
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                throw this.wrapAndThrow(e, bean, p.currentName(), ctxt);
            }
            ix = p.nextFieldName(this._fieldMatcher);
            if (ix < 0) break;
            prop = this._fieldsByIndex[ix];
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
            }
            catch (Exception e) {
                throw this.wrapAndThrow(e, bean, p.currentName(), ctxt);
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        if (ix != -1) {
            if (ix == -2) {
                return this._vanillaDeserializeWithUnknown(p, ctxt, bean, p.currentName());
            }
            return this._handleUnexpectedWithin(p, ctxt, bean);
        }
        return bean;
    }

    private final Object _vanillaDeserializeWithUnknown(JsonParser p, DeserializationContext ctxt, Object bean, String propName) throws IOException {
        p.nextToken();
        this.handleUnknownVanilla(p, ctxt, bean, propName);
        while (true) {
            int ix;
            if ((ix = p.nextFieldName(this._fieldMatcher)) >= 0) {
                p.nextToken();
                try {
                    this._fieldsByIndex[ix].deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, p.currentName(), ctxt);
                }
                continue;
            }
            if (ix == -1) {
                return bean;
            }
            if (ix != -2) {
                return this._handleUnexpectedWithin(p, ctxt, bean);
            }
            p.nextToken();
            this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
        }
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        Class<?> view;
        Object id;
        if (this._objectIdReader != null && this._objectIdReader.maySerializeAsObject() && p.hasTokenId(5) && this._objectIdReader.isValidReferencePropertyName(p.currentName(), p)) {
            return this.deserializeFromObjectId(p, ctxt);
        }
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            if (this._injectables != null) {
                this.injectValues(ctxt, bean);
            }
            return bean;
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean);
        if (p.canReadObjectId() && (id = p.getObjectId()) != null) {
            this._handleTypedObjectId(p, ctxt, bean, id);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (!p.hasTokenId(5)) {
            return bean;
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, bean, view);
        }
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                try {
                    this._fieldsByIndex[ix].deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, bean, p.currentName(), ctxt);
                }
            } else {
                if (ix == -1) {
                    return bean;
                }
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
    }

    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object bean;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        TokenBuffer unknown = null;
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        JsonToken t = p.currentToken();
        ArrayList<BeanReferring> referrings = null;
        while (t == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            p.nextToken();
            if (!buffer.readIdProperty(propName)) {
                SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                if (creatorProp != null) {
                    if (activeView != null && !creatorProp.visibleInView(activeView)) {
                        p.skipChildren();
                    } else {
                        Object value = this._deserializeWithErrorWrapping(p, ctxt, creatorProp);
                        if (buffer.assignParameter(creatorProp, value)) {
                            Object bean2;
                            p.nextToken();
                            try {
                                bean2 = creator.build(ctxt, buffer);
                            }
                            catch (Exception e) {
                                bean2 = this.wrapInstantiationProblem(e, ctxt);
                            }
                            if (bean2 == null) {
                                return ctxt.handleInstantiationProblem(this.handledType(), null, this._creatorReturnedNullException());
                            }
                            p.setCurrentValue(bean2);
                            if (bean2.getClass() != this._beanType.getRawClass()) {
                                return this.handlePolymorphic(p, ctxt, bean2, unknown);
                            }
                            if (unknown != null) {
                                bean2 = this.handleUnknownProperties(ctxt, bean2, unknown);
                            }
                            return this.deserialize(p, ctxt, bean2);
                        }
                    }
                } else {
                    int ix = this._fieldMatcher.matchName(propName);
                    if (ix >= 0) {
                        SettableBeanProperty prop = this._fieldsByIndex[ix];
                        try {
                            buffer.bufferProperty(prop, this._deserializeWithErrorWrapping(p, ctxt, prop));
                        }
                        catch (UnresolvedForwardReference reference) {
                            BeanReferring referring = this.handleUnresolvedReference(ctxt, prop, buffer, reference);
                            if (referrings == null) {
                                referrings = new ArrayList<BeanReferring>();
                            }
                            referrings.add(referring);
                        }
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                        this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                    } else if (this._anySetter != null) {
                        try {
                            buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                        }
                    } else {
                        if (unknown == null) {
                            unknown = TokenBuffer.forInputBuffering(p, ctxt);
                        }
                        unknown.writeFieldName(propName);
                        unknown.copyCurrentStructure(p);
                    }
                }
            }
            t = p.nextToken();
        }
        try {
            bean = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            this.wrapInstantiationProblem(e, ctxt);
            bean = null;
        }
        if (referrings != null) {
            for (BeanReferring referring : referrings) {
                referring.setBean(bean);
            }
        }
        if (unknown != null) {
            if (bean.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, bean, unknown);
            }
            return this.handleUnknownProperties(ctxt, bean, unknown);
        }
        return bean;
    }

    private BeanReferring handleUnresolvedReference(DeserializationContext ctxt, SettableBeanProperty prop, PropertyValueBuffer buffer, UnresolvedForwardReference reference) throws JsonMappingException {
        BeanReferring referring = new BeanReferring(ctxt, reference, prop.getType(), buffer, prop);
        reference.getRoid().appendReferring(referring);
        return referring;
    }

    protected final Object _deserializeWithErrorWrapping(JsonParser p, DeserializationContext ctxt, SettableBeanProperty prop) throws IOException {
        try {
            return prop.deserialize(p, ctxt);
        }
        catch (Exception e) {
            throw this.wrapAndThrow(e, this._beanType.getRawClass(), prop.getName(), ctxt);
        }
    }

    protected Object deserializeFromNull(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.canSynthesizeNulls()) {
            TokenBuffer tb = TokenBuffer.forGeneration();
            tb.writeEndObject();
            JsonParser p2 = tb.asParser(ctxt, p);
            p2.nextToken();
            Object ob = this._vanillaProcessing ? this._vanillaDeserialize(p2, ctxt, JsonToken.END_OBJECT) : this.deserializeFromObject(p2, ctxt);
            p2.close();
            tb.close();
            return ob;
        }
        return ctxt.handleUnexpectedToken(this.handledType(), p);
    }

    protected final Object deserializeWithView(JsonParser p, DeserializationContext ctxt, Object bean, Class<?> activeView) throws IOException {
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                if (!prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, p.currentName(), ctxt);
                    }
                }
            } else if (ix != -1) {
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            } else {
                return bean;
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(p, ctxt);
        }
        TokenBuffer tokens = TokenBuffer.forInputBuffering(p, ctxt);
        tokens.writeStartObject();
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix == -3) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                p.nextToken();
                if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else if (this._anySetter == null) {
                    tokens.writeFieldName(propName);
                    tokens.copyCurrentStructure(p);
                } else {
                    TokenBuffer b2 = TokenBuffer.asCopyOfValue(p);
                    tokens.writeFieldName(propName);
                    tokens.append(b2);
                    try {
                        this._anySetter.deserializeAndSet(b2.asParserOnFirstToken(), ctxt, bean, propName);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean, tokens);
        return bean;
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        TokenBuffer tokens = TokenBuffer.forInputBuffering(p, ctxt);
        tokens.writeStartObject();
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix == -3) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                p.nextToken();
                if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else if (this._anySetter == null) {
                    tokens.writeFieldName(propName);
                    tokens.copyCurrentStructure(p);
                } else {
                    TokenBuffer b2 = TokenBuffer.asCopyOfValue(p);
                    tokens.writeFieldName(propName);
                    tokens.append(b2);
                    try {
                        this._anySetter.deserializeAndSet(b2.asParserOnFirstToken(), ctxt, bean, propName);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean, tokens);
        return bean;
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object bean;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        TokenBuffer tokens = TokenBuffer.forInputBuffering(p, ctxt);
        tokens.writeStartObject();
        JsonToken t = p.currentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (creatorProp != null) {
                if (buffer.assignParameter(creatorProp, this._deserializeWithErrorWrapping(p, ctxt, creatorProp))) {
                    Object bean2;
                    t = p.nextToken();
                    try {
                        bean2 = creator.build(ctxt, buffer);
                    }
                    catch (Exception e) {
                        bean2 = this.wrapInstantiationProblem(e, ctxt);
                    }
                    p.setCurrentValue(bean2);
                    while (t == JsonToken.FIELD_NAME) {
                        tokens.copyCurrentStructure(p);
                        t = p.nextToken();
                    }
                    if (t != JsonToken.END_OBJECT) {
                        ctxt.reportWrongTokenException(this, JsonToken.END_OBJECT, "Attempted to unwrap '%s' value", this.handledType().getName());
                    }
                    tokens.writeEndObject();
                    if (bean2.getClass() != this._beanType.getRawClass()) {
                        ctxt.reportInputMismatch(creatorProp, "Cannot create polymorphic instances with unwrapped values", new Object[0]);
                        return null;
                    }
                    return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean2, tokens);
                }
            } else if (!buffer.readIdProperty(propName)) {
                int ix = this._fieldMatcher.matchName(propName);
                if (ix >= 0) {
                    SettableBeanProperty prop = this._fieldsByIndex[ix];
                    buffer.bufferProperty(prop, this._deserializeWithErrorWrapping(p, ctxt, prop));
                } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                } else if (this._anySetter == null) {
                    tokens.writeFieldName(propName);
                    tokens.copyCurrentStructure(p);
                } else {
                    TokenBuffer b2 = TokenBuffer.asCopyOfValue(p);
                    tokens.writeFieldName(propName);
                    tokens.append(b2);
                    try {
                        buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(b2.asParserOnFirstToken(), ctxt));
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                    }
                }
            }
            t = p.nextToken();
        }
        try {
            bean = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            this.wrapInstantiationProblem(e, ctxt);
            return null;
        }
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean, tokens);
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(p, ctxt);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        return this.deserializeWithExternalTypeId(p, ctxt, this._valueInstantiator.createUsingDefault(ctxt));
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                JsonToken t = p.nextToken();
                if (t.isScalarValue()) {
                    ext.handleTypePropertyValue(p, ctxt, p.currentName(), bean);
                }
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                p.nextToken();
                if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else if (!ext.handlePropertyValue(p, ctxt, propName, bean)) {
                    if (this._anySetter != null) {
                        try {
                            this._anySetter.deserializeAndSet(p, ctxt, bean, propName);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, bean, propName, ctxt);
                        }
                    } else {
                        this.handleUnknownProperty(p, ctxt, bean, p.currentName());
                    }
                }
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        return ext.complete(p, ctxt, bean);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws IOException {
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        TokenBuffer tokens = TokenBuffer.forInputBuffering(p, ctxt);
        tokens.writeStartObject();
        JsonToken t = p.currentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (creatorProp != null) {
                if (!ext.handlePropertyValue(p, ctxt, propName, null) && buffer.assignParameter(creatorProp, this._deserializeWithErrorWrapping(p, ctxt, creatorProp))) {
                    Object bean;
                    t = p.nextToken();
                    try {
                        bean = creator.build(ctxt, buffer);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                    }
                    while (t == JsonToken.FIELD_NAME) {
                        p.nextToken();
                        tokens.copyCurrentStructure(p);
                        t = p.nextToken();
                    }
                    if (bean.getClass() != this._beanType.getRawClass()) {
                        return ctxt.reportBadDefinition(this._beanType, String.format("Cannot create polymorphic instances with external type ids (%s -> %s)", this._beanType, bean.getClass()));
                    }
                    return ext.complete(p, ctxt, bean);
                }
            } else if (!buffer.readIdProperty(propName)) {
                int ix = this._fieldMatcher.matchName(propName);
                if (ix >= 0) {
                    SettableBeanProperty prop = this._fieldsByIndex[ix];
                    buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                } else if (!ext.handlePropertyValue(p, ctxt, propName, null)) {
                    if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                        this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                    } else if (this._anySetter != null) {
                        buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                    }
                }
            }
            t = p.nextToken();
        }
        tokens.writeEndObject();
        try {
            return ext.complete(p, ctxt, buffer, creator);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(e, ctxt);
        }
    }

    protected Exception _creatorReturnedNullException() {
        if (this._nullFromCreator == null) {
            this._nullFromCreator = new NullPointerException("JSON Creator returned null");
        }
        return this._nullFromCreator;
    }

    protected Object _handleUnexpectedWithin(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        return ctxt.handleUnexpectedToken(this.handledType(), p);
    }

    static class BeanReferring
    extends ReadableObjectId.Referring {
        private final DeserializationContext _context;
        private final SettableBeanProperty _prop;
        private Object _bean;

        BeanReferring(DeserializationContext ctxt, UnresolvedForwardReference ref, JavaType valueType, PropertyValueBuffer buffer, SettableBeanProperty prop) {
            super(ref, valueType);
            this._context = ctxt;
            this._prop = prop;
        }

        public void setBean(Object bean) {
            this._bean = bean;
        }

        @Override
        public void handleResolvedForwardReference(Object id, Object value) throws IOException {
            if (this._bean == null) {
                this._context.reportInputMismatch(this._prop, "Cannot resolve ObjectId forward reference using property '%s' (of type %s): Bean not yet resolved", this._prop.getName(), this._prop.getDeclaringClass().getName());
            }
            this._prop.set(this._bean, value);
        }
    }
}

