/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.sym.FieldNameMatcher;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanAsArrayBuilderDeserializer;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class BuilderBasedDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _buildMethod;
    protected final JavaType _targetType;
    protected FieldNameMatcher _fieldMatcher;
    protected SettableBeanProperty[] _fieldsByIndex;
    private volatile transient NameTransformer _currentlyTransforming;

    public BuilderBasedDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, JavaType targetType, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, Set<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        super(builder, beanDesc, properties, backRefs, ignorableProps, ignoreAllUnknown, hasViews);
        this._targetType = targetType;
        this._buildMethod = builder.getBuildMethod();
        if (this._objectIdReader != null) {
            throw new IllegalArgumentException("Cannot use Object Id with Builder-based deserialization (type " + beanDesc.getType() + ")");
        }
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src) {
        this(src, src._ignoreAllUnknown);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src, boolean ignoreAllUnknown) {
        super((BeanDeserializerBase)src, ignoreAllUnknown);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._fieldMatcher = src._fieldMatcher;
        this._fieldsByIndex = src._fieldsByIndex;
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src, UnwrappedPropertyHandler unwrapHandler, BeanPropertyMap renamedProperties, boolean ignoreAllUnknown) {
        super(src, unwrapHandler, renamedProperties, ignoreAllUnknown);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._fieldMatcher = this._beanProperties.getFieldMatcher();
        this._fieldsByIndex = this._beanProperties.getFieldMatcherProperties();
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, ObjectIdReader oir) {
        super((BeanDeserializerBase)src, oir);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._fieldMatcher = src._fieldMatcher;
        this._fieldsByIndex = src._fieldsByIndex;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, Set<String> ignorableProps) {
        super((BeanDeserializerBase)src, ignorableProps);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._fieldMatcher = src._fieldMatcher;
        this._fieldsByIndex = src._fieldsByIndex;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, BeanPropertyMap props) {
        super((BeanDeserializerBase)src, props);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._fieldMatcher = this._beanProperties.getFieldMatcher();
        this._fieldsByIndex = this._beanProperties.getFieldMatcherProperties();
    }

    @Override
    protected void initFieldMatcher(DeserializationContext ctxt) {
        this._beanProperties.initMatcher(ctxt.getParserFactory());
        this._fieldMatcher = this._beanProperties.getFieldMatcher();
        this._fieldsByIndex = this._beanProperties.getFieldMatcherProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer transformer) {
        if (this._currentlyTransforming == transformer) {
            return this;
        }
        this._currentlyTransforming = transformer;
        try {
            UnwrappedPropertyHandler uwHandler = this._unwrappedPropertyHandler;
            if (uwHandler != null) {
                uwHandler = uwHandler.renameAll(ctxt, transformer);
            }
            BeanPropertyMap props = this._beanProperties.renameAll(ctxt, transformer);
            BuilderBasedDeserializer builderBasedDeserializer = new BuilderBasedDeserializer(this, uwHandler, props, true);
            return builderBasedDeserializer;
        }
        finally {
            this._currentlyTransforming = null;
        }
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader oir) {
        return new BuilderBasedDeserializer(this, oir);
    }

    @Override
    public BeanDeserializerBase withIgnorableProperties(Set<String> ignorableProps) {
        return new BuilderBasedDeserializer(this, ignorableProps);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BuilderBasedDeserializer(this, props);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return new BeanAsArrayBuilderDeserializer((BeanDeserializerBase)this, this._targetType, this._beanProperties.getPrimaryProperties(), this._buildMethod);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    protected Object finishBuild(DeserializationContext ctxt, Object builder) throws IOException {
        if (null == this._buildMethod) {
            return builder;
        }
        try {
            return this._buildMethod.getMember().invoke(builder, (Object[])null);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(e, ctxt);
        }
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartObjectToken()) {
            if (this._vanillaProcessing) {
                return this.finishBuild(ctxt, this._vanillaDeserialize(p, ctxt));
            }
            p.nextToken();
            Object builder = this.deserializeFromObject(p, ctxt);
            return this.finishBuild(ctxt, builder);
        }
        switch (p.currentTokenId()) {
            case 6: {
                return this.finishBuild(ctxt, this.deserializeFromString(p, ctxt));
            }
            case 7: {
                return this.finishBuild(ctxt, this.deserializeFromNumber(p, ctxt));
            }
            case 8: {
                return this.finishBuild(ctxt, this.deserializeFromDouble(p, ctxt));
            }
            case 12: {
                return p.getEmbeddedObject();
            }
            case 9: 
            case 10: {
                return this.finishBuild(ctxt, this.deserializeFromBoolean(p, ctxt));
            }
            case 3: {
                return this.finishBuild(ctxt, this.deserializeFromArray(p, ctxt));
            }
            case 2: 
            case 5: {
                return this.finishBuild(ctxt, this.deserializeFromObject(p, ctxt));
            }
        }
        return ctxt.handleUnexpectedToken(this.handledType(), p);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object value) throws IOException {
        Class<?> instRawType;
        JavaType valueType = this._targetType;
        Class<?> builderRawType = this.handledType();
        if (builderRawType.isAssignableFrom(instRawType = value.getClass())) {
            return ctxt.reportBadDefinition(valueType, String.format("Deserialization of %s by passing existing Builder (%s) instance not supported", valueType, builderRawType.getName()));
        }
        return ctxt.reportBadDefinition(valueType, String.format("Deserialization of %s by passing existing instance (of %s) not supported", valueType, instRawType.getName()));
    }

    private final Object _vanillaDeserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object builder = this._valueInstantiator.createUsingDefault(ctxt);
        while (true) {
            int ix;
            if ((ix = p.nextFieldName(this._fieldMatcher)) >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                try {
                    builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, builder, prop.getName(), ctxt);
                }
            }
            if (ix == -1) {
                return builder;
            }
            if (ix != -2) break;
            p.nextToken();
            this.handleUnknownVanilla(p, ctxt, builder, p.currentName());
        }
        return this._handleUnexpectedWithin(p, ctxt, builder);
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        Class<?> view;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            return this.deserializeFromObjectUsingNonDefault(p, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, bean, view);
        }
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                try {
                    bean = this._fieldsByIndex[ix].deserializeSetAndReturn(p, ctxt, bean);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, bean, p.currentName(), ctxt);
                }
            } else {
                if (ix == -1) {
                    return bean;
                }
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
    }

    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object builder;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        TokenBuffer unknown = null;
        JsonToken t = p.currentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (creatorProp != null) {
                if (activeView != null && !creatorProp.visibleInView(activeView)) {
                    p.skipChildren();
                } else if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p, ctxt))) {
                    Object builder2;
                    p.nextToken();
                    try {
                        builder2 = creator.build(ctxt, buffer);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                    }
                    if (builder2.getClass() != this._beanType.getRawClass()) {
                        return this.handlePolymorphic(p, ctxt, builder2, unknown);
                    }
                    if (unknown != null) {
                        builder2 = this.handleUnknownProperties(ctxt, builder2, unknown);
                    }
                    return this._deserialize(p, ctxt, builder2);
                }
            } else if (!buffer.readIdProperty(propName)) {
                int ix = this._fieldMatcher.matchName(propName);
                if (ix >= 0) {
                    SettableBeanProperty prop = this._fieldsByIndex[ix];
                    buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                } else if (this._anySetter != null) {
                    buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                } else {
                    if (unknown == null) {
                        unknown = TokenBuffer.forInputBuffering(p, ctxt);
                    }
                    unknown.writeFieldName(propName);
                    unknown.copyCurrentStructure(p);
                }
            }
            t = p.nextToken();
        }
        try {
            builder = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            builder = this.wrapInstantiationProblem(e, ctxt);
        }
        if (unknown != null) {
            if (builder.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, builder, unknown);
            }
            return this.handleUnknownProperties(ctxt, builder, unknown);
        }
        return builder;
    }

    protected final Object _deserialize(JsonParser p, DeserializationContext ctxt, Object builder) throws IOException {
        int ix;
        Class<?> view;
        if (this._injectables != null) {
            this.injectValues(ctxt, builder);
        }
        if (this._unwrappedPropertyHandler != null) {
            if (p.hasToken(JsonToken.START_OBJECT)) {
                p.nextToken();
            }
            TokenBuffer tokens = TokenBuffer.forInputBuffering(p, ctxt);
            tokens.writeStartObject();
            return this.deserializeWithUnwrapped(p, ctxt, builder, tokens);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p, ctxt, builder);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, builder, view);
        }
        int n = ix = p.isExpectedStartObjectToken() ? p.nextFieldName(this._fieldMatcher) : p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                try {
                    builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, builder, prop.getName(), ctxt);
                }
            } else {
                if (ix == -1) {
                    return builder;
                }
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, builder);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, this.handledType(), p.currentName());
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
    }

    protected final Object deserializeWithView(JsonParser p, DeserializationContext ctxt, Object bean, Class<?> activeView) throws IOException {
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                if (!prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else if (ix != -1) {
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            } else {
                return bean;
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(p, ctxt);
        }
        TokenBuffer tokens = TokenBuffer.forInputBuffering(p, ctxt);
        tokens.writeStartObject();
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix == -3) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                p.nextToken();
                if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else {
                    tokens.writeFieldName(propName);
                    tokens.copyCurrentStructure(p);
                    if (this._anySetter != null) {
                        try {
                            this._anySetter.deserializeAndSet(p, ctxt, bean, propName);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, bean, propName, ctxt);
                        }
                    }
                }
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        tokens.writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean, tokens);
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt, Object builder, TokenBuffer tokens) throws IOException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, builder, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix == -3) {
                    return this._handleUnexpectedWithin(p, ctxt, builder);
                }
                String propName = p.currentName();
                p.nextToken();
                if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, builder, propName);
                } else {
                    tokens.writeFieldName(propName);
                    tokens.copyCurrentStructure(p);
                    if (this._anySetter != null) {
                        this._anySetter.deserializeAndSet(p, ctxt, builder, propName);
                    }
                }
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        tokens.writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, builder, tokens);
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws IOException {
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        TokenBuffer tokens = TokenBuffer.forInputBuffering(p, ctxt);
        tokens.writeStartObject();
        JsonToken t = p.currentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (creatorProp != null) {
                if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p, ctxt))) {
                    t = p.nextToken();
                    Object builder = null;
                    try {
                        builder = creator.build(ctxt, buffer);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                    }
                    if (builder.getClass() != this._beanType.getRawClass()) {
                        return this.handlePolymorphic(p, ctxt, builder, tokens);
                    }
                    return this.deserializeWithUnwrapped(p, ctxt, builder, tokens);
                }
            } else if (!buffer.readIdProperty(propName)) {
                int ix = this._fieldMatcher.matchName(propName);
                if (ix >= 0) {
                    SettableBeanProperty prop = this._fieldsByIndex[ix];
                    buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                } else {
                    tokens.writeFieldName(propName);
                    tokens.copyCurrentStructure(p);
                    if (this._anySetter != null) {
                        buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                    }
                }
            }
            t = p.nextToken();
        }
        tokens.writeEndObject();
        Object builder = null;
        try {
            builder = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(e, ctxt);
        }
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, builder, tokens);
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(p, ctxt);
        }
        return this.deserializeWithExternalTypeId(p, ctxt, this._valueInstantiator.createUsingDefault(ctxt));
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        int ix = p.currentFieldName(this._fieldMatcher);
        while (true) {
            if (ix >= 0) {
                SettableBeanProperty prop = this._fieldsByIndex[ix];
                JsonToken t = p.nextToken();
                if (t.isScalarValue()) {
                    ext.handleTypePropertyValue(p, ctxt, p.currentName(), bean);
                }
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else if (!ext.handlePropertyValue(p, ctxt, propName, bean)) {
                    if (this._anySetter != null) {
                        try {
                            this._anySetter.deserializeAndSet(p, ctxt, bean, propName);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, bean, propName, ctxt);
                        }
                    } else {
                        this.handleUnknownProperty(p, ctxt, bean, propName);
                    }
                }
            }
            ix = p.nextFieldName(this._fieldMatcher);
        }
        return ext.complete(p, ctxt, bean);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws IOException {
        JavaType t = this._targetType;
        return ctxt.reportBadDefinition(t, String.format("Deserialization (of %s) with Builder, External type id, @JsonCreator not yet implemented", t));
    }

    protected Object _handleUnexpectedWithin(JsonParser p, DeserializationContext ctxt, Object beanOrBuilder) throws IOException {
        return ctxt.handleUnexpectedToken(this.handledType(), p);
    }
}

