/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DefaultTyping;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import java.io.Serializable;
import java.util.Collection;

public class DefaultTypeResolverBuilder
extends StdTypeResolverBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final PolymorphicTypeValidator _subtypeValidator;
    protected final DefaultTyping _appliesFor;

    public DefaultTypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, JsonTypeInfo.As includeAs) {
        this._subtypeValidator = subtypeValidator;
        this._appliesFor = t;
        this._idType = JsonTypeInfo.Id.CLASS;
        this._includeAs = includeAs;
        this._typeProperty = this._idType.getDefaultPropertyName();
    }

    public DefaultTypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, String propertyName) {
        this._subtypeValidator = subtypeValidator;
        this._appliesFor = t;
        this._idType = JsonTypeInfo.Id.CLASS;
        this._includeAs = JsonTypeInfo.As.PROPERTY;
        this._typeProperty = propertyName;
    }

    public DefaultTypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, JsonTypeInfo.As includeAs, JsonTypeInfo.Id idType, String propertyName) {
        this._subtypeValidator = subtypeValidator;
        this._appliesFor = t;
        this._idType = idType;
        this._includeAs = includeAs;
        if (propertyName == null) {
            propertyName = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = propertyName;
    }

    @Override
    public PolymorphicTypeValidator subTypeValidator(DatabindContext ctxt) {
        return this._subtypeValidator;
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationContext ctxt, JavaType baseType, Collection<NamedType> subtypes) throws JsonMappingException {
        return this.useForType(baseType) ? super.buildTypeDeserializer(ctxt, baseType, subtypes) : null;
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializerProvider ctxt, JavaType baseType, Collection<NamedType> subtypes) throws JsonMappingException {
        return this.useForType(baseType) ? super.buildTypeSerializer(ctxt, baseType, subtypes) : null;
    }

    public DefaultTypeResolverBuilder typeIdVisibility(boolean isVisible) {
        this._typeIdVisible = isVisible;
        return this;
    }

    public boolean useForType(JavaType t) {
        if (t.isPrimitive()) {
            return false;
        }
        switch (this._appliesFor) {
            case NON_CONCRETE_AND_ARRAYS: {
                while (t.isArrayType()) {
                    t = t.getContentType();
                }
            }
            case OBJECT_AND_NON_CONCRETE: {
                while (t.isReferenceType()) {
                    t = t.getReferencedType();
                }
                return t.isJavaLangObject() || !t.isConcrete() && !TreeNode.class.isAssignableFrom(t.getRawClass());
            }
            case NON_FINAL: {
                while (t.isArrayType()) {
                    t = t.getContentType();
                }
                while (t.isReferenceType()) {
                    t = t.getReferencedType();
                }
                return !t.isFinal() && !TreeNode.class.isAssignableFrom(t.getRawClass());
            }
        }
        return t.isJavaLangObject();
    }
}

