/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectReadContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NodeSerialization;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import java.io.Serializable;

public abstract class BaseJsonNode
extends JsonNode
implements Serializable {
    private static final long serialVersionUID = 1L;

    Object writeReplace() {
        return NodeSerialization.from(this);
    }

    protected BaseJsonNode() {
    }

    @Override
    public boolean isMissingNode() {
        return false;
    }

    public boolean isEmbeddedValue() {
        return false;
    }

    @Override
    public final JsonNode findPath(String fieldName) {
        JsonNode value = this.findValue(fieldName);
        if (value == null) {
            return MissingNode.getInstance();
        }
        return value;
    }

    public abstract int hashCode();

    public JsonParser traverse(ObjectReadContext readCtxt) {
        return new TreeTraversingParser(this, readCtxt);
    }

    public abstract JsonToken asToken();

    public JsonParser.NumberType numberType() {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializerProvider var2) throws IOException;

    @Override
    public abstract void serializeWithType(JsonGenerator var1, SerializerProvider var2, TypeSerializer var3) throws IOException;

    @Override
    public String toString() {
        try {
            return JsonMapper.shared().writeValueAsString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toPrettyString() {
        try {
            return JsonMapper.shared().writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

