/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.ext.jdk8.DoubleStreamSerializer;
import com.fasterxml.jackson.databind.ext.jdk8.IntStreamSerializer;
import com.fasterxml.jackson.databind.ext.jdk8.Jdk8OptionalSerializer;
import com.fasterxml.jackson.databind.ext.jdk8.Jdk8StreamSerializer;
import com.fasterxml.jackson.databind.ext.jdk8.LongStreamSerializer;
import com.fasterxml.jackson.databind.ext.jdk8.OptionalDoubleSerializer;
import com.fasterxml.jackson.databind.ext.jdk8.OptionalIntSerializer;
import com.fasterxml.jackson.databind.ext.jdk8.OptionalLongSerializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.IndexedListSerializer;
import com.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import com.fasterxml.jackson.databind.ser.impl.IteratorSerializer;
import com.fasterxml.jackson.databind.ser.impl.MapEntrySerializer;
import com.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.AtomicReferenceSerializer;
import com.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import com.fasterxml.jackson.databind.ser.std.ByteBufferSerializer;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSetSerializer;
import com.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import com.fasterxml.jackson.databind.ser.std.InetSocketAddressSerializer;
import com.fasterxml.jackson.databind.ser.std.IterableSerializer;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import com.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import com.fasterxml.jackson.databind.ser.std.ReferenceTypeSerializer;
import com.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.StringLikeSerializer;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    protected static final HashMap<String, JsonSerializer<?>> _concrete;
    protected final SerializerFactoryConfig _factoryConfig;

    protected BasicSerializerFactory(SerializerFactoryConfig config) {
        this._factoryConfig = config == null ? new SerializerFactoryConfig() : config;
    }

    protected abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    @Override
    public final SerializerFactory withAdditionalSerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(additional));
    }

    @Override
    public final SerializerFactory withAdditionalKeySerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(additional));
    }

    @Override
    public final SerializerFactory withSerializerModifier(BeanSerializerModifier modifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(modifier));
    }

    @Override
    public final SerializerFactory withNullValueSerializer(JsonSerializer<?> nvs) {
        return this.withConfig(this._factoryConfig.withNullValueSerializer(nvs));
    }

    @Override
    public final SerializerFactory withNullKeySerializer(JsonSerializer<?> nks) {
        return this.withConfig(this._factoryConfig.withNullKeySerializer(nks));
    }

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializerProvider ctxt, JavaType keyType, JsonSerializer<Object> defaultImpl) throws JsonMappingException {
        BeanDescription beanDesc = ctxt.introspectClassAnnotations(keyType);
        SerializationConfig config = ctxt.getConfig();
        JsonSerializer ser = null;
        if (this._factoryConfig.hasKeySerializers()) {
            Serializers serializers;
            Iterator<Object> iterator = this._factoryConfig.keySerializers().iterator();
            while (iterator.hasNext() && (ser = (serializers = iterator.next()).findSerializer(config, keyType, beanDesc, null)) == null) {
            }
        }
        if (ser == null && (ser = StdKeySerializers.getStdKeySerializer(config, keyType.getRawClass(), false)) == null) {
            beanDesc = ctxt.introspect(keyType);
            AnnotatedMember am = beanDesc.findJsonValueAccessor();
            if (am != null) {
                Class<?> rawType = am.getRawType();
                JsonSerializer<Object> delegate = StdKeySerializers.getStdKeySerializer(config, rawType, true);
                if (config.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(am.getMember(), config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                ser = new JsonValueSerializer(keyType, am.getType(), false, null, delegate, am);
            } else {
                ser = defaultImpl;
                if (ser == null) {
                    ser = StdKeySerializers.getFallbackKeySerializer(config, keyType.getRawClass());
                }
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyKeySerializer(config, keyType, beanDesc, ser);
            }
        }
        return ser;
    }

    @Override
    public JsonSerializer<Object> getDefaultNullKeySerializer() {
        return this._factoryConfig.getNullKeySerializer();
    }

    @Override
    public JsonSerializer<Object> getDefaultNullValueSerializer() {
        return this._factoryConfig.getNullValueSerializer();
    }

    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    public TypeSerializer findPropertyContentTypeSerializer(SerializerProvider ctxt, JavaType containerType, AnnotatedMember accessor) throws JsonMappingException {
        return ctxt.getConfig().getTypeResolverProvider().findPropertyContentTypeSerializer(ctxt, accessor, containerType);
    }

    protected final JsonSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config, BeanDescription beanDesc, JsonFormat.Value format, boolean staticTyping) {
        Class<?> raw = type.getRawClass();
        JsonSerializer<?> ser = StdJdkSerializers.find(raw);
        if (ser == null) {
            String clsName = raw.getName();
            ser = _concrete.get(clsName);
        }
        return ser;
    }

    protected final JsonSerializer<?> findSerializerByAnnotations(SerializerProvider ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(raw)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMember valueAccessor = beanDesc.findJsonValueAccessor();
        if (valueAccessor != null) {
            if (ctxt.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(valueAccessor.getMember(), ctxt.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(ctxt, valueAccessor);
            JavaType valueType = valueAccessor.getType();
            TypeSerializer vts = ctxt.findTypeSerializer(valueType);
            return new JsonValueSerializer(type, valueType, false, vts, ser, valueAccessor);
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByPrimaryType(SerializerProvider ctxt, JavaType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, boolean staticTyping) throws JsonMappingException {
        if (type.isTypeOrSubTypeOf(Calendar.class)) {
            return CalendarSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(Date.class)) {
            return DateSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(Stream.class)) {
            return new Jdk8StreamSerializer(type, ctxt.getTypeFactory().findFirstTypeParameter(type, Stream.class));
        }
        if (type.isTypeOrSubTypeOf(Number.class)) {
            JsonFormat.Value format = this._calculateEffectiveFormat(beanDesc, Number.class, formatOverrides);
            switch (format.getShape()) {
                case STRING: {
                    return ToStringSerializer.instance;
                }
                case OBJECT: {
                    return null;
                }
            }
            return NumberSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(Enum.class)) {
            return this.buildEnumSerializer(ctxt, type, beanDesc, this._calculateEffectiveFormat(beanDesc, Enum.class, formatOverrides));
        }
        Class<?> raw = type.getRawClass();
        if (Map.Entry.class.isAssignableFrom(raw)) {
            JavaType mapEntryType = type.findSuperType(Map.Entry.class);
            JavaType kt = mapEntryType.containedTypeOrUnknown(0);
            JavaType vt = mapEntryType.containedTypeOrUnknown(1);
            return this.buildMapEntrySerializer(ctxt, type, beanDesc, this._calculateEffectiveFormat(beanDesc, Map.Entry.class, formatOverrides), staticTyping, kt, vt);
        }
        if (ByteBuffer.class.isAssignableFrom(raw)) {
            return new ByteBufferSerializer();
        }
        if (InetAddress.class.isAssignableFrom(raw)) {
            return new InetAddressSerializer();
        }
        if (InetSocketAddress.class.isAssignableFrom(raw)) {
            return new InetSocketAddressSerializer();
        }
        if (TimeZone.class.isAssignableFrom(raw)) {
            return new TimeZoneSerializer();
        }
        if (Charset.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (LongStream.class.isAssignableFrom(raw)) {
            return LongStreamSerializer.INSTANCE;
        }
        if (IntStream.class.isAssignableFrom(raw)) {
            return IntStreamSerializer.INSTANCE;
        }
        if (DoubleStream.class.isAssignableFrom(raw)) {
            return DoubleStreamSerializer.INSTANCE;
        }
        if (Path.class.isAssignableFrom(raw)) {
            return StringLikeSerializer.find(Path.class);
        }
        JsonSerializer<?> ser = OptionalHandlerFactory.instance.findSerializer(ctxt.getConfig(), type, beanDesc);
        if (ser != null) {
            return ser;
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByAddonType(SerializerProvider ctxt, JavaType javaType, BeanDescription beanDesc, JsonFormat.Value formatOverrides, boolean staticTyping) throws JsonMappingException {
        TypeFactory tf = ctxt.getTypeFactory();
        if (javaType.isTypeOrSubTypeOf(Iterator.class)) {
            return this.buildIteratorSerializer(ctxt, javaType, beanDesc, formatOverrides, staticTyping, tf.findFirstTypeParameter(javaType, Iterator.class));
        }
        if (javaType.isTypeOrSubTypeOf(Iterable.class)) {
            return this.buildIterableSerializer(ctxt, javaType, beanDesc, formatOverrides, staticTyping, tf.findFirstTypeParameter(javaType, Iterable.class));
        }
        if (javaType.isTypeOrSubTypeOf(CharSequence.class)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializerProvider prov, Annotated a) throws JsonMappingException {
        Object serDef = prov.getAnnotationIntrospector().findSerializer(prov.getConfig(), a);
        if (serDef == null) {
            return null;
        }
        return this.findConvertingSerializer(prov, a, prov.serializerInstance(a, serDef));
    }

    protected JsonSerializer<?> findConvertingSerializer(SerializerProvider prov, Annotated a, JsonSerializer<?> ser) throws JsonMappingException {
        Converter<Object, Object> conv = this.findConverter(prov, a);
        if (conv == null) {
            return ser;
        }
        JavaType delegateType = conv.getOutputType(prov.getTypeFactory());
        return new StdDelegatingSerializer(conv, delegateType, ser, null);
    }

    protected Converter<Object, Object> findConverter(SerializerProvider prov, Annotated a) throws JsonMappingException {
        Object convDef = prov.getAnnotationIntrospector().findSerializationConverter(prov.getConfig(), a);
        if (convDef == null) {
            return null;
        }
        return prov.converterInstance(a, convDef);
    }

    protected JsonSerializer<?> buildContainerSerializer(SerializerProvider ctxt, JavaType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, boolean staticTyping) throws JsonMappingException {
        JavaType elementType;
        TypeSerializer elementTypeSerializer;
        if (!(staticTyping || !type.useStaticType() || type.isContainerType() && type.getContentType().isJavaLangObject())) {
            staticTyping = true;
        }
        if ((elementTypeSerializer = ctxt.findTypeSerializer(elementType = type.getContentType())) != null) {
            staticTyping = false;
        }
        JsonSerializer<Object> elementValueSerializer = this._findContentSerializer(ctxt, beanDesc.getClassInfo());
        SerializationConfig config = ctxt.getConfig();
        if (type.isMapLikeType()) {
            Serializers serializers;
            MapLikeType mlt = (MapLikeType)type;
            JsonSerializer<Object> keySerializer = this._findKeySerializer(ctxt, beanDesc.getClassInfo());
            if (mlt.isTrueMapType()) {
                return this.buildMapSerializer(ctxt, (MapType)mlt, beanDesc, formatOverrides, staticTyping, keySerializer, elementTypeSerializer, elementValueSerializer);
            }
            JsonSerializer<?> ser = null;
            MapLikeType mlType = (MapLikeType)type;
            Iterator<Object> iterator = this.customSerializers().iterator();
            while (iterator.hasNext() && (ser = (serializers = iterator.next()).findMapLikeSerializer(config, mlType, beanDesc, formatOverrides, keySerializer, elementTypeSerializer, elementValueSerializer)) == null) {
            }
            if (ser == null) {
                ser = this.findSerializerByAnnotations(ctxt, type, beanDesc);
            }
            if (ser != null && this._factoryConfig.hasSerializerModifiers()) {
                for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                    ser = mod.modifyMapLikeSerializer(config, mlType, beanDesc, ser);
                }
            }
            return ser;
        }
        if (type.isCollectionLikeType()) {
            Serializers serializers;
            CollectionLikeType clt = (CollectionLikeType)type;
            if (clt.isTrueCollectionType()) {
                return this.buildCollectionSerializer(ctxt, (CollectionType)clt, beanDesc, formatOverrides, staticTyping, elementTypeSerializer, elementValueSerializer);
            }
            JsonSerializer<?> ser = null;
            CollectionLikeType clType = (CollectionLikeType)type;
            Iterator<Object> iterator = this.customSerializers().iterator();
            while (iterator.hasNext() && (ser = (serializers = iterator.next()).findCollectionLikeSerializer(config, clType, beanDesc, formatOverrides, elementTypeSerializer, elementValueSerializer)) == null) {
            }
            if (ser == null) {
                ser = this.findSerializerByAnnotations(ctxt, type, beanDesc);
            }
            if (ser != null && this._factoryConfig.hasSerializerModifiers()) {
                for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                    ser = mod.modifyCollectionLikeSerializer(config, clType, beanDesc, ser);
                }
            }
            return ser;
        }
        if (type.isArrayType()) {
            return this.buildArraySerializer(ctxt, (ArrayType)type, beanDesc, formatOverrides, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        return null;
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializerProvider prov, CollectionType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        SerializationConfig config = prov.getConfig();
        StdSerializer ser = null;
        Iterator<Serializers> iterator = this.customSerializers().iterator();
        while (iterator.hasNext() && (ser = (serializers = iterator.next()).findCollectionSerializer(config, type, beanDesc, formatOverrides, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        JsonFormat.Value format = this._calculateEffectiveFormat(beanDesc, Collection.class, formatOverrides);
        if (ser == null && (ser = this.findSerializerByAnnotations(prov, type, beanDesc)) == null) {
            if (format.getShape() == JsonFormat.Shape.POJO) {
                return null;
            }
            Class<?> raw = type.getRawClass();
            if (EnumSet.class.isAssignableFrom(raw)) {
                JavaType enumType = type.getContentType();
                if (!enumType.isEnumType()) {
                    enumType = null;
                }
                ser = this.buildEnumSetSerializer(enumType);
            } else {
                Class<?> elementRaw = type.getContentType().getRawClass();
                if (this.isIndexedList(raw)) {
                    if (elementRaw == String.class) {
                        if (ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                            ser = IndexedStringListSerializer.instance;
                        }
                    } else {
                        ser = this.buildIndexedListSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
                    }
                } else if (elementRaw == String.class && ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                    ser = StringCollectionSerializer.instance;
                }
                if (ser == null) {
                    ser = this.buildCollectionSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
                }
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyCollectionSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected boolean isIndexedList(Class<?> cls) {
        return RandomAccess.class.isAssignableFrom(cls);
    }

    public ContainerSerializer<?> buildIndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        return new IndexedListSerializer(elemType, staticTyping, vts, valueSerializer);
    }

    public ContainerSerializer<?> buildCollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        return new CollectionSerializer(elemType, staticTyping, vts, valueSerializer);
    }

    public JsonSerializer<?> buildEnumSetSerializer(JavaType enumType) {
        return new EnumSetSerializer(enumType);
    }

    protected JsonSerializer<?> buildMapSerializer(SerializerProvider prov, MapType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, boolean staticTyping, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        JsonFormat.Value format = this._calculateEffectiveFormat(beanDesc, Map.class, formatOverrides);
        if (format.getShape() == JsonFormat.Shape.POJO) {
            return null;
        }
        MapSerializer ser = null;
        SerializationConfig config = prov.getConfig();
        Iterator<Object> iterator = this.customSerializers().iterator();
        while (iterator.hasNext() && (ser = (serializers = iterator.next()).findMapSerializer(config, type, beanDesc, formatOverrides, keySerializer, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null && (ser = this.findSerializerByAnnotations(prov, type, beanDesc)) == null) {
            Object filterId = this.findFilterId(config, beanDesc);
            JsonIgnoreProperties.Value ignorals = config.getDefaultPropertyIgnorals(Map.class, beanDesc.getClassInfo());
            Set ignored = ignorals == null ? null : ignorals.findIgnoredForSerialization();
            MapSerializer mapSer = MapSerializer.construct(ignored, type, staticTyping, elementTypeSerializer, keySerializer, elementValueSerializer, filterId);
            ser = this._checkMapContentInclusion(prov, beanDesc, mapSer);
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyMapSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected MapSerializer _checkMapContentInclusion(SerializerProvider prov, BeanDescription beanDesc, MapSerializer mapSer) throws JsonMappingException {
        Object valueToSuppress;
        JsonInclude.Include incl;
        JavaType contentType = mapSer.getContentType();
        JsonInclude.Value inclV = this._findInclusionWithContent(prov, beanDesc, contentType, Map.class);
        JsonInclude.Include include = incl = inclV == null ? JsonInclude.Include.USE_DEFAULTS : inclV.getContentInclusion();
        if (incl == JsonInclude.Include.USE_DEFAULTS || incl == JsonInclude.Include.ALWAYS) {
            return mapSer;
        }
        boolean suppressNulls = true;
        switch (incl) {
            case NON_DEFAULT: {
                valueToSuppress = BeanUtil.getDefaultValue(contentType);
                if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                break;
            }
            case NON_ABSENT: {
                valueToSuppress = contentType.isReferenceType() ? MapSerializer.MARKER_FOR_EMPTY : null;
                break;
            }
            case NON_EMPTY: {
                valueToSuppress = MapSerializer.MARKER_FOR_EMPTY;
                break;
            }
            case CUSTOM: {
                valueToSuppress = prov.includeFilterInstance(null, inclV.getContentFilter());
                if (valueToSuppress == null) {
                    suppressNulls = true;
                    break;
                }
                suppressNulls = prov.includeFilterSuppressNulls(valueToSuppress);
                break;
            }
            default: {
                valueToSuppress = null;
            }
        }
        return mapSer.withContentInclusion(valueToSuppress, suppressNulls);
    }

    protected JsonSerializer<?> buildMapEntrySerializer(SerializerProvider ctxt, JavaType type, BeanDescription beanDesc, JsonFormat.Value effectiveFormat, boolean staticTyping, JavaType keyType, JavaType valueType) throws JsonMappingException {
        Object valueToSuppress;
        JsonInclude.Include incl;
        if (effectiveFormat.getShape() == JsonFormat.Shape.POJO) {
            return null;
        }
        MapEntrySerializer ser = new MapEntrySerializer(valueType, keyType, valueType, staticTyping, ctxt.findTypeSerializer(valueType), null);
        JavaType contentType = ser.getContentType();
        JsonInclude.Value inclV = this._findInclusionWithContent(ctxt, beanDesc, contentType, Map.Entry.class);
        JsonInclude.Include include = incl = inclV == null ? JsonInclude.Include.USE_DEFAULTS : inclV.getContentInclusion();
        if (incl == JsonInclude.Include.USE_DEFAULTS || incl == JsonInclude.Include.ALWAYS) {
            return ser;
        }
        boolean suppressNulls = true;
        switch (incl) {
            case NON_DEFAULT: {
                valueToSuppress = BeanUtil.getDefaultValue(contentType);
                if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                break;
            }
            case NON_ABSENT: {
                valueToSuppress = contentType.isReferenceType() ? MapSerializer.MARKER_FOR_EMPTY : null;
                break;
            }
            case NON_EMPTY: {
                valueToSuppress = MapSerializer.MARKER_FOR_EMPTY;
                break;
            }
            case CUSTOM: {
                valueToSuppress = ctxt.includeFilterInstance(null, inclV.getContentFilter());
                if (valueToSuppress == null) {
                    suppressNulls = true;
                    break;
                }
                suppressNulls = ctxt.includeFilterSuppressNulls(valueToSuppress);
                break;
            }
            default: {
                valueToSuppress = null;
            }
        }
        return ser.withContentInclusion(valueToSuppress, suppressNulls);
    }

    protected JsonInclude.Value _findInclusionWithContent(SerializerProvider prov, BeanDescription beanDesc, JavaType contentType, Class<?> configType) throws JsonMappingException {
        SerializationConfig config = prov.getConfig();
        JsonInclude.Value inclV = beanDesc.findPropertyInclusion(config.getDefaultPropertyInclusion());
        inclV = config.getDefaultPropertyInclusion(configType, inclV);
        JsonInclude.Value valueIncl = config.getDefaultPropertyInclusion(contentType.getRawClass(), null);
        if (valueIncl != null) {
            switch (valueIncl.getValueInclusion()) {
                case USE_DEFAULTS: {
                    break;
                }
                case CUSTOM: {
                    inclV = inclV.withContentFilter(valueIncl.getContentFilter());
                    break;
                }
                default: {
                    inclV = inclV.withContentInclusion(valueIncl.getValueInclusion());
                }
            }
        }
        return inclV;
    }

    protected JsonSerializer<?> buildArraySerializer(SerializerProvider prov, ArrayType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        SerializationConfig config = prov.getConfig();
        JsonSerializer ser = null;
        Iterator<Object> iterator = this.customSerializers().iterator();
        while (iterator.hasNext() && (ser = (serializers = iterator.next()).findArraySerializer(config, type, beanDesc, formatOverrides, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null) {
            Class<?> raw = type.getRawClass();
            if (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                ser = String[].class == raw ? StringArraySerializer.instance : StdArraySerializers.findStandardImpl(raw);
            }
            if (ser == null) {
                ser = new ObjectArraySerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyArraySerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    public JsonSerializer<?> findReferenceSerializer(SerializerProvider ctxt, ReferenceType refType, BeanDescription beanDesc, JsonFormat.Value format, boolean staticTyping) throws JsonMappingException {
        JavaType contentType = refType.getContentType();
        TypeSerializer contentTypeSerializer = (TypeSerializer)contentType.getTypeHandler();
        SerializationConfig config = ctxt.getConfig();
        if (contentTypeSerializer == null) {
            contentTypeSerializer = ctxt.findTypeSerializer(contentType);
        }
        JsonSerializer contentSerializer = (JsonSerializer)contentType.getValueHandler();
        for (Serializers serializers : this.customSerializers()) {
            JsonSerializer<?> ser = serializers.findReferenceSerializer(config, refType, beanDesc, format, contentTypeSerializer, contentSerializer);
            if (ser == null) continue;
            return ser;
        }
        if (refType.isTypeOrSubTypeOf(AtomicReference.class)) {
            return this._buildReferenceSerializer(ctxt, AtomicReference.class, refType, beanDesc, staticTyping, contentTypeSerializer, contentSerializer);
        }
        if (refType.isTypeOrSubTypeOf(Optional.class)) {
            return this._buildReferenceSerializer(ctxt, Optional.class, refType, beanDesc, staticTyping, contentTypeSerializer, contentSerializer);
        }
        if (refType.isTypeOrSubTypeOf(OptionalInt.class)) {
            return new OptionalIntSerializer();
        }
        if (refType.isTypeOrSubTypeOf(OptionalLong.class)) {
            return new OptionalLongSerializer();
        }
        if (refType.isTypeOrSubTypeOf(OptionalDouble.class)) {
            return new OptionalDoubleSerializer();
        }
        return null;
    }

    protected JsonSerializer<?> _buildReferenceSerializer(SerializerProvider prov, Class<?> baseType, ReferenceType refType, BeanDescription beanDesc, boolean staticTyping, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentSerializer) throws JsonMappingException {
        boolean suppressNulls;
        Object valueToSuppress;
        JsonInclude.Include incl;
        JavaType contentType = refType.getReferencedType();
        JsonInclude.Value inclV = this._findInclusionWithContent(prov, beanDesc, contentType, baseType);
        JsonInclude.Include include = incl = inclV == null ? JsonInclude.Include.USE_DEFAULTS : inclV.getContentInclusion();
        if (incl == JsonInclude.Include.USE_DEFAULTS || incl == JsonInclude.Include.ALWAYS) {
            valueToSuppress = null;
            suppressNulls = false;
        } else {
            suppressNulls = true;
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.getDefaultValue(contentType);
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    valueToSuppress = contentType.isReferenceType() ? MapSerializer.MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    valueToSuppress = MapSerializer.MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = prov.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = prov.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                default: {
                    valueToSuppress = null;
                }
            }
        }
        ReferenceTypeSerializer ser = baseType == Optional.class ? new Jdk8OptionalSerializer(refType, staticTyping, contentTypeSerializer, contentSerializer) : new AtomicReferenceSerializer(refType, staticTyping, contentTypeSerializer, contentSerializer);
        return ser.withContentInclusion(valueToSuppress, suppressNulls);
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializerProvider ctxt, JavaType type, BeanDescription beanDesc, JsonFormat.Value formatOverrides, boolean staticTyping, JavaType valueType) throws JsonMappingException {
        return new IteratorSerializer(valueType, staticTyping, ctxt.findTypeSerializer(valueType));
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializerProvider ctxt, JavaType type, BeanDescription beanDesc, JsonFormat.Value effectiveFormat, boolean staticTyping, JavaType valueType) throws JsonMappingException {
        return new IterableSerializer(valueType, staticTyping, ctxt.findTypeSerializer(valueType));
    }

    protected JsonSerializer<?> buildEnumSerializer(SerializerProvider ctxt, JavaType type, BeanDescription beanDesc, JsonFormat.Value effectiveFormat) throws JsonMappingException {
        if (effectiveFormat.getShape() == JsonFormat.Shape.POJO) {
            ((BasicBeanDescription)beanDesc).removeProperty("declaringClass");
            return null;
        }
        Class<?> enumClass = type.getRawClass();
        SerializationConfig config = ctxt.getConfig();
        JsonSerializer ser = EnumSerializer.construct(enumClass, config, beanDesc, effectiveFormat);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyEnumSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected JsonFormat.Value _calculateEffectiveFormat(BeanDescription beanDesc, Class<?> baseType, JsonFormat.Value formatOverrides) {
        JsonFormat.Value fromType = beanDesc.findExpectedFormat(baseType);
        if (formatOverrides == null) {
            return fromType;
        }
        return JsonFormat.Value.merge((JsonFormat.Value)fromType, (JsonFormat.Value)formatOverrides);
    }

    protected JsonSerializer<Object> _findKeySerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findKeySerializer(prov.getConfig(), a);
        return prov.serializerInstance(a, serDef);
    }

    protected JsonSerializer<Object> _findContentSerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findContentSerializer(prov.getConfig(), a);
        return prov.serializerInstance(a, serDef);
    }

    protected Object findFilterId(SerializationConfig config, BeanDescription beanDesc) {
        return config.getAnnotationIntrospector().findFilterId(beanDesc.getClassInfo());
    }

    protected boolean usesStaticTyping(SerializationConfig config, BeanDescription beanDesc, TypeSerializer typeSer) {
        if (typeSer != null) {
            return false;
        }
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        JsonSerialize.Typing t = intr.findSerializationTyping(config, beanDesc.getClassInfo());
        if (t != null && t != JsonSerialize.Typing.DEFAULT_TYPING) {
            return t == JsonSerialize.Typing.STATIC;
        }
        return config.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    static {
        HashMap concrete = new HashMap();
        concrete.put(String.class.getName(), StringSerializer.instance);
        ToStringSerializer sls = ToStringSerializer.instance;
        concrete.put(StringBuffer.class.getName(), sls);
        concrete.put(StringBuilder.class.getName(), sls);
        concrete.put(Character.class.getName(), sls);
        concrete.put(Character.TYPE.getName(), sls);
        NumberSerializers.addAll(concrete);
        concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        concrete.put(BigInteger.class.getName(), new NumberSerializer((Class<? extends Number>)BigInteger.class));
        concrete.put(BigDecimal.class.getName(), new NumberSerializer((Class<? extends Number>)BigDecimal.class));
        concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        concrete.put(Date.class.getName(), DateSerializer.instance);
        _concrete = concrete;
    }
}

