/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public abstract class ContainerSerializer<T>
extends StdSerializer<T> {
    protected final BeanProperty _property;
    protected PropertySerializerMap _dynamicValueSerializers;

    protected ContainerSerializer(Class<?> t) {
        super(t);
        this._property = null;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    @Deprecated
    protected ContainerSerializer(Class<?> t, boolean dummy) {
        super(t);
        this._property = null;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    @Deprecated
    protected ContainerSerializer(JavaType fullType) {
        this(fullType, null);
    }

    protected ContainerSerializer(JavaType fullType, BeanProperty prop) {
        super(fullType);
        this._property = prop;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected ContainerSerializer(ContainerSerializer<?> src) {
        this(src, src._property);
    }

    protected ContainerSerializer(ContainerSerializer<?> src, BeanProperty prop) {
        super(src._handledType);
        this._property = prop;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    public ContainerSerializer<?> withValueTypeSerializer(TypeSerializer vts) {
        if (vts == null) {
            return this;
        }
        return this._withValueTypeSerializer(vts);
    }

    public abstract JavaType getContentType();

    public abstract JsonSerializer<?> getContentSerializer();

    @Override
    public abstract boolean isEmpty(SerializerProvider var1, T var2) throws IOException;

    public abstract boolean hasSingleElement(T var1);

    protected abstract ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer var1);

    protected JsonSerializer<Object> _findAndAddDynamic(SerializerProvider ctxt, Class<?> type) throws JsonMappingException {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected JsonSerializer<Object> _findAndAddDynamic(SerializerProvider ctxt, JavaType type) throws JsonMappingException {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

