/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.core.util.Snapshottable;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import com.fasterxml.jackson.databind.util.SimpleLookupCache;
import com.fasterxml.jackson.databind.util.TypeKey;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;

public final class SerializerCache
implements Snapshottable<SerializerCache>,
Serializable {
    private static final long serialVersionUID = 3L;
    public static final int DEFAULT_MAX_CACHED = 4000;
    private final SimpleLookupCache<TypeKey, JsonSerializer<Object>> _sharedMap;
    private final transient AtomicReference<ReadOnlyClassToSerializerMap> _readOnlyMap;

    public SerializerCache() {
        this(4000);
    }

    public SerializerCache(int maxCached) {
        int initial = Math.min(64, maxCached >> 2);
        this._sharedMap = new SimpleLookupCache(initial, maxCached);
        this._readOnlyMap = new AtomicReference();
    }

    private SerializerCache(SimpleLookupCache<TypeKey, JsonSerializer<Object>> shared) {
        this._sharedMap = shared;
        this._readOnlyMap = new AtomicReference();
    }

    protected Object readResolve() {
        return new SerializerCache(this._sharedMap);
    }

    public SerializerCache snapshot() {
        return new SerializerCache((SimpleLookupCache<TypeKey, JsonSerializer<Object>>)this._sharedMap.snapshot());
    }

    public ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap m = this._readOnlyMap.get();
        if (m != null) {
            return m;
        }
        return this._makeReadOnlyLookupMap();
    }

    private final synchronized ReadOnlyClassToSerializerMap _makeReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap m = this._readOnlyMap.get();
        if (m == null) {
            m = ReadOnlyClassToSerializerMap.from(this, this._sharedMap);
            this._readOnlyMap.set(m);
        }
        return m;
    }

    public int size() {
        return this._sharedMap.size();
    }

    public JsonSerializer<Object> untypedValueSerializer(Class<?> type) {
        return this._sharedMap.get(new TypeKey(type, false));
    }

    public JsonSerializer<Object> untypedValueSerializer(JavaType type) {
        return this._sharedMap.get(new TypeKey(type, false));
    }

    public JsonSerializer<Object> typedValueSerializer(JavaType type) {
        return this._sharedMap.get(new TypeKey(type, true));
    }

    public JsonSerializer<Object> typedValueSerializer(Class<?> cls) {
        return this._sharedMap.get(new TypeKey(cls, true));
    }

    public void addTypedSerializer(JavaType type, JsonSerializer<Object> ser) {
        if (this._sharedMap.put(new TypeKey(type, true), ser) == null) {
            this._readOnlyMap.set(null);
        }
    }

    public void addTypedSerializer(Class<?> cls, JsonSerializer<Object> ser) {
        if (this._sharedMap.put(new TypeKey(cls, true), ser) == null) {
            this._readOnlyMap.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(Class<?> type, JsonSerializer<Object> ser, SerializerProvider provider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(type, false), ser) == null) {
                this._readOnlyMap.set(null);
            }
            ser.resolve(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(JavaType type, JsonSerializer<Object> ser, SerializerProvider provider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(type, false), ser) == null) {
                this._readOnlyMap.set(null);
            }
            ser.resolve(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(Class<?> rawType, JavaType fullType, JsonSerializer<Object> ser, SerializerProvider provider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            JsonSerializer<Object> ob1 = this._sharedMap.put(new TypeKey(rawType, false), ser);
            JsonSerializer<Object> ob2 = this._sharedMap.put(new TypeKey(fullType, false), ser);
            if (ob1 == null || ob2 == null) {
                this._readOnlyMap.set(null);
            }
            ser.resolve(provider);
        }
    }

    public synchronized void flush() {
        this._sharedMap.clear();
    }
}

