/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.impl.BeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.UnwrappingBeanSerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;

@JacksonStdImpl
public class UnrolledBeanSerializer
extends BeanSerializerBase {
    private static final long serialVersionUID = 30L;
    private static final int MAX_PROPS = 6;
    protected final int _propCount;
    protected BeanPropertyWriter _prop1;
    protected BeanPropertyWriter _prop2;
    protected BeanPropertyWriter _prop3;
    protected BeanPropertyWriter _prop4;
    protected BeanPropertyWriter _prop5;
    protected BeanPropertyWriter _prop6;

    public UnrolledBeanSerializer(JavaType type, BeanSerializerBuilder builder, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(type, builder, properties, filteredProperties);
        this._propCount = this._props.length;
        this._calcUnrolled();
    }

    protected UnrolledBeanSerializer(UnrolledBeanSerializer src, Set<String> toIgnore) {
        super((BeanSerializerBase)src, toIgnore);
        this._propCount = this._props.length;
        this._calcUnrolled();
    }

    private void _calcUnrolled() {
        BeanPropertyWriter[] oProps = new BeanPropertyWriter[6];
        int offset = 6 - this._propCount;
        System.arraycopy(this._props, 0, oProps, offset, this._propCount);
        this._prop1 = oProps[0];
        this._prop2 = oProps[1];
        this._prop3 = oProps[2];
        this._prop4 = oProps[3];
        this._prop5 = oProps[4];
        this._prop6 = oProps[5];
    }

    public static UnrolledBeanSerializer tryConstruct(JavaType type, BeanSerializerBuilder builder, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        if (properties.length > 6 || builder.getFilterId() != null) {
            return null;
        }
        return new UnrolledBeanSerializer(type, builder, properties, filteredProperties);
    }

    @Override
    public JsonSerializer<Object> unwrappingSerializer(NameTransformer unwrapper) {
        return new UnwrappingBeanSerializer((BeanSerializerBase)this, unwrapper);
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new BeanSerializer((BeanSerializerBase)this, objectIdWriter, this._propertyFilterId);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanSerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    @Override
    protected BeanSerializerBase withIgnorals(Set<String> toIgnore) {
        return new UnrolledBeanSerializer(this, toIgnore);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        if (this.canCreateArraySerializer()) {
            return BeanAsArraySerializer.construct(this);
        }
        return this;
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        super.resolve(provider);
        this._calcUnrolled();
    }

    @Override
    public void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        BeanPropertyWriter[] fProps = this._filteredProps;
        if (fProps != null && provider.getActiveView() != null) {
            gen.writeStartObject(bean);
            this._serializeFieldsMaybeView(bean, gen, provider, fProps);
            gen.writeEndObject();
            return;
        }
        this.serializeNonFiltered(bean, gen, provider);
    }

    protected void serializeNonFiltered(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject(bean);
        BeanPropertyWriter prop = null;
        try {
            switch (this._propCount) {
                default: {
                    prop = this._prop1;
                    prop.serializeAsField(bean, gen, provider);
                }
                case 5: {
                    prop = this._prop2;
                    prop.serializeAsField(bean, gen, provider);
                }
                case 4: {
                    prop = this._prop3;
                    prop.serializeAsField(bean, gen, provider);
                }
                case 3: {
                    prop = this._prop4;
                    prop.serializeAsField(bean, gen, provider);
                }
                case 2: {
                    prop = this._prop5;
                    prop.serializeAsField(bean, gen, provider);
                }
                case 1: {
                    prop = this._prop6;
                    prop.serializeAsField(bean, gen, provider);
                }
                case 0: 
            }
            prop = null;
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(bean, gen, provider);
            }
        }
        catch (Exception e) {
            String name = prop == null ? "[anySetter]" : prop.getName();
            this.wrapAndThrow(provider, (Throwable)e, bean, name);
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = new JsonMappingException((Closeable)gen, "Infinite recursion (StackOverflowError)", e);
            String name = prop == null ? "[anySetter]" : prop.getName();
            mapE.prependPath(new JsonMappingException.Reference(bean, name));
            throw mapE;
        }
        gen.writeEndObject();
    }
}

