/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.UnrolledBeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Set;

public class BeanAsArraySerializer
extends BeanSerializerBase {
    private static final long serialVersionUID = 3L;
    protected final BeanSerializerBase _defaultSerializer;

    public BeanAsArraySerializer(BeanSerializerBase src) {
        super(src, (ObjectIdWriter)null);
        this._defaultSerializer = src;
    }

    protected BeanAsArraySerializer(BeanSerializerBase src, Set<String> toIgnore) {
        super(src, toIgnore);
        this._defaultSerializer = src;
    }

    protected BeanAsArraySerializer(BeanSerializerBase src, ObjectIdWriter oiw, Object filterId) {
        super(src, oiw, filterId);
        this._defaultSerializer = src;
    }

    public static BeanSerializerBase construct(BeanSerializerBase src) {
        UnrolledBeanAsArraySerializer ser = UnrolledBeanAsArraySerializer.tryConstruct(src);
        if (ser != null) {
            return ser;
        }
        return new BeanAsArraySerializer(src);
    }

    @Override
    public JsonSerializer<Object> unwrappingSerializer(NameTransformer transformer) {
        return this._defaultSerializer.unwrappingSerializer(transformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    @Override
    protected BeanAsArraySerializer withIgnorals(Set<String> toIgnore) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, toIgnore);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public void serializeWithType(Object bean, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        boolean filtered;
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, provider, typeSer);
            return;
        }
        gen.setCurrentValue(bean);
        WritableTypeId typeIdDef = this._typeIdDef(typeSer, bean, JsonToken.START_ARRAY);
        typeSer.writeTypePrefix(gen, typeIdDef);
        boolean bl = filtered = this._filteredProps != null && provider.getActiveView() != null;
        if (filtered) {
            this.serializeFiltered(bean, gen, provider);
        } else {
            this.serializeNonFiltered(bean, gen, provider);
        }
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public final void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        boolean filtered;
        boolean bl = filtered = this._filteredProps != null && provider.getActiveView() != null;
        if (provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(provider)) {
            if (filtered) {
                this.serializeFiltered(bean, gen, provider);
            } else {
                this.serializeNonFiltered(bean, gen, provider);
            }
            return;
        }
        gen.writeStartArray(bean, this._props.length);
        if (filtered) {
            this.serializeFiltered(bean, gen, provider);
        } else {
            this.serializeNonFiltered(bean, gen, provider);
        }
        gen.writeEndArray();
    }

    private boolean hasSingleElement(SerializerProvider provider) {
        return this._props.length == 1;
    }

    protected final void serializeNonFiltered(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        BeanPropertyWriter[] props = this._props;
        int i = 0;
        int left = props.length;
        BeanPropertyWriter prop = null;
        try {
            if (left > 3) {
                do {
                    prop = props[i];
                    prop.serializeAsElement(bean, gen, provider);
                    prop = props[i + 1];
                    prop.serializeAsElement(bean, gen, provider);
                    prop = props[i + 2];
                    prop.serializeAsElement(bean, gen, provider);
                    prop = props[i + 3];
                    prop.serializeAsElement(bean, gen, provider);
                    i += 4;
                } while ((left -= 4) > 3);
            }
            switch (left) {
                case 3: {
                    prop = props[i++];
                    prop.serializeAsElement(bean, gen, provider);
                }
                case 2: {
                    prop = props[i++];
                    prop.serializeAsElement(bean, gen, provider);
                }
                case 1: {
                    prop = props[i++];
                    prop.serializeAsElement(bean, gen, provider);
                }
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, bean, prop.getName());
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = JsonMappingException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e);
            mapE.prependPath(new JsonMappingException.Reference(bean, prop.getName()));
            throw mapE;
        }
    }

    protected final void serializeFiltered(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        BeanPropertyWriter[] props = this._filteredProps;
        int i = 0;
        int left = props.length;
        BeanPropertyWriter prop = null;
        try {
            if (left > 3) {
                do {
                    if ((prop = props[i]) == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, provider);
                    }
                    prop = props[i + 1];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, provider);
                    }
                    prop = props[i + 2];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, provider);
                    }
                    prop = props[i + 3];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, provider);
                    }
                    i += 4;
                } while ((left -= 4) > 3);
            }
            switch (left) {
                case 3: {
                    prop = props[i++];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, provider);
                    }
                }
                case 2: {
                    prop = props[i++];
                    if (prop == null) {
                        gen.writeNull();
                    } else {
                        prop.serializeAsElement(bean, gen, provider);
                    }
                }
                case 1: {
                    prop = props[i++];
                    if (prop == null) {
                        gen.writeNull();
                        break;
                    }
                    prop.serializeAsElement(bean, gen, provider);
                }
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, bean, prop.getName());
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = JsonMappingException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e);
            mapE.prependPath(new JsonMappingException.Reference(bean, prop.getName()));
            throw mapE;
        }
    }
}

