/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.Serializable;

public abstract class StdDynamicSerializer<T>
extends StdSerializer<T>
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected PropertySerializerMap _dynamicValueSerializers = PropertySerializerMap.emptyForProperties();

    protected StdDynamicSerializer(JavaType type, BeanProperty prop, TypeSerializer vts, JsonSerializer<?> valueSer) {
        super(type);
        this._property = prop;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
    }

    protected StdDynamicSerializer(StdDynamicSerializer<?> src, BeanProperty prop) {
        super(src);
        this._property = prop;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._valueSerializer = src._valueSerializer;
    }

    protected StdDynamicSerializer(StdDynamicSerializer<?> src, BeanProperty prop, TypeSerializer vts, JsonSerializer<?> valueSer) {
        super(src);
        this._property = prop;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(SerializerProvider ctxt, Class<?> type) throws JsonMappingException {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(SerializerProvider ctxt, JavaType type) throws JsonMappingException {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

