/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

@JacksonStdImpl
public class StringLikeSerializer
extends StdSerializer<Object> {
    private static final long serialVersionUID = 1L;
    protected static final int TYPE_URL = 1;
    protected static final int TYPE_URI = 2;
    protected static final int TYPE_FILE = 3;
    protected static final int TYPE_PATH = 4;
    protected static final int TYPE_CLASS = 5;
    protected static final int TYPE_CURRENCY = 6;
    protected static final int TYPE_LOCALE = 7;
    protected static final int TYPE_PATTERN = 8;
    private static final Map<Class<?>, Integer> _types = new HashMap();
    private final int _type;

    public StringLikeSerializer(Class<?> handledType, int type) {
        super(handledType);
        this._type = type;
    }

    public static final JsonSerializer<?> find(Class<?> raw) {
        Integer I = _types.get(raw);
        if (I == null) {
            return null;
        }
        return new StringLikeSerializer(raw, I);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return value.toString().isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializerProvider provider) throws IOException {
        String str;
        switch (this._type) {
            case 3: {
                str = ((File)value).getAbsolutePath();
                break;
            }
            case 4: {
                str = ((Path)value).toUri().toString();
                break;
            }
            case 5: {
                str = ((Class)value).getName();
                break;
            }
            case 7: {
                Locale loc = (Locale)value;
                if (loc == Locale.ROOT) {
                    str = "";
                    break;
                }
                str = loc.toLanguageTag();
                break;
            }
            default: {
                str = value.toString();
            }
        }
        g.writeString(str);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, this.handledType(), JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }

    static {
        _types.put(URL.class, 1);
        _types.put(URI.class, 2);
        _types.put(File.class, 3);
        _types.put(Path.class, 4);
        _types.put(Class.class, 5);
        _types.put(Currency.class, 6);
        _types.put(Locale.class, 7);
        _types.put(Pattern.class, 8);
    }
}

