/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

public final class BaseSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final PropertyNamingStrategy _propertyNamingStrategy;
    protected final AccessorNamingStrategy.Provider _accessorNaming;
    protected final TypeResolverBuilder<?> _defaultTyper;
    protected final PolymorphicTypeValidator _typeValidator;
    protected final DateFormat _dateFormat;
    protected final HandlerInstantiator _handlerInstantiator;
    protected final Locale _locale;
    protected final TimeZone _timeZone;
    protected final Base64Variant _defaultBase64;
    protected final JsonNodeFactory _nodeFactory;

    public BaseSettings(AnnotationIntrospector ai, PropertyNamingStrategy pns, AccessorNamingStrategy.Provider accNaming, TypeResolverBuilder<?> defaultTyper, PolymorphicTypeValidator ptv, DateFormat dateFormat, HandlerInstantiator hi, Locale locale, TimeZone tz, Base64Variant defaultBase64, JsonNodeFactory nodeFactory) {
        this._annotationIntrospector = ai;
        this._propertyNamingStrategy = pns;
        this._accessorNaming = accNaming;
        this._defaultTyper = defaultTyper;
        this._typeValidator = ptv;
        this._dateFormat = dateFormat;
        this._handlerInstantiator = hi;
        this._locale = locale;
        this._timeZone = tz;
        this._defaultBase64 = defaultBase64;
        this._nodeFactory = nodeFactory;
    }

    public BaseSettings withAnnotationIntrospector(AnnotationIntrospector ai) {
        if (this._annotationIntrospector == ai) {
            return this;
        }
        return new BaseSettings(ai, this._propertyNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings withInsertedAnnotationIntrospector(AnnotationIntrospector ai) {
        return this.withAnnotationIntrospector(AnnotationIntrospectorPair.create(ai, this._annotationIntrospector));
    }

    public BaseSettings withAppendedAnnotationIntrospector(AnnotationIntrospector ai) {
        return this.withAnnotationIntrospector(AnnotationIntrospectorPair.create(this._annotationIntrospector, ai));
    }

    public BaseSettings with(PropertyNamingStrategy pns) {
        if (this._propertyNamingStrategy == pns) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, pns, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings with(AccessorNamingStrategy.Provider p) {
        if (this._accessorNaming == p) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, p, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings with(TypeResolverBuilder<?> typer) {
        if (this._defaultTyper == typer) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._accessorNaming, typer, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings with(PolymorphicTypeValidator ptv) {
        if (this._typeValidator == ptv) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._accessorNaming, this._defaultTyper, ptv, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings with(DateFormat df) {
        if (this._dateFormat == df) {
            return this;
        }
        if (df != null && this.hasExplicitTimeZone()) {
            df = this._force(df, this._timeZone);
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, df, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings with(HandlerInstantiator hi) {
        if (this._handlerInstantiator == hi) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, hi, this._locale, this._timeZone, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings with(Locale l) {
        if (this._locale == l) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, l, this._timeZone, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings with(TimeZone tz) {
        if (tz == this._timeZone) {
            return this;
        }
        DateFormat df = this._force(this._dateFormat, tz == null ? DEFAULT_TIMEZONE : tz);
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, df, this._handlerInstantiator, this._locale, tz, this._defaultBase64, this._nodeFactory);
    }

    public BaseSettings with(Base64Variant base64) {
        if (base64 == this._defaultBase64) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, base64, this._nodeFactory);
    }

    public BaseSettings with(JsonNodeFactory nodeFactory) {
        if (nodeFactory == this._nodeFactory) {
            return this;
        }
        return new BaseSettings(this._annotationIntrospector, this._propertyNamingStrategy, this._accessorNaming, this._defaultTyper, this._typeValidator, this._dateFormat, this._handlerInstantiator, this._locale, this._timeZone, this._defaultBase64, nodeFactory);
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._propertyNamingStrategy;
    }

    public AccessorNamingStrategy.Provider getAccessorNaming() {
        return this._accessorNaming;
    }

    public TypeResolverBuilder<?> getDefaultTyper() {
        return this._defaultTyper;
    }

    public PolymorphicTypeValidator getPolymorphicTypeValidator() {
        return this._typeValidator;
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public HandlerInstantiator getHandlerInstantiator() {
        return this._handlerInstantiator;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public TimeZone getTimeZone() {
        TimeZone tz = this._timeZone;
        return tz == null ? DEFAULT_TIMEZONE : tz;
    }

    public boolean hasExplicitTimeZone() {
        return this._timeZone != null;
    }

    public Base64Variant getBase64Variant() {
        return this._defaultBase64;
    }

    public JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    private DateFormat _force(DateFormat df, TimeZone tz) {
        if (df instanceof StdDateFormat) {
            return ((StdDateFormat)df).withTimeZone(tz);
        }
        df = (DateFormat)df.clone();
        df.setTimeZone(tz);
        return df;
    }
}

