/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.GeneratorSettings;
import com.fasterxml.jackson.databind.ser.SerializationContextExt;
import com.fasterxml.jackson.databind.ser.SerializerCache;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import java.io.Serializable;

public abstract class SerializationContexts
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final transient TokenStreamFactory _streamFactory;
    protected final transient SerializerFactory _serializerFactory;
    protected final transient SerializerCache _cache;

    protected SerializationContexts() {
        this(null, null, null);
    }

    protected SerializationContexts(TokenStreamFactory tsf, SerializerFactory serializerFactory, SerializerCache cache) {
        this._streamFactory = tsf;
        this._serializerFactory = serializerFactory;
        this._cache = cache;
    }

    public SerializationContexts forMapper(Object mapper, TokenStreamFactory tsf, SerializerFactory serializerFactory) {
        return this.forMapper(mapper, tsf, serializerFactory, this._defaultCache());
    }

    protected abstract SerializationContexts forMapper(Object var1, TokenStreamFactory var2, SerializerFactory var3, SerializerCache var4);

    public abstract SerializationContextExt createContext(SerializationConfig var1, GeneratorSettings var2);

    protected SerializerCache _defaultCache() {
        return new SerializerCache();
    }

    public int cachedSerializersCount() {
        return this._cache.size();
    }

    public void flushCachedSerializers() {
        this._cache.flush();
    }

    public static class DefaultImpl
    extends SerializationContexts {
        private static final long serialVersionUID = 3L;

        public DefaultImpl() {
            super(null, null, null);
        }

        public DefaultImpl(TokenStreamFactory tsf, SerializerFactory serializerFactory, SerializerCache cache) {
            super(tsf, serializerFactory, cache);
        }

        @Override
        public SerializationContexts forMapper(Object mapper, TokenStreamFactory tsf, SerializerFactory serializerFactory, SerializerCache cache) {
            return new DefaultImpl(tsf, serializerFactory, cache);
        }

        @Override
        public SerializationContextExt createContext(SerializationConfig config, GeneratorSettings genSettings) {
            return new SerializationContextExt.Impl(this._streamFactory, config, genSettings, this._serializerFactory, this._cache);
        }
    }
}

