/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jdk;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicLongDeserializer
extends StdScalarDeserializer<AtomicLong> {
    public AtomicLongDeserializer() {
        super(AtomicLong.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) {
        return new AtomicLong();
    }

    @Override
    public AtomicLong deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.isExpectedNumberIntToken()) {
            return new AtomicLong(p.getLongValue());
        }
        Long L = this._parseLong(p, ctxt, AtomicLong.class);
        return L == null ? null : new AtomicLong(L.intValue());
    }
}

