/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateBasedDeserializer<T>
extends StdScalarDeserializer<T> {
    protected final DateFormat _customFormat;
    protected final String _formatString;

    protected DateBasedDeserializer(Class<?> clz) {
        super(clz);
        this._customFormat = null;
        this._formatString = null;
    }

    protected DateBasedDeserializer(DateBasedDeserializer<T> base, DateFormat format, String formatStr) {
        super(base._valueClass);
        this._customFormat = format;
        this._formatString = formatStr;
    }

    protected abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

    @Override
    public LogicalType logicalType() {
        return LogicalType.DateTime;
    }

    @Override
    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        if (format != null) {
            TimeZone tz = format.getTimeZone();
            Boolean lenient = format.getLenient();
            if (format.hasPattern()) {
                String pattern = format.getPattern();
                Locale loc = format.hasLocale() ? format.getLocale() : ctxt.getLocale();
                SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
                if (tz == null) {
                    tz = ctxt.getTimeZone();
                }
                df.setTimeZone(tz);
                if (lenient != null) {
                    df.setLenient(lenient);
                }
                return this.withDateFormat(df, pattern);
            }
            if (tz != null) {
                DateFormat df = ctxt.getConfig().getDateFormat();
                if (df.getClass() == StdDateFormat.class) {
                    Locale loc = format.hasLocale() ? format.getLocale() : ctxt.getLocale();
                    StdDateFormat std = (StdDateFormat)df;
                    std = std.withTimeZone(tz);
                    std = std.withLocale(loc);
                    if (lenient != null) {
                        std = std.withLenient(lenient);
                    }
                    df = std;
                } else {
                    df = (DateFormat)df.clone();
                    df.setTimeZone(tz);
                    if (lenient != null) {
                        df.setLenient(lenient);
                    }
                }
                return this.withDateFormat(df, this._formatString);
            }
            if (lenient != null) {
                DateFormat df = ctxt.getConfig().getDateFormat();
                String pattern = this._formatString;
                if (df.getClass() == StdDateFormat.class) {
                    StdDateFormat std = (StdDateFormat)df;
                    std = std.withLenient(lenient);
                    df = std;
                    pattern = std.toPattern();
                } else {
                    df = (DateFormat)df.clone();
                    df.setLenient(lenient);
                    if (df instanceof SimpleDateFormat) {
                        ((SimpleDateFormat)df).toPattern();
                    }
                }
                if (pattern == null) {
                    pattern = "[unknown]";
                }
                return this.withDateFormat(df, pattern);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Date _parseDate(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._customFormat != null && p.hasToken(JsonToken.VALUE_STRING)) {
            String str = p.getText().trim();
            if (str.isEmpty()) {
                CoercionAction act = this._checkFromStringCoercion(ctxt, str);
                switch (act) {
                    case AsEmpty: {
                        return new Date(0L);
                    }
                }
                return null;
            }
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                try {
                    return this._customFormat.parse(str);
                }
                catch (ParseException e) {
                    return (Date)ctxt.handleWeirdStringValue(this.handledType(), str, "expected format \"%s\"", this._formatString);
                }
            }
        }
        return super._parseDate(p, ctxt);
    }
}

