/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jdk;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.Currency;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class JDKFromStringDeserializer
extends FromStringDeserializer<Object> {
    public static final int STD_FILE = 1;
    public static final int STD_URL = 2;
    public static final int STD_URI = 3;
    public static final int STD_PATH = 4;
    public static final int STD_CLASS = 5;
    public static final int STD_JAVA_TYPE = 6;
    public static final int STD_CURRENCY = 7;
    public static final int STD_PATTERN = 8;
    public static final int STD_LOCALE = 9;
    public static final int STD_CHARSET = 10;
    public static final int STD_TIME_ZONE = 11;
    public static final int STD_INET_ADDRESS = 12;
    public static final int STD_INET_SOCKET_ADDRESS = 13;
    protected final int _kind;

    public static Class<?>[] types() {
        return new Class[]{File.class, URL.class, URI.class, Path.class, Class.class, JavaType.class, Currency.class, Pattern.class, Locale.class, Charset.class, TimeZone.class, InetAddress.class, InetSocketAddress.class, StringBuilder.class};
    }

    protected JDKFromStringDeserializer(Class<?> valueType, int kind) {
        super(valueType);
        this._kind = kind;
    }

    public static JDKFromStringDeserializer findDeserializer(Class<?> rawType) {
        int kind = 0;
        if (rawType == File.class) {
            kind = 1;
        } else if (rawType == URL.class) {
            kind = 2;
        } else if (rawType == URI.class) {
            kind = 3;
        } else if (rawType == Path.class) {
            kind = 4;
        } else if (rawType == Class.class) {
            kind = 5;
        } else if (rawType == JavaType.class) {
            kind = 6;
        } else if (rawType == Currency.class) {
            kind = 7;
        } else if (rawType == Pattern.class) {
            kind = 8;
        } else if (rawType == Locale.class) {
            kind = 9;
        } else if (rawType == Charset.class) {
            kind = 10;
        } else if (rawType == TimeZone.class) {
            kind = 11;
        } else if (rawType == InetAddress.class) {
            kind = 12;
        } else if (rawType == InetSocketAddress.class) {
            kind = 13;
        } else {
            if (rawType == StringBuilder.class) {
                return new StringBuilderDeserializer();
            }
            return null;
        }
        return new JDKFromStringDeserializer(rawType, kind);
    }

    @Override
    public Object _deserialize(String value, DeserializationContext ctxt) throws JacksonException, MalformedURLException, UnknownHostException {
        switch (this._kind) {
            case 1: {
                return new File(value);
            }
            case 2: {
                return new URL(value);
            }
            case 3: {
                return URI.create(value);
            }
            case 4: {
                return NioPathHelper.deserialize(ctxt, value);
            }
            case 5: {
                try {
                    return ctxt.findClass(value);
                }
                catch (Exception e) {
                    return ctxt.handleInstantiationProblem(this._valueClass, value, ClassUtil.getRootCause(e));
                }
            }
            case 6: {
                return ctxt.getTypeFactory().constructFromCanonical(value);
            }
            case 7: {
                return Currency.getInstance(value);
            }
            case 8: {
                return Pattern.compile(value);
            }
            case 9: {
                int ix = this._firstHyphenOrUnderscore(value);
                if (ix < 0) {
                    return new Locale(value);
                }
                String first = value.substring(0, ix);
                if ((ix = this._firstHyphenOrUnderscore(value = value.substring(ix + 1))) < 0) {
                    return new Locale(first, value);
                }
                String second = value.substring(0, ix);
                return new Locale(first, second, value.substring(ix + 1));
            }
            case 10: {
                return Charset.forName(value);
            }
            case 11: {
                return TimeZone.getTimeZone(value);
            }
            case 12: {
                return InetAddress.getByName(value);
            }
            case 13: {
                if (value.startsWith("[")) {
                    int i = value.lastIndexOf(93);
                    if (i == -1) {
                        throw new InvalidFormatException(ctxt.getParser(), "Bracketed IPv6 address must contain closing bracket", value, InetSocketAddress.class);
                    }
                    int j = value.indexOf(58, i);
                    int port = j > -1 ? Integer.parseInt(value.substring(j + 1)) : 0;
                    return new InetSocketAddress(value.substring(0, i + 1), port);
                }
                int ix = value.indexOf(58);
                if (ix >= 0 && value.indexOf(58, ix + 1) < 0) {
                    int port = Integer.parseInt(value.substring(ix + 1));
                    return new InetSocketAddress(value.substring(0, ix), port);
                }
                return new InetSocketAddress(value, 0);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) {
        switch (this._kind) {
            case 3: {
                return URI.create("");
            }
            case 9: {
                return Locale.ROOT;
            }
        }
        return super.getEmptyValue(ctxt);
    }

    @Override
    protected Object _deserializeFromEmptyStringDefault(DeserializationContext ctxt) throws JacksonException {
        return this.getEmptyValue(ctxt);
    }

    protected int _firstHyphenOrUnderscore(String str) {
        int end = str.length();
        for (int i = 0; i < end; ++i) {
            char c = str.charAt(i);
            if (c != '_' && c != '-') continue;
            return i;
        }
        return -1;
    }

    private static class NioPathHelper {
        private static final boolean areWindowsFilePathsSupported;

        private NioPathHelper() {
        }

        public static Path deserialize(DeserializationContext ctxt, String value) throws JacksonException {
            URI uri;
            if (value.indexOf(58) < 0) {
                return Paths.get(value, new String[0]);
            }
            if (areWindowsFilePathsSupported && value.length() >= 2 && Character.isLetter(value.charAt(0)) && value.charAt(1) == ':') {
                return Paths.get(value, new String[0]);
            }
            try {
                uri = new URI(value);
            }
            catch (URISyntaxException e) {
                return (Path)ctxt.handleInstantiationProblem(Path.class, value, e);
            }
            try {
                return Paths.get(uri);
            }
            catch (FileSystemNotFoundException cause) {
                try {
                    String scheme = uri.getScheme();
                    for (FileSystemProvider provider : ServiceLoader.load(FileSystemProvider.class)) {
                        if (!provider.getScheme().equalsIgnoreCase(scheme)) continue;
                        return provider.getPath(uri);
                    }
                    return (Path)ctxt.handleInstantiationProblem(Path.class, value, cause);
                }
                catch (Throwable e) {
                    e.addSuppressed(cause);
                    return (Path)ctxt.handleInstantiationProblem(Path.class, value, e);
                }
            }
            catch (Throwable e) {
                return (Path)ctxt.handleInstantiationProblem(Path.class, value, e);
            }
        }

        static {
            boolean isWindowsRootFound = false;
            for (File file : File.listRoots()) {
                String path = file.getPath();
                if (path.length() < 2 || !Character.isLetter(path.charAt(0)) || path.charAt(1) != ':') continue;
                isWindowsRootFound = true;
                break;
            }
            areWindowsFilePathsSupported = isWindowsRootFound;
        }
    }

    static class StringBuilderDeserializer
    extends JDKFromStringDeserializer {
        public StringBuilderDeserializer() {
            super(StringBuilder.class, -1);
        }

        @Override
        public LogicalType logicalType() {
            return LogicalType.Textual;
        }

        @Override
        public Object getEmptyValue(DeserializationContext ctxt) {
            return new StringBuilder();
        }

        @Override
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
            String text = p.getValueAsString();
            if (text != null) {
                return this._deserialize(text, ctxt);
            }
            return super.deserialize(p, ctxt);
        }

        @Override
        public Object _deserialize(String value, DeserializationContext ctxt) {
            return new StringBuilder(value);
        }
    }
}

