/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jdk;

import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.deser.jdk.AtomicBooleanDeserializer;
import com.fasterxml.jackson.databind.deser.jdk.AtomicIntegerDeserializer;
import com.fasterxml.jackson.databind.deser.jdk.AtomicLongDeserializer;
import com.fasterxml.jackson.databind.deser.jdk.ByteBufferDeserializer;
import com.fasterxml.jackson.databind.deser.jdk.JDKFromStringDeserializer;
import com.fasterxml.jackson.databind.deser.jdk.StackTraceElementDeserializer;
import com.fasterxml.jackson.databind.deser.jdk.UUIDDeserializer;
import com.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JDKMiscDeserializers {
    private static final HashSet<String> _classNames = new HashSet();

    public static ValueDeserializer<?> find(Class<?> rawType, String clsName) {
        if (_classNames.contains(clsName)) {
            JDKFromStringDeserializer d = JDKFromStringDeserializer.findDeserializer(rawType);
            if (d != null) {
                return d;
            }
            if (rawType == UUID.class) {
                return new UUIDDeserializer();
            }
            if (rawType == StackTraceElement.class) {
                return new StackTraceElementDeserializer();
            }
            if (rawType == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (rawType == AtomicInteger.class) {
                return new AtomicIntegerDeserializer();
            }
            if (rawType == AtomicLong.class) {
                return new AtomicLongDeserializer();
            }
            if (rawType == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
            if (rawType == Void.class) {
                return NullifyingDeserializer.instance;
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> rawType) {
        return _classNames.contains(rawType.getName());
    }

    static {
        _classNames.add(UUID.class.getName());
        _classNames.add(AtomicBoolean.class.getName());
        _classNames.add(AtomicInteger.class.getName());
        _classNames.add(AtomicLong.class.getName());
        _classNames.add(StackTraceElement.class.getName());
        _classNames.add(ByteBuffer.class.getName());
        _classNames.add(Void.class.getName());
        for (Class<?> cls : JDKFromStringDeserializer.types()) {
            _classNames.add(cls.getName());
        }
    }
}

