/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jdk;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public class StackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    public StackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_OBJECT) {
            String className = "";
            String methodName = "";
            String fileName = "";
            String moduleName = null;
            String moduleVersion = null;
            String classLoaderName = null;
            int lineNumber = -1;
            while ((t = p.nextValue()) != JsonToken.END_OBJECT) {
                String propName;
                switch (propName = p.currentName()) {
                    case "className": {
                        className = p.getText();
                        break;
                    }
                    case "classLoaderName": {
                        classLoaderName = p.getText();
                        break;
                    }
                    case "fileName": {
                        fileName = p.getText();
                        break;
                    }
                    case "lineNumber": {
                        if (t.isNumeric()) {
                            lineNumber = p.getIntValue();
                            break;
                        }
                        lineNumber = this._parseIntPrimitive(p, ctxt);
                        break;
                    }
                    case "methodName": {
                        methodName = p.getText();
                        break;
                    }
                    case "moduleName": {
                        moduleName = p.getText();
                        break;
                    }
                    case "moduleVersion": {
                        moduleVersion = p.getText();
                        break;
                    }
                    case "nativeMethod": 
                    case "declaringClass": 
                    case "format": {
                        break;
                    }
                    default: {
                        this.handleUnknownProperty(p, ctxt, this._valueClass, propName);
                    }
                }
                p.skipChildren();
            }
            return this.constructValue(ctxt, className, methodName, fileName, lineNumber, moduleName, moduleVersion, classLoaderName);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            StackTraceElement value = this.deserialize(p, ctxt);
            if (p.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return value;
        }
        return (StackTraceElement)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    protected StackTraceElement constructValue(DeserializationContext ctxt, String className, String methodName, String fileName, int lineNumber, String moduleName, String moduleVersion, String classLoaderName) {
        return new StackTraceElement(className, methodName, fileName, lineNumber);
    }
}

