/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jdk;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.bean.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.bean.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.fasterxml.jackson.databind.util.NameTransformer;

public class ThrowableDeserializer
extends BeanDeserializer {
    protected static final String PROP_NAME_MESSAGE = "message";

    public ThrowableDeserializer(BeanDeserializer baseDeserializer) {
        super(baseDeserializer);
        this._vanillaProcessing = false;
    }

    protected ThrowableDeserializer(BeanDeserializer src, UnwrappedPropertyHandler unwrapHandler, BeanPropertyMap renamedProperties, boolean ignoreAllUnknown) {
        super(src, unwrapHandler, renamedProperties, ignoreAllUnknown);
    }

    @Override
    public ValueDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer transformer) {
        if (this.getClass() != ThrowableDeserializer.class) {
            return this;
        }
        UnwrappedPropertyHandler uwHandler = this._unwrappedPropertyHandler;
        if (uwHandler != null) {
            uwHandler = uwHandler.renameAll(ctxt, transformer);
        }
        return new ThrowableDeserializer(this, uwHandler, this._beanProperties.renameAll(ctxt, transformer), true);
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        int len;
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(p, ctxt);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (this._beanType.isAbstract()) {
            return ctxt.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), p, "abstract type (need to add/enable type information?)", new Object[0]);
        }
        boolean hasStringCreator = this._valueInstantiator.canCreateFromString();
        boolean hasDefaultCtor = this._valueInstantiator.canCreateUsingDefault();
        if (!hasStringCreator && !hasDefaultCtor) {
            return ctxt.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), p, "Throwable needs a default constructor, a single-String-arg constructor; or explicit @JsonCreator", new Object[0]);
        }
        Object throwable = null;
        Object[] pending = null;
        int pendingIx = 0;
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propsByIndex[ix];
                if (throwable != null) {
                    prop.deserializeAndSet(p, ctxt, throwable);
                } else {
                    if (pending == null) {
                        len = this._beanProperties.size();
                        pending = new Object[len + len];
                    }
                    pending[pendingIx++] = prop;
                    pending[pendingIx++] = prop.deserialize(p, ctxt);
                }
            } else {
                if (ix != -2) {
                    if (ix == -1) break;
                    return this._handleUnexpectedWithin(p, ctxt, throwable);
                }
                String propName = p.currentName();
                p.nextToken();
                boolean isMessage = PROP_NAME_MESSAGE.equals(propName);
                if (isMessage && hasStringCreator) {
                    throwable = this._valueInstantiator.createFromString(ctxt, p.getValueAsString());
                    if (pending != null) {
                        int len2 = pendingIx;
                        for (int i = 0; i < len2; i += 2) {
                            SettableBeanProperty prop = (SettableBeanProperty)pending[i];
                            prop.set(throwable, pending[i + 1]);
                        }
                        pending = null;
                    }
                } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    p.skipChildren();
                } else if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(p, ctxt, throwable, propName);
                } else {
                    this.handleUnknownProperty(p, ctxt, throwable, propName);
                }
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
        if (throwable == null) {
            throwable = hasStringCreator ? this._valueInstantiator.createFromString(ctxt, null) : this._valueInstantiator.createUsingDefault(ctxt);
            if (pending != null) {
                len = pendingIx;
                for (int i = 0; i < len; i += 2) {
                    SettableBeanProperty prop = (SettableBeanProperty)pending[i];
                    prop.set(throwable, pending[i + 1]);
                }
            }
        }
        return throwable;
    }
}

