/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import java.util.Collection;

public abstract class DelegatingDeserializer
extends StdDeserializer<Object> {
    protected final ValueDeserializer<?> _delegatee;

    public DelegatingDeserializer(ValueDeserializer<?> d) {
        super(d.handledType());
        this._delegatee = d;
    }

    protected abstract ValueDeserializer<?> newDelegatingInstance(ValueDeserializer<?> var1);

    @Override
    public void resolve(DeserializationContext ctxt) {
        if (this._delegatee != null) {
            this._delegatee.resolve(ctxt);
        }
    }

    @Override
    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType vt = ctxt.constructType(this._delegatee.handledType());
        ValueDeserializer<?> del = ctxt.handleSecondaryContextualization(this._delegatee, property, vt);
        if (del == this._delegatee) {
            return this;
        }
        return this.newDelegatingInstance(del);
    }

    @Override
    public SettableBeanProperty findBackReference(String logicalName) {
        return this._delegatee.findBackReference(logicalName);
    }

    @Override
    public ValueDeserializer<?> replaceDelegatee(ValueDeserializer<?> delegatee) {
        if (delegatee == this._delegatee) {
            return this;
        }
        return this.newDelegatingInstance(delegatee);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this._delegatee.deserialize(p, ctxt);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object intoValue) throws JacksonException {
        return this._delegatee.deserialize(p, ctxt, intoValue);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        return this._delegatee.deserializeWithType(p, ctxt, typeDeserializer);
    }

    @Override
    public ValueDeserializer<?> getDelegatee() {
        return this._delegatee;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return this._delegatee.getNullAccessPattern();
    }

    @Override
    public Object getNullValue(DeserializationContext ctxt) {
        return this._delegatee.getNullValue(ctxt);
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) {
        return this._delegatee.getEmptyValue(ctxt);
    }

    @Override
    public LogicalType logicalType() {
        return this._delegatee.logicalType();
    }

    @Override
    public Collection<Object> getKnownPropertyNames() {
        return this._delegatee.getKnownPropertyNames();
    }

    @Override
    public ObjectIdReader getObjectIdReader(DeserializationContext ctxt) {
        return this._delegatee.getObjectIdReader(ctxt);
    }

    @Override
    public boolean isCachable() {
        return this._delegatee != null && this._delegatee.isCachable();
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return this._delegatee.supportsUpdate(config);
    }
}

