/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.net.MalformedURLException;
import java.net.UnknownHostException;

public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    protected FromStringDeserializer(Class<?> vc) {
        super(vc);
    }

    protected FromStringDeserializer(JavaType type) {
        super(type);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        String text = p.getValueAsString();
        if (text == null) {
            JsonToken t = p.currentToken();
            if (t != JsonToken.START_OBJECT) {
                return (T)this._deserializeFromOther(p, ctxt, t);
            }
            text = ctxt.extractScalarFromObject(p, this, this._valueClass);
        }
        if (text.isEmpty() || (text = text.trim()).isEmpty()) {
            return (T)this._deserializeFromEmptyString(ctxt);
        }
        Exception cause = null;
        try {
            return this._deserialize(text, ctxt);
        }
        catch (IllegalArgumentException | MalformedURLException | UnknownHostException e) {
            cause = e;
            String msg = "not a valid textual representation";
            String m2 = cause.getMessage();
            if (m2 != null) {
                msg = msg + ", problem: " + m2;
            }
            throw ctxt.weirdStringException(text, this._valueClass, msg).withCause(cause);
        }
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2) throws JacksonException, MalformedURLException, UnknownHostException;

    protected Object _deserializeFromOther(JsonParser p, DeserializationContext ctxt, JsonToken t) throws JacksonException {
        if (t == JsonToken.START_ARRAY) {
            return this._deserializeFromArray(p, ctxt);
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = p.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(ob.getClass())) {
                return ob;
            }
            return this._deserializeEmbedded(ob, ctxt);
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    protected T _deserializeEmbedded(Object ob, DeserializationContext ctxt) throws JacksonException {
        ctxt.reportInputMismatch(this, "Don't know how to convert embedded Object of type %s into %s", ClassUtil.classNameOf(ob), this._valueClass.getName());
        return null;
    }

    protected Object _deserializeFromEmptyString(DeserializationContext ctxt) throws JacksonException {
        CoercionAction act = ctxt.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.EmptyString);
        if (act == CoercionAction.Fail) {
            ctxt.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", this._coercedTypeDesc());
        }
        if (act == CoercionAction.AsNull) {
            return this.getNullValue(ctxt);
        }
        if (act == CoercionAction.AsEmpty) {
            return this.getEmptyValue(ctxt);
        }
        return this._deserializeFromEmptyStringDefault(ctxt);
    }

    protected Object _deserializeFromEmptyStringDefault(DeserializationContext ctxt) throws JacksonException {
        return this.getNullValue(ctxt);
    }
}

