/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.ext.CoreXMLDeserializers;
import com.fasterxml.jackson.databind.ext.DOMDeserializer;
import com.fasterxml.jackson.databind.ext.DOMSerializer;
import com.fasterxml.jackson.databind.ext.XMLGregorianCalendarSerializer;
import com.fasterxml.jackson.databind.ser.jdk.JavaUtilDateSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OptionalHandlerFactory {
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final Class<?> CLASS_DOM_NODE = Node.class;
    private static final Class<?> CLASS_DOM_DOCUMENT = Document.class;
    public static final OptionalHandlerFactory instance = new OptionalHandlerFactory();
    private final Map<String, String> _sqlDeserializers = new HashMap<String, String>();
    private final Map<String, Object> _sqlSerializers;
    private static final String CLS_NAME_JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
    private static final String CLS_NAME_JAVA_SQL_DATE = "java.sql.Date";
    private static final String CLS_NAME_JAVA_SQL_TIME = "java.sql.Time";
    private static final String CLS_NAME_JAVA_SQL_BLOB = "java.sql.Blob";
    private static final String CLS_NAME_JAVA_SQL_SERIALBLOB = "javax.sql.rowset.serial.SerialBlob";

    protected OptionalHandlerFactory() {
        this._sqlDeserializers.put(CLS_NAME_JAVA_SQL_DATE, "com.fasterxml.jackson.databind.ext.sql.JavaSqlDateDeserializer");
        this._sqlDeserializers.put(CLS_NAME_JAVA_SQL_TIMESTAMP, "com.fasterxml.jackson.databind.ext.sql.JavaSqlTimestampDeserializer");
        this._sqlSerializers = new HashMap<String, Object>();
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_TIMESTAMP, JavaUtilDateSerializer.instance);
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_DATE, "com.fasterxml.jackson.databind.ext.sql.JavaSqlDateSerializer");
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_TIME, "com.fasterxml.jackson.databind.ext.sql.JavaSqlTimeSerializer");
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_BLOB, "com.fasterxml.jackson.databind.ext.sql.JavaSqlBlobSerializer");
        this._sqlSerializers.put(CLS_NAME_JAVA_SQL_SERIALBLOB, "com.fasterxml.jackson.databind.ext.sql.JavaSqlBlobSerializer");
    }

    public ValueSerializer<?> findSerializer(SerializationConfig config, JavaType type) {
        Class<?> rawType = type.getRawClass();
        if (this._IsXOfY(rawType, CLASS_DOM_NODE)) {
            return new DOMSerializer();
        }
        String className = rawType.getName();
        Object sqlHandler = this._sqlSerializers.get(className);
        if (sqlHandler != null) {
            if (sqlHandler instanceof ValueSerializer) {
                return (ValueSerializer)sqlHandler;
            }
            return (ValueSerializer)this.instantiate((String)sqlHandler, type);
        }
        if (className.startsWith(PACKAGE_PREFIX_JAVAX_XML) || this.hasSuperClassStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            if (Duration.class.isAssignableFrom(rawType) || QName.class.isAssignableFrom(rawType)) {
                return ToStringSerializer.instance;
            }
            if (XMLGregorianCalendar.class.isAssignableFrom(rawType)) {
                return XMLGregorianCalendarSerializer.instance;
            }
        }
        return null;
    }

    public ValueDeserializer<?> findDeserializer(DeserializationConfig config, JavaType type) {
        Class<?> rawType = type.getRawClass();
        if (this._IsXOfY(rawType, CLASS_DOM_NODE)) {
            return new DOMDeserializer.NodeDeserializer();
        }
        if (this._IsXOfY(rawType, CLASS_DOM_DOCUMENT)) {
            return new DOMDeserializer.DocumentDeserializer();
        }
        String className = rawType.getName();
        String deserName = this._sqlDeserializers.get(className);
        if (deserName != null) {
            return (ValueDeserializer)this.instantiate(deserName, type);
        }
        if (className.startsWith(PACKAGE_PREFIX_JAVAX_XML) || this.hasSuperClassStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            return CoreXMLDeserializers.findBeanDeserializer(config, type);
        }
        return null;
    }

    public boolean hasDeserializerFor(Class<?> valueType) {
        if (this._IsXOfY(valueType, CLASS_DOM_NODE)) {
            return true;
        }
        if (this._IsXOfY(valueType, CLASS_DOM_DOCUMENT)) {
            return true;
        }
        String className = valueType.getName();
        if (className.startsWith(PACKAGE_PREFIX_JAVAX_XML) || this.hasSuperClassStartingWith(valueType, PACKAGE_PREFIX_JAVAX_XML)) {
            return CoreXMLDeserializers.hasDeserializerFor(valueType);
        }
        return this._sqlDeserializers.containsKey(className);
    }

    private boolean _IsXOfY(Class<?> valueType, Class<?> expType) {
        return expType != null && expType.isAssignableFrom(valueType);
    }

    private Object instantiate(String className, JavaType valueType) {
        try {
            return this.instantiate(Class.forName(className), valueType);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to find class `" + className + "` for handling values of type " + ClassUtil.getTypeDescription(valueType) + ", problem: (" + e.getClass().getName() + ") " + e.getMessage());
        }
    }

    private Object instantiate(Class<?> handlerClass, JavaType valueType) {
        try {
            return ClassUtil.createInstance(handlerClass, false);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to create instance of `" + handlerClass.getName() + "` for handling values of type " + ClassUtil.getTypeDescription(valueType) + ", problem: (" + e.getClass().getName() + ") " + e.getMessage());
        }
    }

    private boolean hasSuperClassStartingWith(Class<?> rawType, String prefix) {
        for (Class<?> supertype = rawType.getSuperclass(); supertype != null; supertype = supertype.getSuperclass()) {
            if (supertype == Object.class) {
                return false;
            }
            if (!supertype.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

