/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext.jdk8;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.util.stream.IntStream;

public class IntStreamSerializer
extends StdSerializer<IntStream> {
    public static final IntStreamSerializer INSTANCE = new IntStreamSerializer();

    private IntStreamSerializer() {
        super(IntStream.class);
    }

    @Override
    public void serialize(IntStream stream, JsonGenerator g, SerializerProvider ctxt) throws JacksonException {
        try (IntStream is = stream;){
            g.writeStartArray((Object)is);
            is.forEach(value -> g.writeNumber(value));
            g.writeEndArray();
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, (Object)stream, g.streamWriteContext().getCurrentIndex());
        }
    }
}

