/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext.jdk8;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.util.stream.Stream;

public class Jdk8StreamSerializer
extends StdSerializer<Stream<?>> {
    private final JavaType elemType;
    private final transient ValueSerializer<Object> elemSerializer;

    public Jdk8StreamSerializer(JavaType streamType, JavaType elemType) {
        this(streamType, elemType, null);
    }

    public Jdk8StreamSerializer(JavaType streamType, JavaType elemType, ValueSerializer<Object> elemSerializer) {
        super(streamType);
        this.elemType = elemType;
        this.elemSerializer = elemSerializer;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) {
        if (!this.elemType.hasRawClass(Object.class) && (provider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this.elemType.isFinal())) {
            return new Jdk8StreamSerializer(provider.getTypeFactory().constructParametricType(Stream.class, this.elemType), this.elemType, provider.findContentValueSerializer(this.elemType, property));
        }
        return this;
    }

    @Override
    public void serialize(Stream<?> stream, JsonGenerator g, SerializerProvider ctxt) throws JacksonException {
        try (Stream<?> s = stream;){
            g.writeStartArray(s);
            s.forEach(elem -> {
                if (this.elemSerializer == null) {
                    ctxt.writeValue(g, elem);
                } else {
                    this.elemSerializer.serialize(elem, g, ctxt);
                }
            });
            g.writeEndArray();
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, stream, g.streamWriteContext().getCurrentIndex());
        }
    }
}

