/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext.jdk8;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.ext.jdk8.BaseScalarOptionalDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.util.OptionalDouble;

public class OptionalDoubleDeserializer
extends BaseScalarOptionalDeserializer<OptionalDouble> {
    static final OptionalDoubleDeserializer INSTANCE = new OptionalDoubleDeserializer();

    public OptionalDoubleDeserializer() {
        super(OptionalDouble.class, OptionalDouble.empty());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Float;
    }

    @Override
    public OptionalDouble deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return OptionalDouble.of(p.getDoubleValue());
        }
        switch (p.currentTokenId()) {
            case 6: {
                String text = p.getText();
                Double specialValue = this._checkDoubleSpecialValue(text);
                if (specialValue != null) {
                    return OptionalDouble.of(specialValue);
                }
                CoercionAction act = this._checkFromStringCoercion(ctxt, text);
                if (act == CoercionAction.AsNull) {
                    return (OptionalDouble)this.getNullValue(ctxt);
                }
                if (act == CoercionAction.AsEmpty) {
                    return (OptionalDouble)this.getEmptyValue(ctxt);
                }
                if (this._checkTextualNull(ctxt, text = text.trim())) {
                    return (OptionalDouble)this._empty;
                }
                return OptionalDouble.of(this._parseDoublePrimitive(ctxt, text));
            }
            case 7: {
                return OptionalDouble.of(p.getDoubleValue());
            }
            case 11: {
                return (OptionalDouble)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                OptionalDouble parsed = this.deserialize(p, ctxt);
                this._verifyEndArrayForSingle(p, ctxt);
                return parsed;
            }
        }
        return (OptionalDouble)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }
}

