/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnnotationIntrospectorPair
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final AnnotationIntrospector _primary;
    protected final AnnotationIntrospector _secondary;

    public AnnotationIntrospectorPair(AnnotationIntrospector p, AnnotationIntrospector s) {
        this._primary = p;
        this._secondary = s;
    }

    @Override
    public Version version() {
        return this._primary.version();
    }

    public static AnnotationIntrospector create(AnnotationIntrospector primary, AnnotationIntrospector secondary) {
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        return new AnnotationIntrospectorPair(primary, secondary);
    }

    @Override
    public Collection<AnnotationIntrospector> allIntrospectors() {
        return this.allIntrospectors(new ArrayList<AnnotationIntrospector>());
    }

    @Override
    public Collection<AnnotationIntrospector> allIntrospectors(Collection<AnnotationIntrospector> result) {
        this._primary.allIntrospectors(result);
        this._secondary.allIntrospectors(result);
        return result;
    }

    @Override
    public boolean isAnnotationBundle(Annotation ann) {
        return this._primary.isAnnotationBundle(ann) || this._secondary.isAnnotationBundle(ann);
    }

    @Override
    public PropertyName findRootName(MapperConfig<?> config, AnnotatedClass ac) {
        PropertyName name1 = this._primary.findRootName(config, ac);
        if (name1 == null) {
            return this._secondary.findRootName(config, ac);
        }
        if (name1.hasSimpleName()) {
            return name1;
        }
        PropertyName name2 = this._secondary.findRootName(config, ac);
        return name2 == null ? name1 : name2;
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> config, Annotated a) {
        JsonIgnoreProperties.Value v2 = this._secondary.findPropertyIgnoralByName(config, a);
        JsonIgnoreProperties.Value v1 = this._primary.findPropertyIgnoralByName(config, a);
        return v2 == null ? v1 : v2.withOverrides(v1);
    }

    @Override
    public JsonIncludeProperties.Value findPropertyInclusionByName(MapperConfig<?> config, Annotated a) {
        JsonIncludeProperties.Value v2 = this._secondary.findPropertyInclusionByName(config, a);
        JsonIncludeProperties.Value v1 = this._primary.findPropertyInclusionByName(config, a);
        return v2 == null ? v1 : v2.withOverrides(v1);
    }

    @Override
    public Boolean isIgnorableType(MapperConfig<?> config, AnnotatedClass ac) {
        Boolean result = this._primary.isIgnorableType(config, ac);
        if (result == null) {
            result = this._secondary.isIgnorableType(config, ac);
        }
        return result;
    }

    @Override
    public Object findFilterId(MapperConfig<?> config, Annotated ann) {
        Object id = this._primary.findFilterId(config, ann);
        if (id == null) {
            id = this._secondary.findFilterId(config, ann);
        }
        return id;
    }

    @Override
    public Object findNamingStrategy(MapperConfig<?> config, AnnotatedClass ac) {
        Object str = this._primary.findNamingStrategy(config, ac);
        if (str == null) {
            str = this._secondary.findNamingStrategy(config, ac);
        }
        return str;
    }

    @Override
    public String findClassDescription(MapperConfig<?> config, AnnotatedClass ac) {
        String str = this._primary.findClassDescription(config, ac);
        if (str == null || str.isEmpty()) {
            str = this._secondary.findClassDescription(config, ac);
        }
        return str;
    }

    @Override
    public VisibilityChecker findAutoDetectVisibility(MapperConfig<?> config, AnnotatedClass ac, VisibilityChecker checker) {
        checker = this._secondary.findAutoDetectVisibility(config, ac, checker);
        return this._primary.findAutoDetectVisibility(config, ac, checker);
    }

    @Override
    public JsonTypeInfo.Value findPolymorphicTypeInfo(MapperConfig<?> config, Annotated ann) {
        JsonTypeInfo.Value v = this._primary.findPolymorphicTypeInfo(config, ann);
        if (v == null) {
            v = this._secondary.findPolymorphicTypeInfo(config, ann);
        }
        return v;
    }

    @Override
    public Object findTypeResolverBuilder(MapperConfig<?> config, Annotated ann) {
        Object b = this._primary.findTypeResolverBuilder(config, ann);
        if (b == null) {
            b = this._secondary.findTypeResolverBuilder(config, ann);
        }
        return b;
    }

    @Override
    public Object findTypeIdResolver(MapperConfig<?> config, Annotated ann) {
        Object b = this._primary.findTypeIdResolver(config, ann);
        if (b == null) {
            b = this._secondary.findTypeIdResolver(config, ann);
        }
        return b;
    }

    @Override
    public List<NamedType> findSubtypes(MapperConfig<?> config, Annotated a) {
        List<NamedType> types1 = this._primary.findSubtypes(config, a);
        List<NamedType> types2 = this._secondary.findSubtypes(config, a);
        if (types1 == null || types1.isEmpty()) {
            return types2;
        }
        if (types2 == null || types2.isEmpty()) {
            return types1;
        }
        ArrayList<NamedType> result = new ArrayList<NamedType>(types1.size() + types2.size());
        result.addAll(types1);
        result.addAll(types2);
        return result;
    }

    @Override
    public String findTypeName(MapperConfig<?> config, AnnotatedClass ac) {
        String name = this._primary.findTypeName(config, ac);
        if (name == null || name.length() == 0) {
            name = this._secondary.findTypeName(config, ac);
        }
        return name;
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(MapperConfig<?> config, AnnotatedMember member) {
        AnnotationIntrospector.ReferenceProperty r = this._primary.findReferenceType(config, member);
        return r == null ? this._secondary.findReferenceType(config, member) : r;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(MapperConfig<?> config, AnnotatedMember member) {
        NameTransformer r = this._primary.findUnwrappingNameTransformer(config, member);
        return r == null ? this._secondary.findUnwrappingNameTransformer(config, member) : r;
    }

    @Override
    public JacksonInject.Value findInjectableValue(MapperConfig<?> config, AnnotatedMember m) {
        JacksonInject.Value r = this._primary.findInjectableValue(config, m);
        return r == null ? this._secondary.findInjectableValue(config, m) : r;
    }

    @Override
    public boolean hasIgnoreMarker(MapperConfig<?> config, AnnotatedMember m) {
        return this._primary.hasIgnoreMarker(config, m) || this._secondary.hasIgnoreMarker(config, m);
    }

    @Override
    public Boolean hasRequiredMarker(MapperConfig<?> config, AnnotatedMember m) {
        Boolean r = this._primary.hasRequiredMarker(config, m);
        return r == null ? this._secondary.hasRequiredMarker(config, m) : r;
    }

    @Override
    public Object findSerializer(MapperConfig<?> config, Annotated am) {
        Object r = this._primary.findSerializer(config, am);
        if (this._isExplicitClassOrOb(r, ValueSerializer.None.class)) {
            return r;
        }
        return this._explicitClassOrOb(this._secondary.findSerializer(config, am), ValueSerializer.None.class);
    }

    @Override
    public Object findKeySerializer(MapperConfig<?> config, Annotated a) {
        Object r = this._primary.findKeySerializer(config, a);
        if (this._isExplicitClassOrOb(r, ValueSerializer.None.class)) {
            return r;
        }
        return this._explicitClassOrOb(this._secondary.findKeySerializer(config, a), ValueSerializer.None.class);
    }

    @Override
    public Object findContentSerializer(MapperConfig<?> config, Annotated a) {
        Object r = this._primary.findContentSerializer(config, a);
        if (this._isExplicitClassOrOb(r, ValueSerializer.None.class)) {
            return r;
        }
        return this._explicitClassOrOb(this._secondary.findContentSerializer(config, a), ValueSerializer.None.class);
    }

    @Override
    public Object findNullSerializer(MapperConfig<?> config, Annotated a) {
        Object r = this._primary.findNullSerializer(config, a);
        if (this._isExplicitClassOrOb(r, ValueSerializer.None.class)) {
            return r;
        }
        return this._explicitClassOrOb(this._secondary.findNullSerializer(config, a), ValueSerializer.None.class);
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> config, Annotated a) {
        JsonInclude.Value v2 = this._secondary.findPropertyInclusion(config, a);
        JsonInclude.Value v1 = this._primary.findPropertyInclusion(config, a);
        if (v2 == null) {
            return v1;
        }
        return v2.withOverrides(v1);
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(MapperConfig<?> config, Annotated a) {
        JsonSerialize.Typing r = this._primary.findSerializationTyping(config, a);
        return r == null ? this._secondary.findSerializationTyping(config, a) : r;
    }

    @Override
    public Object findSerializationConverter(MapperConfig<?> config, Annotated a) {
        Object r = this._primary.findSerializationConverter(config, a);
        return r == null ? this._secondary.findSerializationConverter(config, a) : r;
    }

    @Override
    public Object findSerializationContentConverter(MapperConfig<?> config, AnnotatedMember a) {
        Object r = this._primary.findSerializationContentConverter(config, a);
        return r == null ? this._secondary.findSerializationContentConverter(config, a) : r;
    }

    @Override
    public Class<?>[] findViews(MapperConfig<?> config, Annotated a) {
        Class<?>[] result = this._primary.findViews(config, a);
        if (result == null) {
            result = this._secondary.findViews(config, a);
        }
        return result;
    }

    @Override
    public Boolean isTypeId(MapperConfig<?> config, AnnotatedMember member) {
        Boolean b = this._primary.isTypeId(config, member);
        return b == null ? this._secondary.isTypeId(config, member) : b;
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(MapperConfig<?> config, Annotated ann) {
        ObjectIdInfo r = this._primary.findObjectIdInfo(config, ann);
        return r == null ? this._secondary.findObjectIdInfo(config, ann) : r;
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(MapperConfig<?> config, Annotated ann, ObjectIdInfo objectIdInfo) {
        objectIdInfo = this._secondary.findObjectReferenceInfo(config, ann, objectIdInfo);
        objectIdInfo = this._primary.findObjectReferenceInfo(config, ann, objectIdInfo);
        return objectIdInfo;
    }

    @Override
    public JsonFormat.Value findFormat(MapperConfig<?> config, Annotated ann) {
        JsonFormat.Value v1 = this._primary.findFormat(config, ann);
        JsonFormat.Value v2 = this._secondary.findFormat(config, ann);
        if (v2 == null) {
            return v1;
        }
        return v2.withOverrides(v1);
    }

    @Override
    public PropertyName findWrapperName(MapperConfig<?> config, Annotated ann) {
        PropertyName name2;
        PropertyName name = this._primary.findWrapperName(config, ann);
        if (name == null) {
            name = this._secondary.findWrapperName(config, ann);
        } else if (name == PropertyName.USE_DEFAULT && (name2 = this._secondary.findWrapperName(config, ann)) != null) {
            name = name2;
        }
        return name;
    }

    @Override
    public String findPropertyDefaultValue(MapperConfig<?> config, Annotated ann) {
        String str = this._primary.findPropertyDefaultValue(config, ann);
        return str == null || str.isEmpty() ? this._secondary.findPropertyDefaultValue(config, ann) : str;
    }

    @Override
    public String findPropertyDescription(MapperConfig<?> config, Annotated ann) {
        String r = this._primary.findPropertyDescription(config, ann);
        return r == null ? this._secondary.findPropertyDescription(config, ann) : r;
    }

    @Override
    public Integer findPropertyIndex(MapperConfig<?> config, Annotated ann) {
        Integer r = this._primary.findPropertyIndex(config, ann);
        return r == null ? this._secondary.findPropertyIndex(config, ann) : r;
    }

    @Override
    public String findImplicitPropertyName(MapperConfig<?> config, AnnotatedMember ann) {
        String r = this._primary.findImplicitPropertyName(config, ann);
        return r == null ? this._secondary.findImplicitPropertyName(config, ann) : r;
    }

    @Override
    public List<PropertyName> findPropertyAliases(MapperConfig<?> config, Annotated ann) {
        List<PropertyName> r = this._primary.findPropertyAliases(config, ann);
        return r == null ? this._secondary.findPropertyAliases(config, ann) : r;
    }

    @Override
    public JsonProperty.Access findPropertyAccess(MapperConfig<?> config, Annotated ann) {
        JsonProperty.Access acc = this._primary.findPropertyAccess(config, ann);
        if (acc != null && acc != JsonProperty.Access.AUTO) {
            return acc;
        }
        acc = this._secondary.findPropertyAccess(config, ann);
        if (acc != null) {
            return acc;
        }
        return JsonProperty.Access.AUTO;
    }

    @Override
    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> config, AnnotatedMethod setter1, AnnotatedMethod setter2) {
        AnnotatedMethod res = this._primary.resolveSetterConflict(config, setter1, setter2);
        if (res == null) {
            res = this._secondary.resolveSetterConflict(config, setter1, setter2);
        }
        return res;
    }

    @Override
    public PropertyName findRenameByField(MapperConfig<?> config, AnnotatedField f, PropertyName implName) {
        PropertyName n = this._secondary.findRenameByField(config, f, implName);
        if (n == null) {
            n = this._primary.findRenameByField(config, f, implName);
        }
        return n;
    }

    @Override
    public JavaType refineSerializationType(MapperConfig<?> config, Annotated a, JavaType baseType) {
        JavaType t = this._secondary.refineSerializationType(config, a, baseType);
        return this._primary.refineSerializationType(config, a, t);
    }

    @Override
    public String[] findSerializationPropertyOrder(MapperConfig<?> config, AnnotatedClass ac) {
        String[] r = this._primary.findSerializationPropertyOrder(config, ac);
        return r == null ? this._secondary.findSerializationPropertyOrder(config, ac) : r;
    }

    @Override
    public Boolean findSerializationSortAlphabetically(MapperConfig<?> config, Annotated ann) {
        Boolean r = this._primary.findSerializationSortAlphabetically(config, ann);
        return r == null ? this._secondary.findSerializationSortAlphabetically(config, ann) : r;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> config, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
        this._primary.findAndAddVirtualProperties(config, ac, properties);
        this._secondary.findAndAddVirtualProperties(config, ac, properties);
    }

    @Override
    public PropertyName findNameForSerialization(MapperConfig<?> config, Annotated a) {
        PropertyName n2;
        PropertyName n = this._primary.findNameForSerialization(config, a);
        if (n == null) {
            n = this._secondary.findNameForSerialization(config, a);
        } else if (n == PropertyName.USE_DEFAULT && (n2 = this._secondary.findNameForSerialization(config, a)) != null) {
            n = n2;
        }
        return n;
    }

    @Override
    public Boolean hasAsKey(MapperConfig<?> config, Annotated a) {
        Boolean b = this._primary.hasAsKey(config, a);
        if (b == null) {
            b = this._secondary.hasAsKey(config, a);
        }
        return b;
    }

    @Override
    public Boolean hasAsValue(MapperConfig<?> config, Annotated a) {
        Boolean b = this._primary.hasAsValue(config, a);
        if (b == null) {
            b = this._secondary.hasAsValue(config, a);
        }
        return b;
    }

    @Override
    public Boolean hasAnyGetter(MapperConfig<?> config, Annotated a) {
        Boolean b = this._primary.hasAnyGetter(config, a);
        if (b == null) {
            b = this._secondary.hasAnyGetter(config, a);
        }
        return b;
    }

    @Override
    public String[] findEnumValues(MapperConfig<?> config, Class<?> enumType, Enum<?>[] enumValues, String[] names) {
        names = this._secondary.findEnumValues(config, enumType, enumValues, names);
        names = this._primary.findEnumValues(config, enumType, enumValues, names);
        return names;
    }

    @Override
    public Enum<?> findDefaultEnumValue(MapperConfig<?> config, Class<?> enumCls) {
        Enum<?> en = this._primary.findDefaultEnumValue(config, enumCls);
        return en == null ? this._secondary.findDefaultEnumValue(config, enumCls) : en;
    }

    @Override
    public void findEnumAliases(MapperConfig<?> config, Class<?> enumType, Enum<?>[] enumValues, String[][] aliases) {
        this._secondary.findEnumAliases(config, enumType, enumValues, aliases);
        this._primary.findEnumAliases(config, enumType, enumValues, aliases);
    }

    @Override
    public Object findDeserializer(MapperConfig<?> config, Annotated a) {
        Object r = this._primary.findDeserializer(config, a);
        if (this._isExplicitClassOrOb(r, ValueDeserializer.None.class)) {
            return r;
        }
        return this._explicitClassOrOb(this._secondary.findDeserializer(config, a), ValueDeserializer.None.class);
    }

    @Override
    public Object findKeyDeserializer(MapperConfig<?> config, Annotated a) {
        Object r = this._primary.findKeyDeserializer(config, a);
        if (this._isExplicitClassOrOb(r, KeyDeserializer.None.class)) {
            return r;
        }
        return this._explicitClassOrOb(this._secondary.findKeyDeserializer(config, a), KeyDeserializer.None.class);
    }

    @Override
    public Object findContentDeserializer(MapperConfig<?> config, Annotated am) {
        Object r = this._primary.findContentDeserializer(config, am);
        if (this._isExplicitClassOrOb(r, ValueDeserializer.None.class)) {
            return r;
        }
        return this._explicitClassOrOb(this._secondary.findContentDeserializer(config, am), ValueDeserializer.None.class);
    }

    @Override
    public Object findDeserializationConverter(MapperConfig<?> config, Annotated a) {
        Object ob = this._primary.findDeserializationConverter(config, a);
        return ob == null ? this._secondary.findDeserializationConverter(config, a) : ob;
    }

    @Override
    public Object findDeserializationContentConverter(MapperConfig<?> config, AnnotatedMember a) {
        Object ob = this._primary.findDeserializationContentConverter(config, a);
        return ob == null ? this._secondary.findDeserializationContentConverter(config, a) : ob;
    }

    @Override
    public JavaType refineDeserializationType(MapperConfig<?> config, Annotated a, JavaType baseType) {
        JavaType t = this._secondary.refineDeserializationType(config, a, baseType);
        return this._primary.refineDeserializationType(config, a, t);
    }

    @Override
    public Object findValueInstantiator(MapperConfig<?> config, AnnotatedClass ac) {
        Object result = this._primary.findValueInstantiator(config, ac);
        return result == null ? this._secondary.findValueInstantiator(config, ac) : result;
    }

    @Override
    public Class<?> findPOJOBuilder(MapperConfig<?> config, AnnotatedClass ac) {
        Class<?> result = this._primary.findPOJOBuilder(config, ac);
        return result == null ? this._secondary.findPOJOBuilder(config, ac) : result;
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(MapperConfig<?> config, AnnotatedClass ac) {
        JsonPOJOBuilder.Value result = this._primary.findPOJOBuilderConfig(config, ac);
        return result == null ? this._secondary.findPOJOBuilderConfig(config, ac) : result;
    }

    @Override
    public PropertyName findNameForDeserialization(MapperConfig<?> config, Annotated a) {
        PropertyName n2;
        PropertyName n = this._primary.findNameForDeserialization(config, a);
        if (n == null) {
            n = this._secondary.findNameForDeserialization(config, a);
        } else if (n == PropertyName.USE_DEFAULT && (n2 = this._secondary.findNameForDeserialization(config, a)) != null) {
            n = n2;
        }
        return n;
    }

    @Override
    public Boolean hasAnySetter(MapperConfig<?> config, Annotated a) {
        Boolean b = this._primary.hasAnySetter(config, a);
        if (b == null) {
            b = this._secondary.hasAnySetter(config, a);
        }
        return b;
    }

    @Override
    public JsonSetter.Value findSetterInfo(MapperConfig<?> config, Annotated a) {
        JsonSetter.Value v2 = this._secondary.findSetterInfo(config, a);
        JsonSetter.Value v1 = this._primary.findSetterInfo(config, a);
        return v2 == null ? v1 : v2.withOverrides(v1);
    }

    @Override
    public Boolean findMergeInfo(MapperConfig<?> config, Annotated a) {
        Boolean b = this._primary.findMergeInfo(config, a);
        if (b == null) {
            b = this._secondary.findMergeInfo(config, a);
        }
        return b;
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> config, Annotated a) {
        JsonCreator.Mode mode = this._primary.findCreatorAnnotation(config, a);
        return mode == null ? this._secondary.findCreatorAnnotation(config, a) : mode;
    }

    protected boolean _isExplicitClassOrOb(Object maybeCls, Class<?> implicit) {
        if (maybeCls == null || maybeCls == implicit) {
            return false;
        }
        if (maybeCls instanceof Class) {
            return !ClassUtil.isBogusClass((Class)maybeCls);
        }
        return true;
    }

    protected Object _explicitClassOrOb(Object maybeCls, Class<?> implicit) {
        if (maybeCls == null || maybeCls == implicit) {
            return null;
        }
        if (maybeCls instanceof Class && ClassUtil.isBogusClass((Class)maybeCls)) {
            return null;
        }
        return maybeCls;
    }
}

